/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityTeleportedByPortalScriptEvent
extends BukkitScriptEvent
implements Listener {
    EntityPortalReadyEvent event;

    public EntityTeleportedByPortalScriptEvent() {
        this.registerCouldMatcher("<entity> teleported by portal");
        this.registerSwitches(new String[]{"to", "portal_type"});
        this.registerDetermination("target_world", WorldTag.class, (context, targetWorld) -> this.event.setTargetWorld(targetWorld.getWorld()));
        this.registerTextDetermination("remove_target_world", () -> this.event.setTargetWorld(null));
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryObjectSwitch("to", (ObjectTag)(this.event.getTargetWorld() == null ? null : new WorldTag(this.event.getTargetWorld())))) {
            return false;
        }
        if (!EntityTeleportedByPortalScriptEvent.runGenericSwitchCheck((ScriptEvent.ScriptPath)path, (String)"portal_type", (String)this.event.getPortalType().name())) {
            return false;
        }
        if (!path.tryArgObject(0, (ObjectTag)new EntityTag(this.event.getEntity()))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> new EntityTag(this.event.getEntity());
            case "target_world" -> {
                if (this.event.getTargetWorld() != null) {
                    yield new WorldTag(this.event.getTargetWorld());
                }
                yield null;
            }
            case "portal_type" -> new ElementTag((Enum)this.event.getPortalType());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityPortalReady(EntityPortalReadyEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

