/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.util.jnbt;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.ByteArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.ByteTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.DoubleTag;
import com.denizenscript.denizen.nms.util.jnbt.FloatTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.IntTag;
import com.denizenscript.denizen.nms.util.jnbt.LongTag;
import com.denizenscript.denizen.nms.util.jnbt.ShortTag;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import java.util.HashMap;
import java.util.Map;

public class CompoundTagBuilder {
    private final Map<String, Tag> entries;

    public CompoundTagBuilder() {
        this.entries = new HashMap<String, Tag>();
    }

    CompoundTagBuilder(Map<String, Tag> value) {
        CompoundTagBuilder.checkNotNull(value);
        this.entries = value;
    }

    public CompoundTagBuilder put(String key, Tag value) {
        CompoundTagBuilder.checkNotNull(key);
        CompoundTagBuilder.checkNotNull(value);
        this.entries.put(key, value);
        return this;
    }

    public CompoundTagBuilder putByteArray(String key, byte[] value) {
        return this.put(key, new ByteArrayTag(value));
    }

    public CompoundTagBuilder putByte(String key, byte value) {
        return this.put(key, new ByteTag(value));
    }

    public CompoundTagBuilder putBoolean(String key, boolean value) {
        return this.putByte(key, (byte)(value ? 1 : 0));
    }

    public CompoundTagBuilder putDouble(String key, double value) {
        return this.put(key, new DoubleTag(value));
    }

    public CompoundTagBuilder putFloat(String key, float value) {
        return this.put(key, new FloatTag(value));
    }

    public CompoundTagBuilder putIntArray(String key, int[] value) {
        return this.put(key, new IntArrayTag(value));
    }

    public CompoundTagBuilder putInt(String key, int value) {
        return this.put(key, new IntTag(value));
    }

    public CompoundTagBuilder putLong(String key, long value) {
        return this.put(key, new LongTag(value));
    }

    public CompoundTagBuilder putShort(String key, short value) {
        return this.put(key, new ShortTag(value));
    }

    public CompoundTagBuilder putString(String key, String value) {
        return this.put(key, new StringTag(value));
    }

    public CompoundTagBuilder putAll(Map<String, ? extends Tag> value) {
        CompoundTagBuilder.checkNotNull(value);
        for (Map.Entry<String, ? extends Tag> entry : value.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public CompoundTagBuilder remove(String key) {
        this.entries.remove(key);
        return this;
    }

    public CompoundTag build() {
        return NMSHandler.instance.createCompoundTag(new HashMap<String, Tag>(this.entries));
    }

    public static CompoundTagBuilder create() {
        return new CompoundTagBuilder();
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }
}

