/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.utilities.packets.HideParticles;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashSet;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_20_R1.CraftParticle;

public class HideParticlesPacketHandlers {
    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutWorldParticles.class, HideParticlesPacketHandlers::processParticlesForPacket);
    }

    public static Packet<PacketListenerPlayOut> processParticlesForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (HideParticles.hidden.isEmpty()) {
            return packet;
        }
        try {
            if (packet instanceof PacketPlayOutWorldParticles) {
                HashSet hidden = (HashSet)HideParticles.hidden.get(networkManager.player.ct());
                if (hidden == null) {
                    return packet;
                }
                ParticleParam particle = ((PacketPlayOutWorldParticles)packet).k();
                Particle bukkitParticle = CraftParticle.toBukkit((ParticleParam)particle);
                if (hidden.contains(bukkitParticle)) {
                    return null;
                }
                return packet;
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        return packet;
    }
}

