/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_18.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_18.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ItemHelperImpl
extends ItemHelper {
    public static Field RECIPE_MANAGER_BY_NAME = ReflectionHelper.getFields(bxp.class).get(ReflectionMappingsInfo.RecipeManager_byName, Map.class);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static bxo<?> getNMSRecipe(NamespacedKey key) {
        yt nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().aC().c.values()) {
            bxo recipe = (bxo)recipeMap.get((Object)nmsKey);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            ReflectionHelper.getFinalSetter(bus.class, (String)ReflectionMappingsInfo.Item_maxStackSize).invoke((bus)hb.X.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())), size);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Integer burnTime(Material material) {
        return (Integer)cmh.f().get(CraftMagicNumbers.getItem((Material)material));
    }

    public void clearDenizenRecipes() {
        Map byName;
        bxp recipeManager = ((CraftServer)Bukkit.getServer()).getServer().aC();
        try {
            byName = (Map)RECIPE_MANAGER_BY_NAME.get(recipeManager);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return;
        }
        for (Object2ObjectLinkedOpenHashMap recipeMap : recipeManager.c.values()) {
            for (yt key : new ArrayList(recipeMap.keySet())) {
                if (!key.b().equalsIgnoreCase("denizen")) continue;
                recipeMap.remove((Object)key);
                byName.remove(key);
            }
        }
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static bxl itemArrayToRecipe(ItemStack[] items, boolean exact) {
        bxl.a[] stacks = new bxl.a[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new bxl.a(CraftItemStack.asNMSCopy((ItemStack)items[i]));
        }
        bxl itemRecipe = new bxl(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        yt key = new yt("denizen", keyName);
        bxl itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        Object recipe = type.equalsIgnoreCase("smoker") ? new byb(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new bxd(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new bxf(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new bya(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        ((CraftServer)Bukkit.getServer()).getServer().aC().addRecipe((bxo)recipe);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        yt key = new yt("denizen", keyName);
        bxl itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        byc recipe = new byc(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().aC().addRecipe((bxo)recipe);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        yt key = new yt("denizen", keyName);
        bxl baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        bxl upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        byf recipe = new byf(key, baseItemRecipe, upgradeItemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().aC().addRecipe((bxo)recipe);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        yt key = new yt("denizen", keyName);
        ArrayList<bxl> ingredientList = new ArrayList<bxl>();
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        bxu recipe = new bxu(key, group, CraftItemStack.asNMSCopy((ItemStack)result), gx.a(null, (Object[])ingredientList.toArray(new bxl[0])));
        ((CraftServer)Bukkit.getServer()).getServer().aC().addRecipe((bxo)recipe);
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).H().c().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(ItemStack itemStack) {
        ok tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).t();
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        GameProfile profile;
        ok tag;
        buw itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        if (itemStack.s() && (tag = itemStack.t()).b("SkullOwner", 10) && (profile = ow.a((ok)tag.p("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        buw nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        ok tag = (nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack)).s() ? nmsItemStack.t() : new ok();
        tag.a("SkullOwner", (pd)ow.a((ok)new ok(), (GameProfile)gameProfile));
        nmsItemStack.c(tag);
        return CraftItemStack.asBukkitCopy((buw)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        buw nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        ok tag = nmsItemStack.s() ? nmsItemStack.t() : new ok();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.c(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((buw)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        buw nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.s()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.t());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        buw nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.c(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((buw)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().l == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(ow.a((UUID)id).f());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return ow.a((pd)new oo(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        buw nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        String jsonText = ((ok)nmsItemStack.t().c("display")).l("Name");
        BaseComponent[] nameComponent = ComponentSerializer.parse((String)jsonText);
        return FormattedTextHelper.stringify((BaseComponent[])nameComponent);
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        buw nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        oq list = ((ok)nmsItemStack.t().c("display")).c("Lore", 8);
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            BaseComponent[] lineComponent = ComponentSerializer.parse((String)list.j(i));
            outList.add(FormattedTextHelper.stringify((BaseComponent[])lineComponent));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        buw nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        ok tag = nmsItemStack.u();
        ok display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (pd)display);
        }
        if (name == null || name.isEmpty()) {
            display.a("Name", null);
            return;
        }
        BaseComponent[] components = FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE);
        display.a("Name", (pd)pb.a((String)ComponentSerializer.toString((BaseComponent[])components)));
        item.setItemStack(CraftItemStack.asBukkitCopy((buw)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        buw nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        ok tag = nmsItemStack.u();
        ok display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (pd)display);
        }
        if (lore == null || lore.isEmpty()) {
            display.a("Lore", null);
        } else {
            oq tagList = new oq();
            for (String line : lore) {
                tagList.add((Object)pb.a((String)ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse((String)line, (ChatColor)ChatColor.WHITE))));
            }
            display.a("Lore", (pd)tagList);
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((buw)nmsItemStack));
    }

    public static cov getCorrectStateForFluidBlock(cav world, cov iblockdata, gj blockposition) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            boolean isEmpty = BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
            if (!isEmpty && !iblockdata.d((cab)world, blockposition, go.b)) {
                return BlockHelperImpl.FLUIDSTATE_CREATELEGACYBLOCK.invoke(fluid);
            }
            return iblockdata;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return iblockdata;
        }
    }

    public static boolean blockStateFluidIsEmpty(cov iblockdata) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            return BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return false;
        }
    }

    public static void renderFullMap(dkf worldmap, int xMin, int zMin, int xMax, int zMax) {
        adw world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                djc materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                cra chunk = world.l(new gj(k2, 0, l2));
                if (chunk.A()) continue;
                cac chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.q_().b()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)cdr.j.n().d((cab)world, gj.b), 10);
                    } else {
                        multiset.add((Object)cdr.b.n().d((cab)world, gj.b), 100);
                    }
                    d1 = 100.0;
                } else {
                    gj.a blockposition_mutableblockposition = new gj.a();
                    gj.a blockposition_mutableblockposition1 = new gj.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            cov iblockdata;
                            int k4 = chunk.a(ctw.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.u_() + 1) {
                                iblockdata = cdr.z.n();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((gj)blockposition_mutableblockposition)).d((cab)world, (gj)blockposition_mutableblockposition) == djc.a && k4 > world.u_());
                                if (k4 > world.u_() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata)) {
                                    cov iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((hh)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((gj)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.u_() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata1));
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((cav)world, iblockdata, (gj)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((cab)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.d((cab)world, (gj)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (djc)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)djc.a)) == djc.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        dkf worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(cav.e).a("map_" + mapId);
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        bus nmsItem = hb.X.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof bta) {
            cdq block = ((bta)nmsItem).e();
            return CraftBlockData.fromData((cov)block.n());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        buw nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        buw nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return bws.a((buw)nmsInput, (buw)nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(bws.class, (String)"CUSTOM_MIXES", null)), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = CraftRecipe.toBukkit((bxl)((bxl)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix)));
                RecipeChoice input = CraftRecipe.toBukkit((bxl)((bxl)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix)));
                ItemStack result = CraftItemStack.asBukkitCopy((buw)((buw)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(ingredient, input, result);
            });
        }
        return customBrewingRecipes;
    }
}

