/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.scripts.commands.entity.FakeEquipCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FakeEquipmentPacketHandlers {
    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityEquipment.class, FakeEquipmentPacketHandlers::processEquipmentForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityStatus.class, FakeEquipmentPacketHandlers::processEquipmentForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutWindowItems.class, FakeEquipmentPacketHandlers::processEquipmentForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutSetSlot.class, FakeEquipmentPacketHandlers::processEquipmentForPacket);
    }

    public static Packet<PacketListenerPlayOut> processEquipmentForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (FakeEquipCommand.overrides.isEmpty()) {
            return packet;
        }
        try {
            if (packet instanceof PacketPlayOutEntityEquipment) {
                int eid = ((PacketPlayOutEntityEquipment)packet).a();
                Entity ent = networkManager.player.dI().a(eid);
                if (ent == null) {
                    return packet;
                }
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)ent.ct(), (Player)networkManager.player.getBukkitEntity());
                if (override == null) {
                    return packet;
                }
                ArrayList<Pair> equipment = new ArrayList<Pair>(((PacketPlayOutEntityEquipment)packet).c());
                PacketPlayOutEntityEquipment newPacket = new PacketPlayOutEntityEquipment(eid, equipment);
                for (int i = 0; i < equipment.size(); ++i) {
                    Pair pair = (Pair)equipment.get(i);
                    net.minecraft.world.item.ItemStack use = (net.minecraft.world.item.ItemStack)pair.getSecond();
                    switch ((EnumItemSlot)pair.getFirst()) {
                        case a: {
                            use = override.hand == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack());
                            break;
                        }
                        case b: {
                            use = override.offhand == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack());
                            break;
                        }
                        case e: {
                            use = override.chest == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack());
                            break;
                        }
                        case f: {
                            use = override.head == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack());
                            break;
                        }
                        case d: {
                            use = override.legs == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack());
                            break;
                        }
                        case c: {
                            use = override.boots == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack());
                        }
                    }
                    equipment.set(i, new Pair((Object)((EnumItemSlot)pair.getFirst()), (Object)use));
                }
                return newPacket;
            }
            if (packet instanceof PacketPlayOutEntityStatus) {
                Entity ent = ((PacketPlayOutEntityStatus)packet).a(networkManager.player.dI());
                if (!(ent instanceof EntityLiving)) {
                    return packet;
                }
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)ent.ct(), (Player)networkManager.player.getBukkitEntity());
                if (override == null || override.hand == null && override.offhand == null) {
                    return packet;
                }
                if (((PacketPlayOutEntityStatus)packet).a() != 55) {
                    return packet;
                }
                ArrayList<Pair> equipment = new ArrayList<Pair>();
                net.minecraft.world.item.ItemStack hand = override.hand != null ? CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()) : ((EntityLiving)ent).eO();
                net.minecraft.world.item.ItemStack offhand = override.offhand != null ? CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()) : ((EntityLiving)ent).eP();
                equipment.add(new Pair((Object)EnumItemSlot.a, (Object)hand));
                equipment.add(new Pair((Object)EnumItemSlot.b, (Object)offhand));
                PacketPlayOutEntityEquipment newPacket = new PacketPlayOutEntityEquipment(ent.af(), equipment);
                return newPacket;
            }
            if (packet instanceof PacketPlayOutWindowItems) {
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)networkManager.player.ct(), (Player)networkManager.player.getBukkitEntity());
                if (override == null) {
                    return packet;
                }
                int window = ((PacketPlayOutWindowItems)packet).a();
                if (window != 0) {
                    return packet;
                }
                NonNullList items = (NonNullList)((PacketPlayOutWindowItems)packet).c();
                if (override.head != null) {
                    items.set(5, (Object)CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack()));
                }
                if (override.chest != null) {
                    items.set(6, (Object)CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack()));
                }
                if (override.legs != null) {
                    items.set(7, (Object)CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack()));
                }
                if (override.boots != null) {
                    items.set(8, (Object)CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack()));
                }
                if (override.offhand != null) {
                    items.set(45, (Object)CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()));
                }
                if (override.hand != null) {
                    items.set(networkManager.player.fN().l + 36, (Object)CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()));
                }
                PacketPlayOutWindowItems newPacket = new PacketPlayOutWindowItems(window, ((PacketPlayOutWindowItems)packet).e(), items, ((PacketPlayOutWindowItems)packet).d());
                return newPacket;
            }
            if (packet instanceof PacketPlayOutSetSlot) {
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)networkManager.player.ct(), (Player)networkManager.player.getBukkitEntity());
                if (override == null) {
                    return packet;
                }
                int window = ((PacketPlayOutSetSlot)packet).a();
                if (window != 0) {
                    return packet;
                }
                int slot = ((PacketPlayOutSetSlot)packet).c();
                ItemStack item = null;
                if (slot == 5 && override.head != null) {
                    item = override.head.getItemStack();
                } else if (slot == 6 && override.chest != null) {
                    item = override.chest.getItemStack();
                } else if (slot == 7 && override.legs != null) {
                    item = override.legs.getItemStack();
                } else if (slot == 8 && override.boots != null) {
                    item = override.boots.getItemStack();
                } else if (slot == 45 && override.offhand != null) {
                    item = override.offhand.getItemStack();
                } else if (slot == networkManager.player.fN().l + 36 && override.hand != null) {
                    item = override.hand.getItemStack();
                }
                if (item == null) {
                    return packet;
                }
                PacketPlayOutSetSlot newPacket = new PacketPlayOutSetSlot(window, ((PacketPlayOutSetSlot)packet).e(), slot, CraftItemStack.asNMSCopy((ItemStack)item));
                return newPacket;
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        return packet;
    }
}

