/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.npc.traits.ConstantsTrait;
import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.event.EventHandler;

public class AssignmentTrait
extends Trait {
    @Persist(value="assignment")
    public String legacyAssignment = "";
    @Persist(value="assignment_list")
    public ArrayList<String> assignments = new ArrayList();
    public ArrayList<AssignmentScriptContainer> containerCache = new ArrayList();

    public AssignmentTrait() {
        super("assignment");
    }

    public void load(DataKey key) {
        if (this.legacyAssignment != null && !this.legacyAssignment.isEmpty()) {
            this.assignments.add(CoreUtilities.toLowerCase(this.legacyAssignment));
            this.legacyAssignment = "";
        }
        this.buildCache();
        if (this.assignments.isEmpty()) {
            Debug.echoError("NPC " + this.npc.getId() + " had assignment trait without any assignments? Removing.");
            this.npc.removeTrait(AssignmentTrait.class);
            return;
        }
        List fixedAssignments = this.assignments.stream().map(CoreUtilities::toLowerCase).collect(Collectors.toList());
        this.assignments.clear();
        this.assignments.addAll(fixedAssignments);
        ((ConstantsTrait)this.npc.getOrAddTrait(ConstantsTrait.class)).rebuildAssignmentConstants();
    }

    public void buildCache() {
        this.containerCache.clear();
        for (String assignment : this.assignments) {
            AssignmentScriptContainer container = (AssignmentScriptContainer)ScriptRegistry.getScriptContainer(assignment);
            this.containerCache.add(container);
            if (container != null) continue;
            Debug.echoError("NPC " + this.npc.getId() + " has assignment '" + assignment + "' which does not exist.");
        }
    }

    @EventHandler
    public void onReload(ScriptReloadEvent event) {
        this.buildCache();
    }

    public boolean addAssignmentScript(AssignmentScriptContainer script, PlayerTag player) {
        String name = CoreUtilities.toLowerCase(script.getName());
        if (this.assignments.contains(name)) {
            return false;
        }
        this.assignments.add(name);
        this.containerCache.add(script);
        this.ensureDefaultTraits();
        Denizen.getInstance().npcHelper.getActionHandler().doAction("assignment", new NPCTag(this.npc), player, script, null);
        return true;
    }

    public boolean removeAssignmentScript(String name, PlayerTag player) {
        int index = this.assignments.indexOf(CoreUtilities.toLowerCase(name));
        if (index == -1) {
            return false;
        }
        this.assignments.remove(index);
        AssignmentScriptContainer container = this.containerCache.remove(index);
        if (container != null) {
            Denizen.getInstance().npcHelper.getActionHandler().doAction("remove assignment", new NPCTag(this.npc), player, container, null);
        }
        return true;
    }

    public void clearAssignments(PlayerTag player) {
        for (String assign : new ArrayList<String>(this.assignments)) {
            this.removeAssignmentScript(assign, player);
        }
    }

    public void checkAutoRemove() {
        if (this.assignments.isEmpty()) {
            this.npc.removeTrait(AssignmentTrait.class);
        }
    }

    public void ensureDefaultTraits() {
        this.npc.getOrAddTrait(TriggerTrait.class);
        ((ConstantsTrait)this.npc.getOrAddTrait(ConstantsTrait.class)).rebuildAssignmentConstants();
        if (Settings.healthTraitEnabledByDefault()) {
            this.npc.getOrAddTrait(HealthTrait.class);
        }
    }

    public boolean isAssigned(AssignmentScriptContainer container) {
        return this.containerCache.contains(container);
    }
}

