/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.npc.speech.DenizenSpeechContext;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.TalkableEntity;
import net.citizensnpcs.api.ai.speech.event.NPCSpeechEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class ChatCommand
extends AbstractCommand {
    public ChatCommand() {
        this.setName("chat");
        this.setSyntax("chat [<text>] (no_target/targets:<entity>|...) (talkers:<entity>|...) (range:<#.#>)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
        this.addRemappedPrefixes("targets", "target", "t");
        this.addRemappedPrefixes("talkers", "talker");
        this.addRemappedPrefixes("range", "r");
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="message") @ArgLinear String message, @ArgName(value="talkers") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=EntityTag.class) List<EntityTag> talkers, @ArgName(value="targets") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=EntityTag.class) List<EntityTag> targets, @ArgName(value="no_target") boolean noTarget, @ArgName(value="range") @ArgPrefixed @ArgDefaultText(value="-1") double chatRange) {
        if (targets == null && !noTarget) {
            PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
            if (player == null) {
                throw new InvalidArgumentsRuntimeException("Missing targets!");
            }
            if (!player.isOnline()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Player is not online, skipping.");
                return;
            }
            targets = Collections.singletonList(player.getDenizenEntity());
        }
        if (talkers == null) {
            NPCTag talker = Utilities.getEntryNPC(scriptEntry);
            if (talker == null) {
                throw new InvalidArgumentsRuntimeException("Missing talker!");
            }
            if (!talker.isSpawned()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Chat Talker is not spawned! Cannot talk.");
                return;
            }
            talkers = Collections.singletonList(talker.getDenizenEntity());
        }
        if (chatRange == -1.0) {
            chatRange = Settings.chatBystandersRange();
        }
        DenizenSpeechContext context = new DenizenSpeechContext(message, scriptEntry, chatRange);
        if (targets != null && !targets.isEmpty()) {
            for (EntityTag ent : targets) {
                context.addRecipient(ent.getBukkitEntity());
            }
        }
        for (EntityTag talker : talkers) {
            Entity entity = talker.getBukkitEntity();
            if (entity != null) {
                context.setTalker(entity);
                ChatCommand.speak(context);
                continue;
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Chat Talker is not spawned! Cannot talk.");
        }
    }

    public static void speak(DenizenSpeechContext speechContext) {
        Entity talker = speechContext.getTalker().getEntity();
        if (EntityTag.isCitizensNPC(talker)) {
            NPCSpeechEvent event = new NPCSpeechEvent((SpeechContext)speechContext);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        ScriptQueue queue = speechContext.getScriptEntry().getResidingQueue();
        ObjectTag defTalker = queue.getDefinitionObject("talker");
        ObjectTag defMessage = queue.getDefinitionObject("message");
        queue.addDefinition("talker", new EntityTag(talker));
        queue.addDefinition("message", new ElementTag(speechContext.getMessage(), true));
        ChatCommand.talk(speechContext, queue);
        if (defMessage != null) {
            queue.addDefinition("message", defMessage);
        }
        if (defTalker != null) {
            queue.addDefinition("talker", defTalker);
        }
    }

    private static void talk(DenizenSpeechContext speechContext, ScriptQueue queue) {
        BukkitTagContext tagContext = new BukkitTagContext(speechContext.getScriptEntry());
        if (!speechContext.hasRecipients()) {
            String text = TagManager.tag(Settings.chatNoTargetFormat(), tagContext);
            ChatCommand.talkToBystanders(text, speechContext);
            return;
        }
        String text = PaperAPITools.instance.convertTextToMiniMessage(TagManager.tag(Settings.chatToTargetFormat(), tagContext), true);
        Iterator iterator = speechContext.iterator();
        while (iterator.hasNext()) {
            Talkable entity = (Talkable)iterator.next();
            entity.talkTo((SpeechContext)speechContext, text);
        }
        if (!speechContext.isBystandersEnabled()) {
            return;
        }
        if (speechContext.size() == 1) {
            ObjectTag defTarget = queue.getDefinitionObject("target");
            queue.addDefinition("target", new EntityTag(((Talkable)speechContext.iterator().next()).getEntity()));
            ChatCommand.talkToBystanders(TagManager.tag(Settings.chatWithTargetToBystandersFormat(), tagContext), speechContext);
            if (defTarget != null) {
                queue.addDefinition("target", defTarget);
            }
            return;
        }
        String[] format = Settings.chatMultipleTargetsFormat().split("%target%");
        if (format.length <= 1) {
            Debug.echoError("Invalid 'Commands.Chat.Options.Multiple targets format' in config.yml! Must have at least 1 %target%");
        }
        StringBuilder parsed = new StringBuilder();
        int i = 0;
        Iterator iterator2 = speechContext.iterator();
        while (iterator2.hasNext()) {
            Talkable target = (Talkable)iterator2.next();
            parsed.append(format[i]);
            if (i == format.length - 1) break;
            parsed.append(new EntityTag(target.getEntity()).getName());
            ++i;
        }
        String targets = TagManager.tag(parsed.toString(), tagContext);
        ObjectTag defTargets = queue.getDefinitionObject("targets");
        queue.addDefinition("targets", new ElementTag(targets, true));
        String bystanderText = TagManager.tag(Settings.chatWithTargetsToBystandersFormat(), tagContext);
        ChatCommand.talkToBystanders(bystanderText, speechContext);
        if (defTargets != null) {
            queue.addDefinition("targets", defTargets);
        }
    }

    private static void talkToBystanders(String text, DenizenSpeechContext speechContext) {
        HashSet<UUID> recipients = new HashSet<UUID>(speechContext.size());
        Iterator iterator = speechContext.iterator();
        while (iterator.hasNext()) {
            Talkable recipient = (Talkable)iterator.next();
            recipients.add(recipient.getEntity().getUniqueId());
        }
        String parsedText = PaperAPITools.instance.convertTextToMiniMessage(text, true);
        double range = speechContext.getChatRange();
        for (Entity bystander : range == 0.0 ? Bukkit.getOnlinePlayers() : speechContext.getTalker().getEntity().getNearbyEntities(range, range, range)) {
            if (recipients.contains(bystander.getUniqueId())) continue;
            new TalkableEntity(bystander).talkNear((SpeechContext)speechContext, parsedText);
        }
    }
}

