/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class FishingHelperImpl
implements FishingHelper {
    public static final Field FISHING_HOOK_NIBBLE = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_nibble, Integer.TYPE);
    public static final Field FISHING_HOOK_LURE_TIME = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilLured, Integer.TYPE);
    public static final Field FISHING_HOOK_HOOK_TIME = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilHooked, Integer.TYPE);

    @Override
    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        net.minecraft.world.item.ItemStack result = switch (catchType) {
            case FishingHelper.CatchType.DEFAULT -> {
                float f = ((CraftWorld)fishHook.getWorld()).getHandle().z.i();
                int i = EnchantmentManager.h((EntityLiving)nmsHook.s());
                int j = EnchantmentManager.a((Enchantment)Enchantments.C, (EntityLiving)nmsHook.s());
                float f1 = 0.1f - (float)i * 0.025f - (float)j * 0.01f;
                float f2 = 0.05f + (float)i * 0.01f - (float)j * 0.01f;
                f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
                f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
                if (f < f1) {
                    yield this.catchRandomJunk(nmsHook);
                }
                if ((f -= f1) < f2) {
                    yield this.catchRandomTreasure(nmsHook);
                }
                yield this.catchRandomFish(nmsHook);
            }
            case FishingHelper.CatchType.JUNK -> this.catchRandomJunk(nmsHook);
            case FishingHelper.CatchType.TREASURE -> this.catchRandomTreasure(nmsHook);
            case FishingHelper.CatchType.FISH -> this.catchRandomFish(nmsHook);
            default -> null;
        };
        return result != null ? CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)result) : null;
    }

    public net.minecraft.world.item.ItemStack getRandomReward(EntityFishingHook nmsHook, MinecraftKey key) {
        WorldServer nmsWorld = (WorldServer)nmsHook.dL();
        IdentityHashMap params = Maps.newIdentityHashMap();
        params.put(LootContextParameters.f, new Vec3D(nmsHook.dq(), nmsHook.ds(), nmsHook.dw()));
        params.put(LootContextParameters.i, new net.minecraft.world.item.ItemStack((IMaterial)Items.qh));
        LootParams nmsLootParams = new LootParams(nmsWorld, (Map)params, (Map)Maps.newHashMap(), 0.0f);
        ObjectArrayList nmsItems = nmsWorld.n().aH().getLootTable(key).a(nmsLootParams);
        return (net.minecraft.world.item.ItemStack)nmsItems.get(nmsWorld.z.a(nmsItems.size()));
    }

    @Override
    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((EntityHuman)((CraftPlayer)player).getHandle(), (World)nmsWorld, 0, 0);
        nmsWorld.addFreshEntity((Entity)hook, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FishHook)hook.getBukkitEntity();
    }

    private net.minecraft.world.item.ItemStack catchRandomJunk(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTables.aj);
    }

    private net.minecraft.world.item.ItemStack catchRandomTreasure(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTables.ak);
    }

    private net.minecraft.world.item.ItemStack catchRandomFish(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTables.al);
    }

    @Override
    public FishHook getHookFrom(Player player) {
        EntityFishingHook nmsHook = ((CraftPlayer)player).getHandle().ck;
        if (nmsHook == null) {
            return null;
        }
        return (FishHook)nmsHook.getBukkitEntity();
    }

    @Override
    public void setNibble(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_NIBBLE.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void setHookTime(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_HOOK_TIME.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public int getLureTime(FishHook hook) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            return FISHING_HOOK_LURE_TIME.getInt(nmsHook);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return -1;
        }
    }

    @Override
    public void setLureTime(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_LURE_TIME.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }
}

