/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataAction;
import com.denizenscript.denizencore.utilities.data.DataActionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class FlagCommand
extends AbstractCommand {
    public static List<Consumer<AbstractCommand.TabCompletionsBuilder>> flagTabCompleters = new ArrayList<Consumer<AbstractCommand.TabCompletionsBuilder>>();

    public FlagCommand() {
        this.setName("flag");
        this.setSyntax("flag [<object>|...] [<name>([<#>])](:<action>)[:<value>] (expire:<time>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
        this.allowedDynamicPrefixes = true;
    }

    public static void tabCompleteFlag(AbstractCommand.TabCompletionsBuilder tab) {
        if (tab.arg.contains(":")) {
            return;
        }
        for (String string : DenizenCore.serverFlagMap.listAllFlags()) {
            if (string.startsWith("__")) continue;
            tab.add(string);
        }
        for (Consumer consumer : flagTabCompleters) {
            consumer.accept(tab);
        }
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        FlagCommand.tabCompleteFlag(tab);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("targets") && !arg.hasPrefix()) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("expiration") && arg.matchesPrefix("expire", "expires", "expiration", "duration") && arg.matchesArgumentType(TimeTag.class)) {
                scriptEntry.addObject("expiration", arg.asType(TimeTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("expiration") && arg.matchesPrefix("expire", "expires", "expiration", "duration") && arg.matchesArgumentType(DurationTag.class)) {
                TimeTag now = TimeTag.now();
                scriptEntry.addObject("expiration", new TimeTag(now.millis() + arg.asType(DurationTag.class).getMillis(), now.instant.getZone()));
                continue;
            }
            if (!scriptEntry.hasObject("flag_action")) {
                scriptEntry.addObject("flag_action", DataActionHelper.parse((ActionableDataProvider)new FlagActionProvider(), arg, scriptEntry.context));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targets")) {
            throw new InvalidArgumentsException("Must specify flag target(s)!");
        }
        if (!scriptEntry.hasObject("flag_action")) {
            throw new InvalidArgumentsException("Must specify a flag to set!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag targets = (ListTag)scriptEntry.getObjectTag("targets");
        TimeTag expiration = (TimeTag)scriptEntry.getObjectTag("expiration");
        DataAction flagAction = (DataAction)scriptEntry.getObject("flag_action");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), targets, expiration, flagAction);
        }
        ((FlagActionProvider)flagAction.provider).expiration = expiration;
        for (ObjectTag object : targets.objectForms) {
            AbstractFlagTracker tracker;
            if (CoreUtilities.equalsIgnoreCase(object.toString(), "server")) {
                tracker = DenizenCore.serverFlagMap;
            } else if (object instanceof FlaggableObject) {
                tracker = ((FlaggableObject)object).getFlagTracker();
                if (tracker == null) {
                    Debug.echoError("The object type '" + object.getDenizenObjectType() + "' is flaggable, however the instance '" + object + "' is not: " + ((FlaggableObject)object).getReasonNotFlaggable());
                    continue;
                }
            } else {
                FlaggableObject obj = DenizenCore.implementation.simpleWordToFlaggable(object.toString(), scriptEntry);
                if (obj != null) {
                    tracker = obj.getFlagTracker();
                } else {
                    if (object instanceof ElementTag && !object.toString().contains("@")) {
                        Debug.echoError("Cannot flag '" + object + "': that does not appear to be an object! Only objects (like an EntityTag) and special keyword 'server' are flaggable!");
                        continue;
                    }
                    Debug.echoError("Cannot flag '" + object + "': that object type is not flaggable!");
                    continue;
                }
            }
            if (tracker == null) {
                Debug.echoError("Something went wrong, cannot flag '" + object + "'...");
                continue;
            }
            ((FlagActionProvider)flagAction.provider).tracker = tracker;
            flagAction.execute(scriptEntry.getContext());
            if (!(object instanceof FlaggableObject)) continue;
            ((FlaggableObject)object).reapplyTracker(tracker);
        }
    }

    public static class FlagActionProvider
    extends ActionableDataProvider {
        public AbstractFlagTracker tracker;
        public TimeTag expiration;

        @Override
        public ObjectTag getValueAt(String keyName) {
            return this.tracker.getFlagValue(keyName);
        }

        @Override
        public void setValueAt(String keyName, ObjectTag value) {
            if (keyName.equals("__raw")) {
                MapTag toSetMap = value.asType(MapTag.class, CoreUtilities.noDebugContext);
                ObjectTag toClear = toSetMap.getObject("__clear");
                if (toClear != null) {
                    for (String string : toClear.asType(ListTag.class, CoreUtilities.noDebugContext)) {
                        if (toSetMap.getObject(string) != null) continue;
                        this.tracker.setRootMap(string, null);
                    }
                }
                for (Map.Entry entry : toSetMap.entrySet()) {
                    if (((StringHolder)entry.getKey()).low.equals("__clear")) continue;
                    this.tracker.setRootMap(((StringHolder)entry.getKey()).str, (MapTag)entry.getValue());
                }
                return;
            }
            if (keyName.startsWith("__")) {
                Debug.echoError("Assigning flag value to reserved '__' namespace (key: '" + keyName + "')");
            }
            this.tracker.setFlag(keyName, value, this.expiration);
        }
    }
}

