/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;

public class EntityDataNameMapper {
    public static final Map<Class<? extends Entity>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends Entity>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends Entity> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends Entity> entityClass, String name) {
        Class<? extends Entity> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(Entity.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(Entity.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(Entity.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(Entity.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(Entity.class, 4, "silent");
        EntityDataNameMapper.registerDataName(Entity.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(Entity.class, 6, "pose");
        EntityDataNameMapper.registerDataName(Entity.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(Interaction.class, 8, "width");
        EntityDataNameMapper.registerDataName(Interaction.class, 9, "height");
        EntityDataNameMapper.registerDataName(Interaction.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(Display.class, 8, "interpolation_delay");
        EntityDataNameMapper.registerDataName(Display.class, 9, "interpolation_duration");
        EntityDataNameMapper.registerDataName(Display.class, 10, "translation");
        EntityDataNameMapper.registerDataName(Display.class, 11, "scale");
        EntityDataNameMapper.registerDataName(Display.class, 12, "left_rotation");
        EntityDataNameMapper.registerDataName(Display.class, 13, "right_rotation");
        EntityDataNameMapper.registerDataName(Display.class, 14, "billboard");
        EntityDataNameMapper.registerDataName(Display.class, 15, "brightness");
        EntityDataNameMapper.registerDataName(Display.class, 16, "view_range");
        EntityDataNameMapper.registerDataName(Display.class, 17, "shadow_radius");
        EntityDataNameMapper.registerDataName(Display.class, 18, "shadow_strength");
        EntityDataNameMapper.registerDataName(Display.class, 19, "width");
        EntityDataNameMapper.registerDataName(Display.class, 20, "height");
        EntityDataNameMapper.registerDataName(Display.class, 21, "glow_color");
        EntityDataNameMapper.registerDataName(Display.BlockDisplay.class, 22, "material");
        EntityDataNameMapper.registerDataName(Display.ItemDisplay.class, 22, "item");
        EntityDataNameMapper.registerDataName(Display.ItemDisplay.class, 23, "model_transform");
        EntityDataNameMapper.registerDataName(Display.TextDisplay.class, 22, "text");
        EntityDataNameMapper.registerDataName(Display.TextDisplay.class, 23, "line_width");
        EntityDataNameMapper.registerDataName(Display.TextDisplay.class, 24, "background_color");
        EntityDataNameMapper.registerDataName(Display.TextDisplay.class, 25, "text_opacity");
        EntityDataNameMapper.registerDataName(Display.TextDisplay.class, 26, "text_display_flags");
        EntityDataNameMapper.registerDataName(EntityProjectile.class, 8, "item");
        EntityDataNameMapper.registerDataName(EntityEnderSignal.class, 8, "item");
        EntityDataNameMapper.registerDataName(EntityFireworks.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(EntityAreaEffectCloud.class, 8, "radius");
        EntityDataNameMapper.registerDataName(EntityAreaEffectCloud.class, 9, "color");
        EntityDataNameMapper.registerDataName(EntityAreaEffectCloud.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(EntityAreaEffectCloud.class, 11, "particle");
        EntityDataNameMapper.registerDataName(EntityFishingHook.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(EntityFishingHook.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(EntityArrow.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(EntityArrow.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(EntityTippedArrow.class, 10, "color");
        EntityDataNameMapper.registerDataName(EntityThrownTrident.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(EntityThrownTrident.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(EntityBoat.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(EntityBoat.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(EntityBoat.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(EntityBoat.class, 11, "type");
        EntityDataNameMapper.registerDataName(EntityBoat.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(EntityBoat.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(EntityBoat.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(EntityEnderCrystal.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(EntityEnderCrystal.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(EntitySmallFireball.class, 8, "item");
        EntityDataNameMapper.registerDataName(EntityFireballFireball.class, 8, "item");
        EntityDataNameMapper.registerDataName(EntityWitherSkull.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(EntityFireworks.class, 8, "item");
        EntityDataNameMapper.registerDataName(EntityFireworks.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(EntityFireworks.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(EntityItemFrame.class, 8, "item");
        EntityDataNameMapper.registerDataName(EntityItemFrame.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(EntityPainting.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(EntityLiving.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(EntityLiving.class, 9, "health");
        EntityDataNameMapper.registerDataName(EntityLiving.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(EntityLiving.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(EntityLiving.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(EntityLiving.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(EntityLiving.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(EntityHuman.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(EntityHuman.class, 16, "score");
        EntityDataNameMapper.registerDataName(EntityHuman.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(EntityHuman.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(EntityHuman.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(EntityHuman.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(EntityArmorStand.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(EntityArmorStand.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(EntityArmorStand.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(EntityArmorStand.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(EntityArmorStand.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(EntityArmorStand.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(EntityArmorStand.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(EntityInsentient.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(EntityBat.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(EntityDolphin.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(EntityDolphin.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(EntityDolphin.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(EntityFish.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(EntityPufferFish.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(EntityTropicalFish.class, 17, "variant");
        EntityDataNameMapper.registerDataName(EntityAgeable.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(Sniffer.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(Sniffer.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(EntityHorseAbstract.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(EntityHorse.class, 18, "variant");
        EntityDataNameMapper.registerDataName(Camel.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(Camel.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(EntityHorseChestedAbstract.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(EntityLlama.class, 19, "strength");
        EntityDataNameMapper.registerDataName(EntityLlama.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(EntityLlama.class, 21, "variant");
        EntityDataNameMapper.registerDataName(Axolotl.class, 17, "variant");
        EntityDataNameMapper.registerDataName(Axolotl.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(Axolotl.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(EntityBee.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(EntityBee.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(EntityFox.class, 17, "type");
        EntityDataNameMapper.registerDataName(EntityFox.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(EntityFox.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(EntityFox.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(Frog.class, 17, "variant");
        EntityDataNameMapper.registerDataName(Frog.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(EntityOcelot.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(EntityPanda.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(EntityPanda.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(EntityPanda.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(EntityPanda.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(EntityPanda.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(EntityPanda.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(EntityPig.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(EntityPig.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(EntityRabbit.class, 17, "type");
        EntityDataNameMapper.registerDataName(EntityTurtle.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(EntityTurtle.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(EntityTurtle.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(EntityTurtle.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(EntityTurtle.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(EntityTurtle.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(EntityPolarBear.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(EntityHoglin.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(EntityMushroomCow.class, 17, "variant");
        EntityDataNameMapper.registerDataName(EntitySheep.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(EntityStrider.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(EntityStrider.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(EntityStrider.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(EntityTameableAnimal.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(EntityTameableAnimal.class, 18, "owner");
        EntityDataNameMapper.registerDataName(EntityCat.class, 19, "variant");
        EntityDataNameMapper.registerDataName(EntityCat.class, 20, "lying");
        EntityDataNameMapper.registerDataName(EntityCat.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(EntityCat.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(EntityWolf.class, 19, "begging");
        EntityDataNameMapper.registerDataName(EntityWolf.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(EntityWolf.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(EntityParrot.class, 19, "variant");
        EntityDataNameMapper.registerDataName(EntityVillagerAbstract.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(EntityVillager.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(EntityIronGolem.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(EntitySnowman.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(EntityShulker.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(EntityShulker.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(EntityShulker.class, 18, "peek");
        EntityDataNameMapper.registerDataName(EntityShulker.class, 19, "color");
        EntityDataNameMapper.registerDataName(EntityPiglinAbstract.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(EntityPiglin.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(EntityPiglin.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(EntityPiglin.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(EntityBlaze.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(EntityCreeper.class, 16, "state");
        EntityDataNameMapper.registerDataName(EntityCreeper.class, 17, "charged");
        EntityDataNameMapper.registerDataName(EntityCreeper.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(Goat.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(Goat.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(Goat.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(EntityGuardian.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(EntityGuardian.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(EntityRaider.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(EntityPillager.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(EntityIllagerWizard.class, 17, "spell");
        EntityDataNameMapper.registerDataName(EntityWitch.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(EntityVex.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(EntitySpider.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(Warden.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(EntityWither.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(EntityWither.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(EntityWither.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(EntityWither.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(EntityZoglin.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(EntityZombie.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(EntityZombie.class, 17, "type");
        EntityDataNameMapper.registerDataName(EntityZombie.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(EntityZombieVillager.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(EntityZombieVillager.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(EntityEnderman.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(EntityEnderman.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(EntityEnderman.class, 18, "staring");
        EntityDataNameMapper.registerDataName(EntityEnderDragon.class, 16, "phase");
        EntityDataNameMapper.registerDataName(EntityGhast.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(EntityPhantom.class, 16, "size");
        EntityDataNameMapper.registerDataName(EntitySlime.class, 16, "size");
        EntityDataNameMapper.registerDataName(EntityMinecartAbstract.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(EntityMinecartAbstract.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(EntityMinecartAbstract.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(EntityMinecartAbstract.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(EntityMinecartAbstract.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(EntityMinecartAbstract.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(EntityMinecartFurnace.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(EntityMinecartCommandBlock.class, 14, "command");
        EntityDataNameMapper.registerDataName(EntityMinecartCommandBlock.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(EntityTNTPrimed.class, 8, "fuse_ticks");
    }
}

