/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Arrays;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.util.Anchor;
import org.bukkit.Location;

public class AnchorCommand
extends AbstractCommand {
    public AnchorCommand() {
        this.setName("anchor");
        this.setSyntax("anchor [id:<name>] [remove/add <location>]");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("range") && arg.matchesFloat() && arg.matchesPrefix("range", "r")) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id", "i")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an 'Anchor Action'. Valid: " + Arrays.asList(Action.values()));
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an ID.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag range = scriptEntry.getElement("range");
        ElementTag id = scriptEntry.getElement("id");
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), npc, AnchorCommand.db("action", action.name()), id, location, range);
        }
        Anchors anchors = (Anchors)npc.getCitizen().getOrAddTrait(Anchors.class);
        switch (action) {
            case ADD: {
                if (location == null) {
                    Debug.echoError("Must specify a location!");
                    return;
                }
                Anchor existing = anchors.getAnchor(id.asString());
                if (existing != null) {
                    anchors.removeAnchor(existing);
                }
                anchors.addAnchor(id.asString(), (Location)location);
                break;
            }
            case REMOVE: {
                Anchor n = anchors.getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry, "Invalid anchor name '" + id.asString() + "'");
                    break;
                }
                anchors.removeAnchor(n);
                break;
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE;

    }
}

