/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public abstract class EntityHelper {
    public abstract void setInvisible(Entity var1, boolean var2);

    public abstract boolean isInvisible(Entity var1);

    public abstract void setPose(Entity var1, Pose var2);

    public void setSneaking(Entity entity, boolean sneak) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.setSneaking(sneak);
        }
        this.setPose(entity, sneak ? Pose.SNEAKING : Pose.STANDING);
    }

    public abstract double getDamageTo(LivingEntity var1, Entity var2);

    public abstract void setRiptide(Entity var1, boolean var2);

    public abstract void forceInteraction(Player var1, Location var2);

    public abstract Entity getEntity(World var1, UUID var2);

    public abstract CompoundTag getNbtData(Entity var1);

    public abstract void setNbtData(Entity var1, CompoundTag var2);

    public abstract void stopFollowing(Entity var1);

    public abstract void stopWalking(Entity var1);

    public abstract void follow(Entity var1, Entity var2, double var3, double var5, double var7, boolean var9, boolean var10);

    public abstract void walkTo(LivingEntity var1, Location var2, Double var3, Runnable var4);

    public abstract void sendHidePacket(Player var1, Entity var2);

    public abstract void sendShowPacket(Player var1, Entity var2);

    public abstract void rotate(Entity var1, float var2, float var3);

    public abstract float getBaseYaw(LivingEntity var1);

    public abstract void look(Entity var1, float var2, float var3);

    public MapTag mapTrace(LivingEntity inputEntity) {
        double range = 200.0;
        Location start = inputEntity.getEyeLocation();
        Vector startVec = start.toVector();
        Vector direction = start.getDirection();
        double bestDist = Double.MAX_VALUE;
        ItemFrame best = null;
        Vector bestHitPos = null;
        BlockFace bestHitFace = null;
        for (Entity entity : start.getWorld().getNearbyEntities(start.clone().add(direction.clone().multiply(50)), 100.0, 100.0, 100.0, e -> {
            ItemFrame itemFrame;
            return e instanceof ItemFrame && (itemFrame = (ItemFrame)e).getItem().getType() == Material.FILLED_MAP;
        })) {
            RayTraceResult traced;
            double centerDist = entity.getLocation().distanceSquared(start);
            if (centerDist > bestDist) continue;
            ItemFrame frame = (ItemFrame)entity;
            double EXP_RATE = 0.125;
            double expandX = 0.0;
            double expandY = 0.0;
            double expandZ = 0.0;
            BlockFace face = frame.getFacing();
            switch (face) {
                case SOUTH: 
                case NORTH: {
                    expandX = EXP_RATE;
                    expandY = EXP_RATE;
                    break;
                }
                case EAST: 
                case WEST: {
                    expandZ = EXP_RATE;
                    expandY = EXP_RATE;
                    break;
                }
                case UP: 
                case DOWN: {
                    expandX = EXP_RATE;
                    expandZ = EXP_RATE;
                }
            }
            if ((traced = frame.getBoundingBox().expand(expandX, expandY, expandZ).rayTrace(startVec, direction, range)) == null || traced.getHitBlockFace() == null || traced.getHitBlockFace() != face) continue;
            bestDist = centerDist;
            best = frame;
            bestHitPos = traced.getHitPosition();
            bestHitFace = face;
        }
        if (best == null) {
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        double basex = bestHitPos.getX() - Math.floor(bestHitPos.getX());
        double basey = bestHitPos.getY() - Math.floor(bestHitPos.getY());
        double basez = bestHitPos.getZ() - Math.floor(bestHitPos.getZ());
        switch (bestHitFace) {
            case NORTH: {
                x = 128.0 - basex * 128.0;
                y = 128.0 - basey * 128.0;
                break;
            }
            case SOUTH: {
                x = basex * 128.0;
                y = 128.0 - basey * 128.0;
                break;
            }
            case WEST: {
                x = basez * 128.0;
                y = 128.0 - basey * 128.0;
                break;
            }
            case EAST: {
                x = 128.0 - basez * 128.0;
                y = 128.0 - basey * 128.0;
                break;
            }
            case UP: {
                x = basex * 128.0;
                y = basez * 128.0;
                break;
            }
            case DOWN: {
                x = basex * 128.0;
                y = 128.0 - basez * 128.0;
            }
        }
        MapMeta map = (MapMeta)best.getItem().getItemMeta();
        switch (best.getRotation()) {
            case CLOCKWISE_45: 
            case FLIPPED_45: {
                double origX = x;
                x = y;
                y = 128.0 - origX;
                break;
            }
            case CLOCKWISE: 
            case COUNTER_CLOCKWISE: {
                x = 128.0 - x;
                y = 128.0 - y;
                break;
            }
            case CLOCKWISE_135: 
            case COUNTER_CLOCKWISE_45: {
                double origX2 = x;
                x = 128.0 - y;
                y = origX2;
            }
        }
        MapTag result = new MapTag();
        result.putObject("x", (ObjectTag)new ElementTag(Math.round(x)));
        result.putObject("y", (ObjectTag)new ElementTag(Math.round(y)));
        result.putObject("entity", (ObjectTag)new EntityTag((Entity)best));
        result.putObject("map", (ObjectTag)new ElementTag(map.hasMapId() ? map.getMapId() : 0));
        return result;
    }

    public abstract boolean canTrace(World var1, Vector var2, Vector var3);

    public Location faceLocation(Location from, Location at) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        Location newLocation = from.clone();
        newLocation.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(direction.getX(), direction.getZ())));
        newLocation.setPitch(90.0f - (float)Math.toDegrees(Math.acos(direction.getY())));
        return newLocation;
    }

    public boolean internalLook(Player player, Location at) {
        return false;
    }

    public void faceLocation(Entity from, Location at) {
        Location location;
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        if (EntityTag.isPlayer(from) && this.internalLook((Player)from, at)) {
            return;
        }
        if (from instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)from;
            location = livingEntity.getEyeLocation();
        } else {
            location = new LocationTag(from.getLocation()).getBlockLocation().add(0.5, 0.5, 0.5);
        }
        Location origin = location;
        Location rotated = this.faceLocation(origin, at);
        this.rotate(from, rotated.getYaw(), rotated.getPitch());
    }

    public boolean isFacingLocation(Location from, Location at, float yawLimitDegrees, float pitchLimitDegrees) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        float pitch = 90.0f - (float)Math.toDegrees(Math.acos(direction.getY()));
        if (from.getPitch() > pitch + pitchLimitDegrees || from.getPitch() < pitch - pitchLimitDegrees) {
            return false;
        }
        return this.isFacingLocation(from, at, yawLimitDegrees);
    }

    public boolean isFacingLocation(Location from, Location at, float degreeLimit) {
        double currentYaw = EntityHelper.normalizeYaw(from.getYaw());
        double requiredYaw = EntityHelper.normalizeYaw(this.getYaw(at.toVector().subtract(from.toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    public boolean isFacingLocation(Entity from, Location at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at, degreeLimit);
    }

    public boolean isFacingEntity(Entity from, Entity at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at.getLocation(), degreeLimit);
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = (float)((double)yaw + 360.0);
        }
        return yaw;
    }

    public float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    public String getCardinal(float yaw) {
        if (0.0f <= (yaw = EntityHelper.normalizeYaw(yaw)) && (double)yaw < 22.5) {
            return "south";
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return "southwest";
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return "west";
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return "northwest";
        }
        if (157.5 <= (double)yaw && (double)yaw < 202.5) {
            return "north";
        }
        if (202.5 <= (double)yaw && (double)yaw < 247.5) {
            return "northeast";
        }
        if (247.5 <= (double)yaw && (double)yaw < 292.5) {
            return "east";
        }
        if (292.5 <= (double)yaw && (double)yaw < 337.5) {
            return "southeast";
        }
        if (337.5 <= (double)yaw && (double)yaw < 360.0) {
            return "south";
        }
        return null;
    }

    public abstract void snapPositionTo(Entity var1, Vector var2);

    public abstract void move(Entity var1, Vector var2);

    public void fakeMove(Entity entity, Vector vector) {
        throw new UnsupportedOperationException();
    }

    public void fakeTeleport(Entity entity, Location location) {
        throw new UnsupportedOperationException();
    }

    public void clientResetLoc(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public abstract void teleport(Entity var1, Location var2);

    public abstract void setBoundingBox(Entity var1, BoundingBox var2);

    public abstract List<Player> getPlayersThatSee(Entity var1);

    public void sendAllUpdatePackets(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public abstract void setTicksLived(Entity var1, int var2);

    public abstract void setHeadAngle(LivingEntity var1, float var2);

    public void setGhastAttacking(Ghast ghast, boolean attacking) {
        ghast.setCharging(attacking);
    }

    public abstract void setEndermanAngry(Enderman var1, boolean var2);

    public static EntityDamageEvent fireFakeDamageEvent(Entity target, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause, float amount) {
        Object ede = source != null ? new EntityDamageByEntityEvent(source.getBukkitEntity(), target, cause, (double)amount) : (sourceLoc != null ? new EntityDamageByBlockEvent(sourceLoc.getBlock(), target, cause, (double)amount) : new EntityDamageEvent(target, cause, (double)amount));
        Bukkit.getPluginManager().callEvent((Event)ede);
        return ede;
    }

    public abstract void damage(LivingEntity var1, float var2, EntityTag var3, Location var4, EntityDamageEvent.DamageCause var5);

    public abstract void setLastHurtBy(LivingEntity var1, LivingEntity var2);

    public abstract void setFallingBlockType(FallingBlock var1, BlockData var2);

    public abstract EntityTag getMobSpawnerDisplayEntity(CreatureSpawner var1);

    public void setFireworkLifetime(Firework firework, int ticks) {
        firework.setMaxLife(ticks);
    }

    public int getFireworkLifetime(Firework firework) {
        return firework.getMaxLife();
    }

    public abstract int getInWaterTime(Zombie var1);

    public abstract void setInWaterTime(Zombie var1, int var2);

    public abstract void setTrackingRange(Entity var1, int var2);

    public abstract boolean isAggressive(Mob var1);

    public abstract void setAggressive(Mob var1, boolean var2);

    public void setUUID(Entity entity, UUID id) {
        throw new UnsupportedOperationException();
    }

    public float getStepHeight(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void setStepHeight(Entity entity, float stepHeight) {
        throw new UnsupportedOperationException();
    }

    public List<Object> convertInternalEntityDataValues(Entity entity, MapTag internalData) {
        throw new UnsupportedOperationException();
    }

    public void modifyInternalEntityData(Entity entity, MapTag internalData) {
        throw new UnsupportedOperationException();
    }

    public void startUsingItem(LivingEntity entity, EquipmentSlot hand) {
        throw new UnsupportedOperationException();
    }

    public void stopUsingItem(LivingEntity entity) {
        throw new UnsupportedOperationException();
    }
}

