/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public record EntityMetadataCommandHelper(Predicate<Entity> getter, BiConsumer<EntityTag, Boolean> setter, Map<UUID, Map<UUID, Boolean>> packetOverrides) {
    public EntityMetadataCommandHelper(Predicate<Entity> getter, BiConsumer<EntityTag, Boolean> setter) {
        this(getter, setter, new HashMap<UUID, Map<UUID, Boolean>>());
    }

    public void setForPlayers(List<PlayerTag> players, EntityTag target, Predicate<PlayerTag> stateSupplier) {
        if (target == null || target.getUUID() == null || players == null) {
            return;
        }
        NetworkInterceptHelper.enable();
        boolean wasEntityAdded = !this.packetOverrides.containsKey(target.getUUID());
        Map playerMap = this.packetOverrides.computeIfAbsent(target.getUUID(), k -> new HashMap());
        for (PlayerTag player : players) {
            boolean state = stateSupplier.test(player);
            Boolean oldState = playerMap.put(player.getUUID(), state);
            if (!wasEntityAdded && oldState != null && oldState == state || !player.isOnline()) continue;
            NMSHandler.packetHelper.sendEntityMetadataFlagsUpdate(player.getPlayerEntity(), target.getBukkitEntity());
        }
    }

    public Boolean getState(Entity entity, UUID player, boolean fakeOnly) {
        Map<UUID, Boolean> playerMap;
        if (entity == null) {
            return null;
        }
        if (player != null && (playerMap = this.packetOverrides.get(entity.getUniqueId())) != null && playerMap.containsKey(player)) {
            return playerMap.get(player);
        }
        if (fakeOnly) {
            return null;
        }
        return this.getter.test(entity);
    }

    public boolean noOverrides() {
        return this.packetOverrides.isEmpty();
    }

    public void execute(ScriptEntry scriptEntry, List<EntityTag> targets, Action action, List<PlayerTag> forPlayers) {
        if (targets == null && (targets = Utilities.entryDefaultEntityList(scriptEntry, true)) == null) {
            throw new InvalidArgumentsRuntimeException("Must specify valid targets.");
        }
        switch (action) {
            case TRUE: 
            case FALSE: {
                boolean state;
                boolean bl = state = action == Action.TRUE;
                if (forPlayers == null) {
                    for (EntityTag target : targets) {
                        this.setter.accept(target, state);
                    }
                } else {
                    for (EntityTag target : targets) {
                        this.setForPlayers(forPlayers, target, player -> state);
                    }
                }
                break;
            }
            case TOGGLE: {
                if (forPlayers == null) {
                    for (EntityTag target : targets) {
                        this.setter.accept(target, this.getState(target.getBukkitEntity(), null, false) == false);
                    }
                } else {
                    for (EntityTag target : targets) {
                        this.setForPlayers(forPlayers, target, player -> this.getState(target.getBukkitEntity(), player.getUUID(), false) == false);
                    }
                }
                break;
            }
            case RESET: {
                for (EntityTag target : targets) {
                    Map<UUID, Boolean> playerMap = this.packetOverrides.get(target.getUUID());
                    if (playerMap == null) {
                        return;
                    }
                    HashSet<UUID> playersToUpdate = new HashSet<UUID>();
                    if (forPlayers == null) {
                        playersToUpdate.addAll(playerMap.keySet());
                        this.packetOverrides.remove(target.getUUID());
                    } else {
                        for (PlayerTag playerTag : forPlayers) {
                            if (playerMap.remove(playerTag.getUUID()) == null) continue;
                            playersToUpdate.add(playerTag.getUUID());
                        }
                        if (playerMap.isEmpty()) {
                            this.packetOverrides.remove(target.getUUID());
                        }
                    }
                    if (playersToUpdate.isEmpty()) {
                        return;
                    }
                    for (Player player2 : NMSHandler.entityHelper.getPlayersThatSee(target.getBukkitEntity())) {
                        if (!playersToUpdate.contains(player2.getUniqueId())) continue;
                        NMSHandler.packetHelper.sendEntityMetadataFlagsUpdate(player2, target.getBukkitEntity());
                    }
                    if (!playersToUpdate.contains(target.getUUID())) continue;
                    NMSHandler.packetHelper.sendEntityMetadataFlagsUpdate(target.as(Player.class), target.getBukkitEntity());
                }
                break;
            }
        }
    }

    public static enum Action {
        TRUE,
        FALSE,
        TOGGLE,
        RESET;

    }
}

