/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PotionSplashEvent;

public class PotionSplashScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ItemTag potion;
    public LocationTag location;
    public PotionSplashEvent event;

    public PotionSplashScriptEvent() {
        this.registerCouldMatcher("<item> splash|splashes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String item = path.eventArgLowerAt(0);
        if (!this.potion.tryAdvancedMatcher(item)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return new EntityTag((Entity)this.event.getEntity());
            }
            case "location": {
                return this.location;
            }
            case "potion": {
                return this.potion;
            }
            case "entities": {
                ListTag entities = new ListTag();
                for (Entity e : this.event.getAffectedEntities()) {
                    entities.addObject(new EntityTag(e).getDenizenObject());
                }
                return entities;
            }
            case "intensity": {
                ListTag intensity = new ListTag();
                for (Entity e : this.event.getAffectedEntities()) {
                    if (!(e instanceof LivingEntity)) continue;
                    intensity.addObject(this.intensityToMap((LivingEntity)e));
                }
                return intensity;
            }
        }
        return super.getContext(name);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("intensity:")) {
            BukkitTagContext context = this.getTagContext(path);
            ListTag obj = ListTag.valueOf(lower.substring("intensity:".length()), context);
            ArrayList<ObjectTag> data = new ArrayList<ObjectTag>(CoreUtilities.objectToList(obj, context));
            for (ObjectTag result : data) {
                if (result.canBeType(MapTag.class)) {
                    EntityTag entity = result.asType(MapTag.class, (TagContext)context).getObjectAs("entity", EntityTag.class, context);
                    ElementTag intensity = result.asType(MapTag.class, (TagContext)context).getObjectAs("intensity", ElementTag.class, context);
                    if (entity == null || intensity == null) {
                        Debug.echoError("Cannot return values from map. Are you sure your MapTag input matches [entity=<EntityTag>;intensity=<ElementTag(Number)>]?");
                        continue;
                    }
                    if (!intensity.isDouble()) continue;
                    this.event.setIntensity(entity.getLivingEntity(), intensity.asDouble());
                    continue;
                }
                Debug.echoError("MapTag input invalid. Are you sure you provided a valid MapTag?");
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @EventHandler
    public void onPotionSplash(PotionSplashEvent event) {
        this.potion = new ItemTag(event.getPotion().getItem());
        this.location = new LocationTag(event.getEntity().getLocation());
        this.event = event;
        this.fire((Event)event);
    }

    public MapTag intensityToMap(LivingEntity entity) {
        MapTag result = new MapTag();
        result.putObject("entity", (ObjectTag)new EntityTag((Entity)entity));
        result.putObject("intensity", (ObjectTag)new ElementTag(this.event.getIntensity(entity)));
        return result;
    }
}

