/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.commands.server.BossBarCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.core.CustomColorTagBase;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.NotedAreaTracker;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.core.AdjustCommand;
import com.denizenscript.denizencore.scripts.commands.core.SQLCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.PseudoObjectTagBase;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.core.UtilTagBase;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Art;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.GameRule;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapCursor;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.permissions.DefaultPermissions;

public class ServerTagBase
extends PseudoObjectTagBase<ServerTagBase> {
    public static ServerTagBase instance;

    public ServerTagBase() {
        instance = this;
        TagManager.registerStaticTagBaseHandler(ServerTagBase.class, "server", t -> instance);
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "global", attribute -> {
            BukkitImplDeprecations.globalTagName.warn(attribute.context);
            return null;
        });
        AdjustCommand.specialAdjustables.put("server", mechanism -> this.tagProcessor.processMechanism(instance, (Mechanism)mechanism));
    }

    @Override
    public void register() {
        Object runner;
        this.tagProcessor.registerTag(ElementTag.class, "economy", (attribute, object) -> {
            if (Depends.economy == null) {
                attribute.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                return null;
            }
            if (attribute.startsWith("format", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                return new ElementTag(Depends.economy.format(attribute.getDoubleParam()));
            }
            if (attribute.startsWith("currency_name", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                return new ElementTag(attribute.getDoubleParam() == 1.0 ? Depends.economy.currencyNameSingular() : Depends.economy.currencyNamePlural());
            }
            if (attribute.startsWith("currency_plural", 2)) {
                attribute.fulfill(1);
                return new ElementTag(Depends.economy.currencyNamePlural());
            }
            if (attribute.startsWith("currency_singular", 2)) {
                attribute.fulfill(1);
                return new ElementTag(Depends.economy.currencyNameSingular());
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "slot_id", (attribute, object, input) -> {
            int slotId = SlotHelper.nameToIndex(input.asString(), null);
            return slotId != -1 ? new ElementTag(slotId) : null;
        }, new String[0]);
        this.tagProcessor.registerTag(ItemTag.class, ElementTag.class, "parse_bukkit_item", (attribute, object, input) -> {
            YamlConfiguration config = new YamlConfiguration();
            try {
                config.loadFromString(input.asString());
                ItemStack item = config.getItemStack("item");
                if (item != null) {
                    return new ItemTag(item);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "recipe_ids", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            String type = attribute.hasParam() ? CoreUtilities.toLowerCase(attribute.getParam()) : null;
            ListTag recipeIds = new ListTag();
            if (type == null || !type.equals("brewing")) {
                Bukkit.recipeIterator().forEachRemaining(recipe -> {
                    if (recipe instanceof Keyed) {
                        Keyed keyedRecipe = (Keyed)recipe;
                        if (Utilities.isRecipeOfType(recipe, type)) {
                            recipeIds.add(keyedRecipe.getKey().toString());
                        }
                    }
                });
            }
            if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && (type == null || type.equals("brewing"))) {
                for (NamespacedKey brewingRecipe : NMSHandler.itemHelper.getCustomBrewingRecipes().keySet()) {
                    recipeIds.add(brewingRecipe.toString());
                }
            }
            return recipeIds;
        }, "list_recipe_ids");
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "recipe_items", (attribute, object, input) -> {
            ItemHelper.BrewingRecipe brewingRecipe;
            NamespacedKey recipeKey = Utilities.parseNamespacedKey(input.asString());
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)recipeKey);
            ItemHelper.BrewingRecipe brewingRecipe2 = brewingRecipe = Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) ? NMSHandler.itemHelper.getCustomBrewingRecipes().get(recipeKey) : null;
            if (recipe == null && brewingRecipe == null) {
                return null;
            }
            ListTag recipeItems = new ListTag();
            Consumer<RecipeChoice> addChoice = choice -> {
                if (choice == null) {
                    recipeItems.addObject(new ItemTag(Material.AIR));
                } else if (choice instanceof RecipeChoice.ExactChoice) {
                    recipeItems.addObject(new ItemTag(choice.getItemStack()));
                } else {
                    recipeItems.add("material:" + choice.getItemStack().getType().name());
                }
            };
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                Map choiceMap = shapedRecipe.getChoiceMap();
                for (String row : shapedRecipe.getShape()) {
                    for (char column : row.toCharArray()) {
                        addChoice.accept((RecipeChoice)choiceMap.get(Character.valueOf(column)));
                    }
                }
            } else if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                for (RecipeChoice choice2 : shapelessRecipe.getChoiceList()) {
                    addChoice.accept(choice2);
                }
            } else if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                addChoice.accept(cookingRecipe.getInputChoice());
            } else if (recipe instanceof StonecuttingRecipe) {
                StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)recipe;
                addChoice.accept(stonecuttingRecipe.getInputChoice());
            } else if (recipe instanceof SmithingRecipe) {
                SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
                addChoice.accept(smithingRecipe.getBase());
                addChoice.accept(smithingRecipe.getAddition());
            } else if (brewingRecipe != null) {
                if (brewingRecipe.ingredient() != null) {
                    addChoice.accept(brewingRecipe.ingredient());
                } else {
                    recipeItems.addObject(new ElementTag(PaperAPITools.instance.getBrewingRecipeIngredientMatcher(recipeKey), true));
                }
                if (brewingRecipe.input() != null) {
                    addChoice.accept(brewingRecipe.input());
                } else {
                    recipeItems.addObject(new ElementTag(PaperAPITools.instance.getBrewingRecipeInputMatcher(recipeKey), true));
                }
            }
            return recipeItems;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "recipe_shape", (attribute, object, input) -> {
            Recipe patt14919$temp = Bukkit.getRecipe((NamespacedKey)Utilities.parseNamespacedKey(input.asString()));
            if (patt14919$temp instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)patt14919$temp;
                String[] shape = shapedRecipe.getShape();
                return new ElementTag(shape[0].length() + "x" + shape.length);
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "recipe_type", (attribute, object, input) -> {
            NamespacedKey recipeKey = Utilities.parseNamespacedKey(input.asString());
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)recipeKey);
            if (recipe != null) {
                return new ElementTag(Utilities.getRecipeType(recipe));
            }
            if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && NMSHandler.itemHelper.getCustomBrewingRecipes().containsKey(recipeKey)) {
                return new ElementTag("brewing");
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ItemTag.class, ElementTag.class, "recipe_result", (attribute, object, input) -> {
            ItemHelper.BrewingRecipe brewingRecipe;
            NamespacedKey recipeKey = Utilities.parseNamespacedKey(input.asString());
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)recipeKey);
            if (recipe != null) {
                return new ItemTag(recipe.getResult());
            }
            if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && (brewingRecipe = NMSHandler.itemHelper.getCustomBrewingRecipes().get(recipeKey)) != null) {
                return new ItemTag(brewingRecipe.result());
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "scoreboards", (attribute, object) -> {
            ListTag scoreboards = new ListTag(ScoreboardHelper.scoreboardMap.size());
            for (String board : ScoreboardHelper.scoreboardMap.keySet()) {
                scoreboards.addObject(new ElementTag(board, true));
            }
            return scoreboards;
        }, new String[0]);
        this.tagProcessor.registerTag(ObjectTag.class, "scoreboard", (attribute, object) -> {
            Scoreboard board;
            String name = "main";
            if (attribute.hasParam()) {
                name = attribute.getParam();
                board = ScoreboardHelper.getScoreboard(name);
            } else {
                board = ScoreboardHelper.getMain();
            }
            if (attribute.startsWith("exists", 2)) {
                attribute.fulfill(1);
                return new ElementTag(board != null);
            }
            if (board == null) {
                attribute.echoError("Scoreboard '" + name + "' does not exist.");
                return null;
            }
            if (attribute.startsWith("objectives", 2)) {
                attribute.fulfill(1);
                ListTag objectives = new ListTag();
                for (Objective objective : board.getObjectives()) {
                    objectives.add(objective.getName());
                }
                return objectives;
            }
            if (attribute.startsWith("objective", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                Objective objective = board.getObjective(attribute.getParam());
                if (objective == null) {
                    attribute.echoError("Scoreboard objective '" + attribute.getParam() + "' does not exist.");
                    return null;
                }
                if (attribute.startsWith("criteria", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(objective.getCriteria());
                }
                if (attribute.startsWith("display_name", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(objective.getDisplayName());
                }
                if (attribute.startsWith("display_slot", 2)) {
                    attribute.fulfill(1);
                    DisplaySlot displaySlot = objective.getDisplaySlot();
                    return displaySlot != null ? new ElementTag((Enum<?>)displaySlot) : null;
                }
                if (attribute.startsWith("score", 2) && attribute.hasContext(2)) {
                    attribute.fulfill(1);
                    ObjectTag param = attribute.getParamObject();
                    String value = param.shouldBeType(PlayerTag.class) ? param.asType(PlayerTag.class, attribute.context).getName() : (param.shouldBeType(EntityTag.class) ? param.asType(EntityTag.class, attribute.context).getUUID().toString() : param.toString());
                    Score score = objective.getScore(value);
                    return score.isScoreSet() ? new ElementTag(score.getScore()) : null;
                }
            }
            if (attribute.startsWith("team_names", 2)) {
                attribute.fulfill(1);
                ListTag teams = new ListTag();
                for (Team team : board.getTeams()) {
                    teams.add(team.getName());
                }
                return teams;
            }
            if (attribute.startsWith("team", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                Team team = board.getTeam(attribute.getParam());
                if (team == null) {
                    attribute.echoError("Scoreboard team '" + attribute.getParam() + "' does not exist.");
                    return null;
                }
                if (attribute.startsWith("members", 2)) {
                    attribute.fulfill(1);
                    return new ListTag(team.getEntries());
                }
                if (attribute.startsWith("prefix", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(PaperAPITools.instance.getTeamPrefix(team));
                }
                if (attribute.startsWith("suffix", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(PaperAPITools.instance.getTeamSuffix(team));
                }
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ObjectTag.class, "object_is_valid", (attribute, object, input) -> {
            BukkitImplDeprecations.serverObjectExistsTags.warn(attribute.context);
            ObjectTag o = ObjectFetcher.pickObjectFor(input.toString(), CoreUtilities.noDebugContext);
            return new ElementTag(o != null && !(o instanceof ElementTag));
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "has_whitelist", (attribute, object) -> new ElementTag(Bukkit.hasWhitelist()), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "whitelisted_players", (attribute, object) -> {
            ListTag whitelisted = new ListTag();
            for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
                whitelisted.addObject(new PlayerTag(player));
            }
            return whitelisted;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "has_flag", (attribute, object, input) -> DenizenCore.serverFlagMap.doHasFlagTag(attribute), new String[0]);
        this.tagProcessor.registerTag(TimeTag.class, ElementTag.class, "flag_expiration", (attribute, object, input) -> DenizenCore.serverFlagMap.doFlagExpirationTag(attribute), new String[0]);
        this.tagProcessor.registerTag(ObjectTag.class, ElementTag.class, "flag", (attribute, object, input) -> DenizenCore.serverFlagMap.doFlagTag(attribute), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "list_flags", (attribute, object) -> DenizenCore.serverFlagMap.doListFlagsTag(attribute), new String[0]);
        this.tagProcessor.registerTag(MapTag.class, "flag_map", (attribute, object) -> DenizenCore.serverFlagMap.doFlagMapTag(attribute), new String[0]);
        this.tagProcessor.registerStaticTag(ListTag.class, "gamerules", (attribute, object) -> {
            ListTag gamerules = new ListTag();
            for (GameRule rule : GameRule.values()) {
                gamerules.add(rule.getName());
            }
            return gamerules;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "commands", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            CommandScriptHelper.init();
            return new ListTag(CommandScriptHelper.knownCommands.keySet());
        }, "list_commands");
        this.tagProcessor.registerTag(PluginTag.class, ElementTag.class, "command_plugin", (attribute, object, input) -> {
            PluginCommand command = Bukkit.getPluginCommand((String)input.asString());
            return command != null ? new PluginTag(command.getPlugin()) : null;
        }, new String[0]);
        this.registerEnumListTag("art_types", Art.class, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "advancement_types", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag advancements = new ListTag();
            Bukkit.advancementIterator().forEachRemaining(adv -> advancements.add(adv.getKey().toString()));
            return advancements;
        }, "list_advancements");
        this.registerEnumListTag("nbt_attribute_types", Attribute.class, "list_nbt_attribute_types");
        this.registerEnumListTag("damage_causes", EntityDamageEvent.DamageCause.class, "list_damage_causes");
        this.registerEnumListTag("teleport_causes", PlayerTeleportEvent.TeleportCause.class, new String[0]);
        this.tagProcessor.registerStaticTag(ListTag.class, "biome_types", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag biomes = new ListTag();
            for (Biome biome : Biome.values()) {
                BiomeTag biomeTag = new BiomeTag(biome);
                if (biomeTag.getBiome() == null) continue;
                biomes.addObject(biomeTag);
            }
            return biomes;
        }, "list_biome_types");
        this.tagProcessor.registerTag(ListTag.class, "enchantments", (attribute, object) -> {
            ListTag enchantments = new ListTag();
            for (Enchantment enchantment : Enchantment.values()) {
                enchantments.addObject(new EnchantmentTag(enchantment));
            }
            return enchantments;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "enchantment_types", (attribute, object) -> {
            BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag enchants = new ListTag();
            for (Enchantment e : Enchantment.values()) {
                enchants.add(e.getName());
            }
            return enchants;
        }, "list_enchantments");
        this.tagProcessor.registerTag(ListTag.class, "enchantment_keys", (attribute, object) -> {
            BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag enchants = new ListTag();
            for (Enchantment e : Enchantment.values()) {
                enchants.add(e.getKey().getKey());
            }
            return enchants;
        }, "list_enchantment_keys");
        this.tagProcessor.registerStaticTag(ListTag.class, "entity_types", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag entityTypes = new ListTag();
            for (EntityType entityType : EntityType.values()) {
                if (entityType == EntityType.UNKNOWN) continue;
                entityTypes.add(entityType.name());
            }
            return entityTypes;
        }, "list_entity_types");
        this.tagProcessor.registerStaticTag(ListTag.class, "material_types", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag materials = new ListTag();
            for (Material material : Material.values()) {
                materials.addObject(new MaterialTag(material));
            }
            return materials;
        }, "list_material_types");
        this.registerEnumListTag("sound_types", Sound.class, "list_sounds");
        this.registerEnumListTag("particle_types", Particle.class, "list_particles");
        this.registerEnumListTag("effect_types", Effect.class, "list_effects");
        this.registerEnumListTag("pattern_types", PatternType.class, "list_patterns");
        this.tagProcessor.registerTag(ListTag.class, "potion_effect_types", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag potionEffects = new ListTag();
            for (PotionEffectType potionEffect : PotionEffectType.values()) {
                if (potionEffect == null) continue;
                potionEffects.add(potionEffect.getName());
            }
            return potionEffects;
        }, "list_potion_effects");
        this.registerEnumListTag("potion_types", PotionType.class, "list_potion_types");
        this.registerEnumListTag("tree_types", TreeType.class, "list_tree_types");
        this.registerEnumListTag("map_cursor_types", MapCursor.Type.class, "list_map_cursor_types");
        this.registerEnumListTag("world_types", WorldType.class, "list_world_types");
        this.tagProcessor.registerStaticTag(ListTag.class, "statistic_types", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            Statistic.Type type = attribute.hasParam() ? attribute.getParamElement().asEnum(Statistic.Type.class) : null;
            ListTag statistics = new ListTag();
            for (Statistic statistic : Statistic.values()) {
                if (type != null && type != statistic.getType()) continue;
                statistics.add(statistic.name());
            }
            return statistics;
        }, "list_statistics");
        this.tagProcessor.registerTag(ListTag.class, "structure_types", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            return new ListTag(StructureType.getStructureTypes().keySet());
        }, "list_structure_types");
        this.tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "statistic_type", (attribute, object, input) -> {
            Statistic statistic = input.asEnum(Statistic.class);
            if (statistic == null) {
                attribute.echoError("Statistic '" + input + "' does not exist.");
                return null;
            }
            return new ElementTag((Enum<?>)statistic.getType());
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, EnchantmentTag.class, "enchantment_max_level", (attribute, object, input) -> {
            BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
            return new ElementTag(input.enchantment.getMaxLevel());
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, EnchantmentTag.class, "enchantment_start_level", (attribute, object, input) -> {
            BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
            return new ElementTag(input.enchantment.getStartLevel());
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "notables", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            BukkitImplDeprecations.serverUtilTags.warn(attribute.context);
            ListTag allNotables = new ListTag();
            if (attribute.hasParam()) {
                String type = CoreUtilities.toLowerCase(attribute.getParam());
                for (Map.Entry<String, Class> typeClass : NoteManager.namesToTypes.entrySet()) {
                    if (!type.equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                    for (Object notable : NoteManager.getAllType(typeClass.getValue())) {
                        allNotables.addObject((ObjectTag)notable);
                    }
                    break;
                }
            } else {
                for (Notable notable : NoteManager.nameToObject.values()) {
                    allNotables.addObject((ObjectTag)((Object)notable));
                }
            }
            return allNotables;
        }, "list_notables");
        this.tagProcessor.registerTag(ListTag.class, "list_sql_connections", (attribute, object) -> {
            BukkitImplDeprecations.listStyleTags.warn(attribute.context);
            BukkitImplDeprecations.serverUtilTags.warn(attribute.context);
            ListTag list = new ListTag();
            for (Map.Entry<String, Connection> entry : SQLCommand.connections.entrySet()) {
                try {
                    if (!entry.getValue().isClosed()) {
                        list.add(entry.getKey());
                        continue;
                    }
                    SQLCommand.connections.remove(entry.getKey());
                }
                catch (SQLException e) {
                    Debug.echoError(attribute.getScriptEntry(), e);
                }
            }
            return list;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "list_scripts", (attribute, object) -> {
            BukkitImplDeprecations.listStyleTags.warn(attribute.context);
            BukkitImplDeprecations.serverUtilTags.warn(attribute.context);
            ListTag scripts = new ListTag();
            for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
                scripts.addObject(new ScriptTag(script));
            }
            return scripts;
        }, new String[0]);
        this.tagProcessor.registerTag(DurationTag.class, "start_time", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            return new DurationTag(CoreUtilities.monotonicMillisToReal(DenizenCore.startTime) / 50L);
        }, new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "has_permissions", (attribute, object) -> new ElementTag(Depends.permissions != null && Depends.permissions.isEnabled()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "has_economy", (attribute, object) -> new ElementTag(Depends.economy != null && Depends.economy.isEnabled()), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "denizen_version", (attribute, object) -> new ElementTag(Denizen.versionTag), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "bukkit_version", (attribute, object) -> new ElementTag(Bukkit.getBukkitVersion()), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "version", (attribute, object) -> new ElementTag(Bukkit.getVersion()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "max_players", (attribute, object) -> new ElementTag(Bukkit.getMaxPlayers()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "group_prefix", (attribute, object, input) -> {
            if (Depends.permissions == null) {
                attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return null;
            }
            String group = input.asString();
            if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                attribute.echoError("Invalid group! '" + group + "' could not be found.");
                return null;
            }
            if (attribute.startsWith("world", 2)) {
                attribute.fulfill(1);
                WorldTag world = attribute.paramAsType(WorldTag.class);
                return world != null ? new ElementTag(Depends.chat.getGroupPrefix(world.getWorld(), group)) : null;
            }
            return new ElementTag(Depends.chat.getGroupPrefix((World)Bukkit.getWorlds().get(0), group));
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "group_suffix", (attribute, object, input) -> {
            if (Depends.permissions == null) {
                attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return null;
            }
            String group = input.asString();
            if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                attribute.echoError("Invalid group! '" + group + "' could not be found.");
                return null;
            }
            if (attribute.startsWith("world", 2)) {
                attribute.fulfill(1);
                WorldTag world = attribute.paramAsType(WorldTag.class);
                return world != null ? new ElementTag(Depends.chat.getGroupSuffix(world.getWorld(), group)) : null;
            }
            return new ElementTag(Depends.chat.getGroupSuffix((World)Bukkit.getWorlds().get(0), group));
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "permission_groups", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            if (Depends.permissions == null) {
                attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return null;
            }
            return new ListTag(Arrays.asList(Depends.permissions.getGroups()));
        }, "list_permission_groups");
        this.tagProcessor.registerTag(PlayerTag.class, ElementTag.class, "match_player", (attribute, object, input) -> {
            Player matchPlayer = null;
            String matchInput = input.asLowerString();
            if (matchInput.isEmpty()) {
                return null;
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                String nameLow = CoreUtilities.toLowerCase(player.getName());
                if (nameLow.equals(matchInput)) {
                    matchPlayer = player;
                    break;
                }
                if (!nameLow.contains(matchInput) || matchPlayer != null && !nameLow.startsWith(matchInput)) continue;
                matchPlayer = player;
            }
            return matchPlayer != null ? new PlayerTag(matchPlayer) : null;
        }, new String[0]);
        this.tagProcessor.registerTag(PlayerTag.class, ElementTag.class, "match_offline_player", (attribute, object, input) -> {
            PlayerTag matchPlayer = null;
            String matchInput = input.asLowerString();
            if (matchInput.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, UUID> entry : PlayerTag.getAllPlayers().entrySet()) {
                String nameLow = CoreUtilities.toLowerCase(entry.getKey());
                if (nameLow.equals(matchInput)) {
                    matchPlayer = new PlayerTag(entry.getValue());
                    break;
                }
                if (!nameLow.contains(matchInput)) continue;
                PlayerTag newMatch = new PlayerTag(entry.getValue());
                if (matchPlayer == null) {
                    matchPlayer = newMatch;
                    continue;
                }
                if (newMatch.isOnline() && !matchPlayer.isOnline()) {
                    matchPlayer = newMatch;
                    continue;
                }
                if (!nameLow.startsWith(matchInput) || newMatch.isOnline() != matchPlayer.isOnline()) continue;
                matchPlayer = newMatch;
            }
            return matchPlayer;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "online_players_flagged", (attribute, object, input) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            String flag = input.asString();
            ListTag flaggedPlayers = new ListTag();
            boolean want = true;
            if (flag.startsWith("!")) {
                want = false;
                flag = flag.substring(1);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                PlayerTag playerTag = new PlayerTag(player);
                if (playerTag.getFlagTracker().hasFlag(flag) != want) continue;
                flaggedPlayers.addObject(playerTag);
            }
            return flaggedPlayers;
        }, "list_online_players_flagged");
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "players_flagged", (attribute, object, input) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            String flag = input.asString();
            ListTag flaggedPlayers = new ListTag();
            boolean want = true;
            if (flag.startsWith("!")) {
                want = false;
                flag = flag.substring(1);
            }
            for (UUID playerId : PlayerTag.getAllPlayers().values()) {
                PlayerTag player = new PlayerTag(playerId);
                if (player.getFlagTracker().hasFlag(flag) != want) continue;
                flaggedPlayers.addObject(player);
            }
            return flaggedPlayers;
        }, "list_players_flagged");
        this.tagProcessor.registerTag(ListTag.class, "worlds", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag worlds = new ListTag();
            for (World world : Bukkit.getWorlds()) {
                worlds.addObject(new WorldTag(world));
            }
            return worlds;
        }, "list_worlds");
        this.tagProcessor.registerTag(ListTag.class, "plugins", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag plugins = new ListTag();
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                plugins.addObject(new PluginTag(plugin));
            }
            return plugins;
        }, "list_plugins");
        this.tagProcessor.registerTag(ListTag.class, "players", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            OfflinePlayer[] allPlayers = Bukkit.getOfflinePlayers();
            ListTag players = new ListTag(allPlayers.length);
            for (OfflinePlayer player : allPlayers) {
                players.addObject(PlayerTag.mirrorBukkitPlayer(player));
            }
            return players;
        }, "list_players");
        this.tagProcessor.registerTag(ListTag.class, "online_players", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag players = new ListTag();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.addObject(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
            }
            return players;
        }, "list_online_players");
        this.tagProcessor.registerTag(ListTag.class, "offline_players", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag players = new ListTag();
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                if (player.isOnline()) continue;
                players.addObject(PlayerTag.mirrorBukkitPlayer(player));
            }
            return players;
        }, "list_offline_players");
        this.tagProcessor.registerTag(ListTag.class, "banned_players", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag banned = new ListTag();
            for (OfflinePlayer player : Bukkit.getBannedPlayers()) {
                banned.addObject(PlayerTag.mirrorBukkitPlayer(player));
            }
            return banned;
        }, "list_banned_players");
        this.tagProcessor.registerTag(ListTag.class, "banned_addresses", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag bannedIPs = new ListTag();
            bannedIPs.addAll(Bukkit.getIPBans());
            return bannedIPs;
        }, "list_banned_addresses");
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "is_banned", (attribute, object, input) -> {
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(input.asString());
            if (ban == null) {
                return new ElementTag(false);
            }
            return new ElementTag(ban.getExpiration() == null || ban.getExpiration().after(new Date()));
        }, new String[0]);
        this.tagProcessor.registerTag(ObjectTag.class, ElementTag.class, "ban_info", (attribute, object, input) -> {
            Date expiration;
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(input.asString());
            if (ban == null || (expiration = ban.getExpiration()) != null && expiration.before(new Date())) {
                return null;
            }
            if (attribute.startsWith("expiration_time", 2)) {
                attribute.fulfill(1);
                return expiration != null ? new TimeTag(expiration.getTime()) : null;
            }
            if (attribute.startsWith("expiration", 2)) {
                attribute.fulfill(1);
                Deprecations.timeTagRewrite.warn(attribute.context);
                return expiration != null ? new DurationTag(expiration.getTime() / 50L) : null;
            }
            if (attribute.startsWith("reason", 2)) {
                attribute.fulfill(1);
                return new ElementTag(ban.getReason());
            }
            if (attribute.startsWith("created_time", 2)) {
                attribute.fulfill(1);
                return new TimeTag(ban.getCreated().getTime());
            }
            if (attribute.startsWith("created", 2)) {
                attribute.fulfill(1);
                Deprecations.timeTagRewrite.warn(attribute.context);
                return new DurationTag(ban.getCreated().getTime() / 50L);
            }
            if (attribute.startsWith("source", 2)) {
                attribute.fulfill(1);
                return new ElementTag(ban.getSource());
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "ops", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag ops = new ListTag();
            for (OfflinePlayer player : Bukkit.getOperators()) {
                ops.addObject(PlayerTag.mirrorBukkitPlayer(player));
            }
            return ops;
        }, "list_ops");
        this.tagProcessor.registerTag(ListTag.class, "online_ops", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag onlineOps = new ListTag();
            for (OfflinePlayer player : Bukkit.getOperators()) {
                if (!player.isOnline()) continue;
                onlineOps.addObject(PlayerTag.mirrorBukkitPlayer(player));
            }
            return onlineOps;
        }, "list_online_ops");
        this.tagProcessor.registerTag(ListTag.class, "offline_ops", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag offlineOps = new ListTag();
            for (OfflinePlayer player : Bukkit.getOperators()) {
                if (player.isOnline()) continue;
                offlineOps.addObject(PlayerTag.mirrorBukkitPlayer(player));
            }
            return offlineOps;
        }, "list_offline_ops");
        this.tagProcessor.registerTag(ElementTag.class, "motd", (attribute, object) -> new ElementTag(Bukkit.getMotd()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "view_distance", (attribute, object) -> new ElementTag(Bukkit.getViewDistance()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ObjectTag.class, "entity_is_spawned", (attribute, object, input) -> {
            BukkitImplDeprecations.isValidTag.warn(attribute.context);
            EntityTag entity = input.canBeType(EntityTag.class) ? input.asType(EntityTag.class, attribute.context) : null;
            return new ElementTag(entity != null && entity.isUnique() && entity.isSpawnedOrValidForTag());
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "player_is_valid", (attribute, object, input) -> {
            BukkitImplDeprecations.isValidTag.warn(attribute.context);
            return new ElementTag(PlayerTag.playerNameIsValid(input.asString()));
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ObjectTag.class, "npc_is_valid", (attribute, object, input) -> {
            BukkitImplDeprecations.isValidTag.warn(attribute.context);
            NPCTag npc = input.canBeType(NPCTag.class) ? input.asType(NPCTag.class, attribute.context) : null;
            return new ElementTag(npc != null && npc.isValid());
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "current_bossbars", (attribute, context) -> new ListTag(BossBarCommand.bossBarMap.keySet()), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "bossbar_viewers", (attribute, object, input) -> {
            BossBar bar = BossBarCommand.bossBarMap.get(input.asLowerString());
            if (bar == null) {
                return null;
            }
            ListTag viewers = new ListTag();
            for (Player player : bar.getPlayers()) {
                viewers.addObject(new PlayerTag(player));
            }
            return viewers;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "recent_tps", (attribute, object) -> {
            ListTag recentTPS = new ListTag(3);
            for (double tps : NMSHandler.instance.getRecentTps()) {
                recentTPS.addObject(new ElementTag(tps));
            }
            return recentTPS;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "port", (attribute, object) -> new ElementTag(Bukkit.getPort()), new String[0]);
        this.tagProcessor.registerTag(DurationTag.class, "idle_timeout", (attribute, object) -> new DurationTag(Bukkit.getIdleTimeout() * 60), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "vanilla_entity_tags", (attribute, object) -> new ListTag(VanillaTagHelper.entityTagsByKey.keySet()), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "vanilla_tagged_entities", (attribute, object, tag) -> {
            Set entityTypes = VanillaTagHelper.entityTagsByKey.get(tag.asLowerString());
            if (entityTypes == null) {
                return null;
            }
            ListTag taggedEntities = new ListTag(entityTypes.size());
            for (EntityType entityType : entityTypes) {
                taggedEntities.addObject(new EntityTag(entityType));
            }
            return taggedEntities;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "vanilla_material_tags", (attribute, object) -> new ListTag(VanillaTagHelper.materialTagsByKey.keySet()), "vanilla_tags");
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "vanilla_tagged_materials", (attribute, object, tag) -> {
            Set materials = VanillaTagHelper.materialTagsByKey.get(tag.asLowerString());
            if (materials == null) {
                return null;
            }
            ListTag taggedMaterials = new ListTag(materials.size());
            for (Material material : materials) {
                taggedMaterials.addObject(new MaterialTag(material));
            }
            return taggedMaterials;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "plugins_handling_event", (attribute, object, input) -> {
            block7: {
                ServerTagBase.listDeprecateWarn(attribute);
                String eventName = input.asString();
                if (CoreUtilities.contains(eventName, '.')) {
                    try {
                        Class<?> clazz = Class.forName(eventName, false, ServerTagBase.class.getClassLoader());
                        ListTag result = ServerTagBase.getHandlerPluginList(clazz);
                        if (result != null) {
                            return result;
                        }
                        break block7;
                    }
                    catch (ClassNotFoundException ex) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError(ex);
                        }
                        break block7;
                    }
                }
                ScriptEvent scriptEvent = ScriptEvent.eventLookup.get(input.asLowerString());
                if (scriptEvent instanceof Listener) {
                    Listener listener = (Listener)scriptEvent;
                    Denizen plugin = Denizen.getInstance();
                    for (Class eventClass : plugin.getPluginLoader().createRegisteredListeners(listener, (Plugin)plugin).keySet()) {
                        ListTag result = ServerTagBase.getHandlerPluginList(eventClass);
                        if (result == null || result.size() <= 0) continue;
                        return result;
                    }
                    return new ListTag();
                }
            }
            return null;
        }, "list_plugins_handling_event");
        this.tagProcessor.registerTag(ListTag.class, MapTag.class, "generate_loot_table", (attribute, object, map) -> {
            Collection items;
            ElementTag idObj = map.getRequiredObjectAs("id", ElementTag.class, attribute);
            LocationTag locationObj = map.getRequiredObjectAs("location", LocationTag.class, attribute);
            if (idObj == null || locationObj == null) {
                return null;
            }
            LootTable table = Bukkit.getLootTable((NamespacedKey)Utilities.parseNamespacedKey(idObj.asLowerString()));
            if (table == null) {
                attribute.echoError("Invalid loot table ID '" + idObj + "' specified.");
                return null;
            }
            LootContext.Builder context = new LootContext.Builder((Location)locationObj);
            EntityTag killer = map.getObjectAs("killer", EntityTag.class, attribute.context);
            ElementTag luck = map.getElement("luck");
            ElementTag bonus = map.getElement("loot_bonus");
            EntityTag entity = map.getObjectAs("entity", EntityTag.class, attribute.context);
            if (entity != null) {
                context = context.lootedEntity(entity.getBukkitEntity());
            }
            if (killer != null) {
                LivingEntity patt83696$temp = killer.getLivingEntity();
                if (patt83696$temp instanceof HumanEntity) {
                    HumanEntity humanEntity = (HumanEntity)patt83696$temp;
                    context = context.killer(humanEntity);
                } else {
                    attribute.echoError("Invalid killer '" + killer + "' specified: must be an online player or a player-type NPC.");
                }
            }
            if (luck != null) {
                context = context.luck(luck.asFloat());
            }
            if (bonus != null) {
                context = context.lootingModifier(bonus.asInt());
            }
            try {
                items = table.populateLoot(CoreUtilities.getRandom(), context.build());
            }
            catch (Throwable ex) {
                attribute.echoError("Loot table failed to generate: " + ex.getMessage());
                if (CoreConfiguration.debugVerbose) {
                    attribute.echoError(ex);
                }
                return null;
            }
            ListTag lootItems = new ListTag(items.size());
            for (ItemStack item : items) {
                lootItems.addObject(new ItemTag(item));
            }
            return lootItems;
        }, new String[0]);
        this.tagProcessor.registerTag(MapTag.class, "area_notes_debug", (attribute, object) -> {
            MapTag worlds = new MapTag();
            for (Map.Entry<String, NotedAreaTracker.PerWorldSet> set : NotedAreaTracker.worlds.entrySet()) {
                MapTag worldData = new MapTag();
                worldData.putObject("global", (ObjectTag)new ListTag(set.getValue().globalSet.list, trackedArea -> trackedArea.area));
                worldData.putObject("x50", (ObjectTag)ServerTagBase.areaNotesDebug(set.getValue().sets50));
                worldData.putObject("x50_offset", (ObjectTag)ServerTagBase.areaNotesDebug(set.getValue().sets50_offset));
                worldData.putObject("x200", (ObjectTag)ServerTagBase.areaNotesDebug(set.getValue().sets200));
                worldData.putObject("x200_offset", (ObjectTag)ServerTagBase.areaNotesDebug(set.getValue().sets200_offset));
                worlds.putObject(set.getKey(), (ObjectTag)worldData);
            }
            return worlds;
        }, new String[0]);
        this.tagProcessor.registerMechanism("clean_flags", false, (object, mechanism) -> DenizenCore.serverFlagMap.doTotalClean(), new String[0]);
        this.tagProcessor.registerMechanism("reset_recipes", false, (object, mechanism) -> {
            Bukkit.resetRecipes();
            ItemScriptHelper.rebuildRecipes();
        }, new String[0]);
        this.tagProcessor.registerMechanism("remove_recipes", false, ListTag.class, (object, mechanism, recipes) -> {
            for (String recipe : recipes) {
                Bukkit.removeRecipe((NamespacedKey)Utilities.parseNamespacedKey(recipe));
            }
        }, new String[0]);
        this.tagProcessor.registerMechanism("idle_timeout", false, DurationTag.class, (object, mechanism, timeout) -> Bukkit.setIdleTimeout((int)((int)Math.round(timeout.getSeconds() / 60.0))), new String[0]);
        this.tagProcessor.registerMechanism("restart", false, (object, mechanism) -> {
            if (!Settings.allowServerRestart()) {
                Debug.echoError("Server restart disabled by administrator (refer to mechanism documentation). Consider using 'shutdown'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server restarted by a Denizen script, see config to prevent this!");
            Bukkit.spigot().restart();
        }, new String[0]);
        this.tagProcessor.registerMechanism("save", false, (object, mechanism) -> {
            DenizenCore.saveAll();
            Denizen.getInstance().saveSaves(false);
        }, new String[0]);
        this.tagProcessor.registerMechanism("shutdown", false, (object, mechanism) -> {
            if (!Settings.allowServerStop()) {
                Debug.echoError("Server stop disabled by administrator (refer to mechanism documentation). Consider using 'restart'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server shutdown by a Denizen script, see config to prevent this!");
            Bukkit.shutdown();
        }, new String[0]);
        this.tagProcessor.registerMechanism("has_whitelist", false, ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireBoolean()) {
                Bukkit.setWhitelist((boolean)input.asBoolean());
            }
        }, new String[0]);
        this.tagProcessor.registerMechanism("register_permission", false, MapTag.class, (object, mechanism, input) -> {
            PermissionDefault permissionDefault;
            ElementTag name = input.getElement("name");
            ElementTag parentInput = input.getElement("parent");
            ElementTag defaultInput = input.getElement("default");
            ElementTag description = input.getElement("description");
            Permission parent = parentInput == null ? null : Bukkit.getPluginManager().getPermission(parentInput.asString());
            PermissionDefault permissionDefault2 = permissionDefault = defaultInput == null ? null : defaultInput.asEnum(PermissionDefault.class);
            if (parent == null) {
                DefaultPermissions.registerPermission((String)name.asString(), (String)(description == null ? null : description.asString()), (PermissionDefault)permissionDefault);
            } else {
                DefaultPermissions.registerPermission((String)name.asString(), (String)(description == null ? null : description.asString()), (PermissionDefault)permissionDefault, (Permission)parent);
            }
        }, new String[0]);
        this.tagProcessor.registerMechanism("default_colors", false, MapTag.class, (object, mechanism, input) -> {
            for (Map.Entry<StringHolder, ObjectTag> pair : input.entrySet()) {
                String name = pair.getKey().low;
                if (CustomColorTagBase.customColors.containsKey(name)) continue;
                CustomColorTagBase.customColors.put(name, pair.getValue().toString().replace("<", "<&lt>"));
            }
        }, new String[0]);
        for (String tagName : new String[]{"current_time_millis", "real_time_since_start", "color_names", "delta_time_since_start", "current_tick", "available_processors", "ram_usage", "ram_free", "ram_max", "ram_allocated", "disk_usage", "debug_enabled", "disk_total", "disk_free", "started_time", "has_file", "list_files", "notes", "last_reload", "scripts", "sql_connections", "java_version", "stack_trace"}) {
            runner = UtilTagBase.instance.tagProcessor.registeredObjectTags.get((Object)tagName).runner;
            this.tagProcessor.registerTag(ObjectTag.class, tagName, (attribute, object) -> {
                BukkitImplDeprecations.serverUtilTags.warn(attribute.context);
                return runner.run(attribute, UtilTagBase.instance);
            }, new String[0]);
        }
        for (String mechName : new String[]{"delete_file", "reset_event_stats", "cleanmem"}) {
            runner = UtilTagBase.instance.tagProcessor.registeredMechanisms.get((Object)mechName).runner;
            this.tagProcessor.registerMechanism(mechName, false, (arg_0, arg_1) -> ServerTagBase.lambda$register$98((Mechanism.GenericMechRunnerInterface)runner, arg_0, arg_1), new String[0]);
        }
        if (Depends.citizens != null) {
            this.registerCitizensFeatures();
        }
    }

    public void registerCitizensFeatures() {
        this.tagProcessor.registerTag(NPCTag.class, "selected_npc", (attribute, object) -> {
            NPC npc = Depends.citizens.getNPCSelector().getSelected((CommandSender)Bukkit.getConsoleSender());
            return npc != null ? new NPCTag(npc) : null;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "npcs_named", (attribute, object, input) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag npcs = new ListTag();
            String name = input.asLowerString();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!name.equals(CoreUtilities.toLowerCase(npc.getName()))) continue;
                npcs.addObject(new NPCTag(npc));
            }
            return npcs;
        }, "list_npcs_named");
        this.tagProcessor.registerTag(ListTag.class, ScriptTag.class, "npcs_assigned", (attribute, object, script) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ScriptContainer patt104223$temp = script.getContainer();
            if (!(patt104223$temp instanceof AssignmentScriptContainer)) {
                attribute.echoError("Invalid script '" + script + "' specified: must be an assignment script.");
                return null;
            }
            AssignmentScriptContainer assignmentScriptContainer = (AssignmentScriptContainer)patt104223$temp;
            ListTag npcs = new ListTag();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)npc.getTraitNullable(AssignmentTrait.class)).isAssigned(assignmentScriptContainer)) continue;
                npcs.addObject(new NPCTag(npc));
            }
            return npcs;
        }, "list_npcs_assigned");
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "spawned_npcs_flagged", (attribute, object, input) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            String flag = input.asString();
            ListTag npcs = new ListTag();
            boolean want = true;
            if (flag.startsWith("!")) {
                want = false;
                flag = flag.substring(1);
            }
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                NPCTag npcTag = new NPCTag(npc);
                if (!npcTag.isSpawned() || npcTag.hasFlag(flag) != want) continue;
                npcs.addObject(npcTag);
            }
            return npcs;
        }, "list_spawned_npcs_flagged");
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "npcs_flagged", (attribute, object, input) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            String flag = input.asString();
            ListTag npcs = new ListTag();
            boolean want = true;
            if (flag.startsWith("!")) {
                want = false;
                flag = flag.substring(1);
            }
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                NPCTag npcTag = new NPCTag(npc);
                if (npcTag.hasFlag(flag) != want) continue;
                npcs.addObject(npcTag);
            }
            return npcs;
        }, "list_npcs_flagged");
        this.tagProcessor.registerTag(ListTag.class, "npc_registries", (attribute, object) -> {
            ListTag registries = new ListTag();
            for (NPCRegistry registry : CitizensAPI.getNPCRegistries()) {
                registries.add(registry.getName());
            }
            return registries;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "npcs", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            NPCRegistry registry = CitizensAPI.getNPCRegistry();
            if (attribute.hasParam() && (registry = NPCTag.getRegistryByName(attribute.getParam())) == null) {
                attribute.echoError("NPC Registry '" + attribute.getParam() + "' does not exist.");
                return null;
            }
            ListTag npcs = new ListTag();
            for (NPC npc : registry) {
                npcs.addObject(new NPCTag(npc));
            }
            return npcs;
        }, "list_npcs");
        this.tagProcessor.registerTag(ListTag.class, "traits", (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            ListTag traits = new ListTag();
            for (TraitInfo trait : CitizensAPI.getTraitFactory().getRegisteredTraits()) {
                traits.add(trait.getTraitName());
            }
            return traits;
        }, "list_traits");
        this.tagProcessor.registerMechanism("save_citizens", false, (object, mechanism) -> Depends.citizens.storeNPCs(), new String[0]);
    }

    public void registerEnumListTag(String name, Class<? extends Enum<?>> enumType, String ... deprecatedVariants) {
        this.tagProcessor.registerStaticTag(ListTag.class, name, (attribute, object) -> {
            ServerTagBase.listDeprecateWarn(attribute);
            Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
            ListTag result = new ListTag(enumConstants.length);
            for (Enum constant : enumConstants) {
                result.addObject(new ElementTag(constant));
            }
            return result;
        }, deprecatedVariants);
    }

    private static MapTag areaNotesDebug(Int2ObjectOpenHashMap<NotedAreaTracker.AreaSet> set) {
        MapTag out = new MapTag();
        for (Int2ObjectMap.Entry pair : set.int2ObjectEntrySet()) {
            out.putObject(String.valueOf(pair.getIntKey()), (ObjectTag)new ListTag(((NotedAreaTracker.AreaSet)pair.getValue()).list, trackedArea -> trackedArea.area));
        }
        return out;
    }

    public static void listDeprecateWarn(com.denizenscript.denizencore.tags.Attribute attribute) {
        if (attribute.getAttributeWithoutParam(1).startsWith("list_")) {
            BukkitImplDeprecations.listStyleTags.warn(attribute.context);
        }
    }

    public static ListTag getHandlerPluginList(Class eventClass) {
        HandlerList handlers;
        if (Event.class.isAssignableFrom(eventClass) && (handlers = BukkitScriptEvent.getEventListeners(eventClass)) != null) {
            ListTag result = new ListTag();
            HashSet<String> deduplicationSet = new HashSet<String>();
            for (RegisteredListener listener : handlers.getRegisteredListeners()) {
                if (!deduplicationSet.add(listener.getPlugin().getName())) continue;
                result.addObject(new PluginTag(listener.getPlugin()));
            }
            return result;
        }
        return null;
    }

    private static /* synthetic */ void lambda$register$98(Mechanism.GenericMechRunnerInterface runner, ServerTagBase object, Mechanism mechanism) {
        BukkitImplDeprecations.serverSystemMechanisms.warn(mechanism.context);
        runner.run(UtilTagBase.instance, mechanism);
    }
}

