/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(cuo.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, cuo.d.class, Float.TYPE});
    public ih<cuo> biomeHolder;
    public and world;

    public BiomeNMSImpl(and world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeHolder = world.I_().d(ke.at).b(ahf.a((ahf)ke.at, (ahg)new ahg(name))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        cuo.c precipitation = ((cuo)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location));
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case cuo.c.b -> BiomeNMS.DownfallType.RAIN;
            case cuo.c.c -> BiomeNMS.DownfallType.SNOW;
            case cuo.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((cuo)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((cuo)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((cuo)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location));
    }

    public boolean hasDownfall() {
        return ((cuo)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(bmo.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(bmo.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(bmo.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(bmo.f);
    }

    public int getFoliageColor() {
        if (((cuo)this.biomeHolder.a()).f() != 0) {
            return ((cuo)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, cuo.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(cuo.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(cuu.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((cuo)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((cuo)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(cuu.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((cuo)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((cuo)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(cuu.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((cuo)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(bmo creatureType) {
        cva mobs = ((cuo)this.biomeHolder.a()).b();
        bip typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (cva.c meta : typeSettingList.e()) {
            try {
                String n = blz.a((blz)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        dlo chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        hx pos = new hx(block.getX(), 0, block.getZ());
        if (this.world.B(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public cuo.d getTemperatureModifier() {
        return ((cuo)this.biomeHolder.a()).i.c();
    }
}

