/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import java.util.Date;
import java.util.List;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BanCommand
extends AbstractCommand {
    public BanCommand() {
        this.setName("ban");
        this.setSyntax("ban ({add}/remove) [<player>|.../addresses:<address>|.../names:<name>|...] (reason:<text>) (expire:<time>) (source:<text>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
        this.autoCompile();
        this.addRemappedPrefixes("addresses", "address");
        this.addRemappedPrefixes("expire", "duration", "time", "d", "expiration");
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="action") @ArgDefaultText(value="add") Actions action, @ArgName(value="targets") @ArgLinear @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> targets, @ArgName(value="addresses") @ArgPrefixed @ArgDefaultNull ListTag addresses, @ArgName(value="names") @ArgPrefixed @ArgDefaultNull ListTag names, @ArgName(value="reason") @ArgPrefixed @ArgDefaultNull String reason, @ArgName(value="expire") @ArgPrefixed @ArgDefaultNull ObjectTag rawExpire, @ArgName(value="source") @ArgPrefixed @ArgDefaultNull String source) {
        if (!(targets != null && !targets.isEmpty() || addresses != null && !addresses.isEmpty() || names != null && !names.isEmpty())) {
            throw new InvalidArgumentsRuntimeException("Must specify valid players, addresses or names to ban.");
        }
        Date expiration = null;
        if (rawExpire != null) {
            if (rawExpire.canBeType(DurationTag.class)) {
                DurationTag banDuration = rawExpire.asType(DurationTag.class, scriptEntry.context);
                if (banDuration.getSeconds() > 0.0) {
                    expiration = new Date(TimeTag.now().millis() + banDuration.getMillis());
                }
            } else {
                TimeTag expirationTime = rawExpire.asType(TimeTag.class, scriptEntry.context);
                if (expirationTime == null) {
                    throw new InvalidArgumentsRuntimeException("Invalid 'expire:' input, must be a DurationTag or a TimeTag.");
                }
                expiration = new Date(expirationTime.millis());
            }
        }
        switch (action) {
            case ADD: {
                if (targets != null) {
                    for (PlayerTag player : targets) {
                        if (!player.isValid()) continue;
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), reason, expiration, source);
                        if (!player.isOnline()) continue;
                        player.getPlayerEntity().kickPlayer(reason);
                    }
                }
                if (addresses != null) {
                    for (String address : addresses) {
                        Bukkit.getBanList((BanList.Type)BanList.Type.IP).addBan(address, reason, expiration, source);
                    }
                }
                if (names == null) break;
                for (String name : names) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(name, reason, expiration, source);
                    Player player = Bukkit.getPlayerExact((String)name);
                    if (player == null) continue;
                    player.kickPlayer(reason);
                }
                break;
            }
            case REMOVE: {
                if (targets != null) {
                    for (PlayerTag player : targets) {
                        if (!player.isValid() || !player.getOfflinePlayer().isBanned()) continue;
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(player.getName());
                    }
                }
                if (addresses != null) {
                    addresses.forEach(arg_0 -> ((BanList)Bukkit.getBanList((BanList.Type)BanList.Type.IP)).pardon(arg_0));
                }
                if (names == null) break;
                names.forEach(arg_0 -> ((BanList)Bukkit.getBanList((BanList.Type)BanList.Type.NAME)).pardon(arg_0));
            }
        }
    }

    public static enum Actions {
        ADD,
        REMOVE;

    }
}

