/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.utilities.Utilities;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class SpawnableHelper {
    public static HashSet<Material> DANGEROUS_MATERIALS = new HashSet<Material>(Utilities.allMaterialsThatMatch("fire|cactus|water|lava|magma_block|*cauldron|*campfire|*portal|cobweb|ladder|*fence|*door|end_rod|iron_bars|chain|*wall|*_pane*egg|*plate|tripwire|*piston"));

    public static boolean isSpawnable(Location loc) {
        World w = loc.getWorld();
        if (w == null) {
            return false;
        }
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        if (y - 1 <= w.getMinHeight() || y + 1 >= w.getMaxHeight()) {
            return false;
        }
        if (!w.getBlockAt(x, y + 1, z).getType().isAir()) {
            return false;
        }
        Material self = w.getBlockAt(x, y, z).getType();
        if (self.isSolid()) {
            return false;
        }
        if (DANGEROUS_MATERIALS.contains(self)) {
            return false;
        }
        Material below = w.getBlockAt(x, y - 1, z).getType();
        if (!below.isSolid()) {
            return false;
        }
        return !DANGEROUS_MATERIALS.contains(below);
    }
}

