/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class EnchantmentScriptContainer
extends ScriptContainer {
    public static AsciiMatcher descriptionCharsAllowed = new AsciiMatcher("abcdefghijklmnopqrstuvwxyz_");
    public static HashMap<String, EnchantmentReference> registeredEnchantmentContainers = new HashMap();
    public int minLevel;
    public int maxLevel;
    public String id;
    public String rarity;
    public String category;
    public String descriptionId;
    public String fullNameTaggable;
    public String canEnchantTaggable;
    public String isCompatibleTaggable;
    public String minCostTaggable;
    public String maxCostTaggable;
    public String damageBonusTaggable;
    public String damageProtectionTaggable;
    public boolean isTreasureOnly;
    public boolean isCurse;
    public boolean isTradable;
    public boolean isDiscoverable;
    public List<String> slots;
    public HashMap<Integer, BaseComponent[]> fullNamePerLevel = new HashMap();
    public Enchantment enchantment;
    public HashMap<Integer, Integer> minCosts = new HashMap();
    public HashMap<Integer, Integer> maxCosts = new HashMap();

    public EnchantmentScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        this.canRunScripts = false;
        this.id = descriptionCharsAllowed.trimToMatches(CoreUtilities.toLowerCase(this.getString("id", scriptContainerName)));
        this.descriptionId = "enchantment.denizen." + this.id;
        this.minLevel = Integer.parseInt(this.getString("min_level", "1"));
        this.maxLevel = Integer.parseInt(this.getString("max_level", "1"));
        this.isTreasureOnly = CoreUtilities.toLowerCase(this.getString("treasure_only", "false")).equals("true");
        this.isCurse = CoreUtilities.toLowerCase(this.getString("is_curse", "false")).equals("true");
        this.isTradable = CoreUtilities.toLowerCase(this.getString("is_tradable", "true")).equals("true");
        this.isDiscoverable = CoreUtilities.toLowerCase(this.getString("is_discoverable", "true")).equals("true");
        this.rarity = this.getString("rarity", "COMMON").toUpperCase();
        this.category = this.getString("category", "WEAPON").toUpperCase();
        this.slots = this.getStringList("slots");
        this.fullNameTaggable = this.getString("full_name", "");
        this.canEnchantTaggable = this.getString("can_enchant", "true");
        this.isCompatibleTaggable = this.getString("is_compatible", "true");
        this.minCostTaggable = this.getString("min_cost", "1");
        this.maxCostTaggable = this.getString("max_cost", "1");
        this.damageBonusTaggable = this.getString("damage_bonus", "0.0");
        this.damageProtectionTaggable = this.getString("damage_protection", "0");
        if (this.shouldEnable()) {
            boolean isNew;
            EnchantmentReference ref = registeredEnchantmentContainers.get(this.id);
            boolean bl = isNew = ref == null;
            if (isNew) {
                ref = new EnchantmentReference();
            }
            EnchantmentScriptContainer old = ref.script;
            ref.script = this;
            registeredEnchantmentContainers.put(this.id, ref);
            this.enchantment = isNew ? NMSHandler.enchantmentHelper.registerFakeEnchantment(ref) : old.enchantment;
        }
    }

    public void validateThread() {
        if (!Bukkit.isPrimaryThread()) {
            try {
                throw new RuntimeException("Stack reference");
            }
            catch (RuntimeException ex) {
                Debug.echoError("Warning: enchantment access from wrong thread, errors will result");
                Debug.echoError(ex);
            }
        }
    }

    public String autoTag(String value, ContextSource src) {
        if (value == null) {
            return null;
        }
        this.validateThread();
        BukkitTagContext context = new BukkitTagContext(null, new ScriptTag(this));
        context.contextSource = src;
        return TagManager.tag(value, context);
    }

    public String autoTagForLevel(String value, int level) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("level", new ElementTag(level));
        return this.autoTag(value, src);
    }

    public boolean canEnchant(ItemStack item) {
        if (!Bukkit.isPrimaryThread()) {
            return false;
        }
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("item", new ItemTag(item));
        String res = this.autoTag(this.canEnchantTaggable, src);
        return CoreUtilities.toLowerCase(res).equals("true");
    }

    public boolean isCompatible(Enchantment enchantment) {
        if (!Bukkit.isPrimaryThread()) {
            return false;
        }
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("enchantment_key", new ElementTag(enchantment.getKey().toString()));
        String res = this.autoTag(this.isCompatibleTaggable, src);
        return CoreUtilities.toLowerCase(res).equals("true");
    }

    public BaseComponent[] getFullName(int level) {
        BaseComponent[] result = this.fullNamePerLevel.get(level);
        if (result != null) {
            return result;
        }
        String tagged = this.autoTagForLevel(this.fullNameTaggable, level);
        result = FormattedTextHelper.parse(tagged, ChatColor.GRAY);
        this.fullNamePerLevel.put(level, result);
        return result;
    }

    public int getDamageProtection(int level, String causeName, Entity attacker) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("level", new ElementTag(level));
        src.contexts.put("cause", new ElementTag(causeName));
        if (attacker != null) {
            src.contexts.put("attacker", new EntityTag(attacker).getDenizenObject());
        }
        return Integer.parseInt(this.autoTag(this.damageProtectionTaggable, src));
    }

    public float getDamageBonus(int level, String type) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("level", new ElementTag(level));
        src.contexts.put("type", new ElementTag(type));
        return Float.parseFloat(this.autoTag(this.damageBonusTaggable, src));
    }

    public void runSubScript(String pathName, Entity attacker, Entity victim, Entity primary, int level) {
        this.validateThread();
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(new EntityTag(primary)), pathName);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        InstantQueue queue = new InstantQueue(this.getName());
        queue.addEntries(entries);
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        if (attacker != null) {
            src.contexts.put("attacker", new EntityTag(attacker).getDenizenObject());
        }
        if (victim != null) {
            src.contexts.put("victim", new EntityTag(victim).getDenizenObject());
        }
        src.contexts.put("level", new ElementTag(level));
        queue.contextSource = src;
        queue.start();
    }

    public void doPostAttack(Entity attacker, Entity victim, int level) {
        this.runSubScript("after attack", attacker, victim, attacker, level);
    }

    public void doPostHurt(Entity victim, Entity attacker, int level) {
        this.runSubScript("after hurt", attacker, victim, victim, level);
    }

    public int getMinCost(int level) {
        Integer cost = this.minCosts.get(level);
        if (cost != null) {
            return cost;
        }
        cost = Integer.valueOf(this.autoTagForLevel(this.minCostTaggable, level));
        this.minCosts.put(level, cost);
        return cost;
    }

    public int getMaxCost(int level) {
        Integer cost = this.maxCosts.get(level);
        if (cost != null) {
            return cost;
        }
        cost = Integer.valueOf(this.autoTagForLevel(this.maxCostTaggable, level));
        this.maxCosts.put(level, cost);
        return cost;
    }

    public static class EnchantmentReference {
        public EnchantmentScriptContainer script;
    }
}

