/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.SecretTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.core.EscapeTagUtil;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SQLCommand
extends AbstractCommand
implements Holdable {
    public static Map<String, Connection> connections = new HashMap<String, Connection>();

    public SQLCommand() {
        this.setName("sql");
        this.setSyntax("sql [id:<ID>] [disconnect/connect:<server> (username:<username>) (password:<secret>) (ssl:true/{false})/query:<query>/update:<update>]");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
    }

    @Override
    public void onDisable() {
        for (Map.Entry<String, Connection> entry : connections.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (SQLException e) {
                Debug.echoError(e);
            }
        }
        connections.clear();
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("sqlid") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("sqlid", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("connect")) {
                scriptEntry.addObject("action", new ElementTag("CONNECT"));
                scriptEntry.addObject("server", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("disconnect")) {
                scriptEntry.addObject("action", new ElementTag("DISCONNECT"));
                continue;
            }
            if (!scriptEntry.hasObject("query") && arg.matchesPrefix("query")) {
                scriptEntry.addObject("action", new ElementTag("QUERY"));
                scriptEntry.addObject("query", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("query") && arg.matchesPrefix("update")) {
                scriptEntry.addObject("action", new ElementTag("UPDATE"));
                scriptEntry.addObject("query", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("username") && arg.matchesPrefix("username")) {
                scriptEntry.addObject("username", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("password") && arg.matchesPrefix("password")) {
                scriptEntry.addObject("password", arg.object);
                continue;
            }
            if (!scriptEntry.hasObject("passwordfile") && arg.matchesPrefix("passwordfile")) {
                scriptEntry.addObject("passwordfile", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("ssl") && arg.matchesPrefix("ssl") && arg.asElement().isBoolean()) {
                scriptEntry.addObject("ssl", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("sqlid")) {
            throw new InvalidArgumentsException("Must specify an ID!");
        }
        if (!scriptEntry.hasObject("ssl")) {
            scriptEntry.defaultObject("ssl", new ElementTag("false"));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        block33: {
            if (!CoreConfiguration.allowSQL) {
                Debug.echoError(scriptEntry, "SQL disabled by config!");
                return;
            }
            ElementTag action = scriptEntry.getElement("action");
            ElementTag server = scriptEntry.getElement("server");
            ElementTag username = scriptEntry.getElement("username");
            ObjectTag password = (ObjectTag)scriptEntry.getObjectTag("password");
            ElementTag passwordFile = scriptEntry.getElement("passwordfile");
            ElementTag ssl = scriptEntry.getElement("ssl");
            ElementTag sqlID = scriptEntry.getElement("sqlid");
            ElementTag query = scriptEntry.getElement("query");
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), sqlID, action, server, username, passwordFile, query);
            }
            if (!(action.asString().equalsIgnoreCase("connect") || action.asString().equalsIgnoreCase("query") && scriptEntry.shouldWaitFor())) {
                scriptEntry.setFinished(true);
            }
            try {
                if (action.asString().equalsIgnoreCase("connect")) {
                    String passwordRaw;
                    if (server == null) {
                        Debug.echoError(scriptEntry, "Must specify a server!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (username == null) {
                        Debug.echoError(scriptEntry, "Must specify a username!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (password != null) {
                        if (password.canBeType(SecretTag.class)) {
                            passwordRaw = password.asType(SecretTag.class, scriptEntry.context).getValue();
                        } else {
                            Deprecations.oldNonSecretTagPassword.warn(scriptEntry);
                            passwordRaw = password.toString();
                        }
                    } else {
                        if (passwordFile == null) {
                            Debug.echoError(scriptEntry, "Must specify a password!");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        Deprecations.oldNonSecretTagPassword.warn(scriptEntry);
                        File f = new File(DenizenCore.implementation.getDataFolder(), passwordFile.asString());
                        if (!DenizenCore.implementation.canReadFile(f)) {
                            Debug.echoError(scriptEntry, "Cannot read from that file path due to security settings in Denizen/config.yml.");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        if (!f.exists()) {
                            Debug.echoError(scriptEntry, "Invalid passwordfile specified. File does not exist.");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        passwordRaw = CoreUtilities.journallingLoadFile(f.getAbsolutePath());
                        if (passwordRaw == null || passwordRaw.length() < 2 || passwordRaw.length() > 200) {
                            Debug.echoError(scriptEntry, "Invalid passwordfile specified. File content doesn't look like a password.");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        passwordRaw = passwordRaw.trim();
                    }
                    if (connections.containsKey(sqlID.asString().toUpperCase())) {
                        Debug.echoError(scriptEntry, "Already connected to a server with ID '" + sqlID.asString() + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    String passwordToUse = passwordRaw;
                    DenizenCore.runAsync(() -> {
                        Connection con = null;
                        if (CoreConfiguration.debugVerbose) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Connecting to " + server.asString());
                        }
                        try {
                            con = this.getConnection(username.asString(), passwordToUse, server.asString(), ssl.asString());
                        }
                        catch (Exception e) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "SQL Exception: " + e.getMessage());
                                scriptEntry.setFinished(true);
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, e);
                                }
                            });
                        }
                        if (CoreConfiguration.debugVerbose) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Connection did not error");
                        }
                        Connection conn = con;
                        if (con != null) {
                            DenizenCore.runOnMainThread(() -> {
                                connections.put(sqlID.asString().toUpperCase(), conn);
                                Debug.echoDebug((Debuggable)scriptEntry, "Successfully connected to " + String.valueOf(server));
                                scriptEntry.setFinished(true);
                            });
                        } else {
                            DenizenCore.runOnMainThread(() -> {
                                scriptEntry.setFinished(true);
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoDebug((Debuggable)scriptEntry, "Connecting errored!");
                                }
                            });
                        }
                    });
                } else if (action.asString().equalsIgnoreCase("disconnect")) {
                    Connection con = connections.get(sqlID.asString().toUpperCase());
                    if (con == null) {
                        Debug.echoError(scriptEntry, "Not connected to server with ID '" + sqlID.asString() + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    con.close();
                    connections.remove(sqlID.asString().toUpperCase());
                    Debug.echoDebug((Debuggable)scriptEntry, "Disconnected from '" + sqlID.asString() + "'.");
                } else if (action.asString().equalsIgnoreCase("query")) {
                    if (query == null) {
                        Debug.echoError(scriptEntry, "Must specify a query!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Connection con = connections.get(sqlID.asString().toUpperCase());
                    if (con == null) {
                        Debug.echoError(scriptEntry, "Not connected to server with ID '" + sqlID.asString() + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Running query " + query.asString());
                    Runnable doQuery = () -> {
                        try {
                            Statement statement = con.createStatement();
                            ResultSet set = statement.executeQuery(query.asString());
                            ResultSetMetaData rsmd = set.getMetaData();
                            int columns = rsmd.getColumnCount();
                            int count = 0;
                            ListTag rows = new ListTag();
                            ListTag resultList = new ListTag();
                            while (set.next()) {
                                ++count;
                                StringBuilder current = new StringBuilder();
                                ListTag subList = new ListTag();
                                for (int i = 0; i < columns; ++i) {
                                    current.append(EscapeTagUtil.escape(set.getString(i + 1))).append("/");
                                    subList.addObject(new ElementTag(set.getString(i + 1)));
                                }
                                rows.add(current.toString());
                                resultList.addObject(subList);
                            }
                            scriptEntry.saveObject("result", rows);
                            scriptEntry.saveObject("result_list", resultList);
                            int finalCount = count;
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoDebug((Debuggable)scriptEntry, "Got a query result of " + columns + " columns and " + finalCount + " rows");
                                scriptEntry.setFinished(true);
                            });
                        }
                        catch (Exception ex) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "SQL Exception: " + ex.getMessage());
                                scriptEntry.setFinished(true);
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, ex);
                                }
                            });
                        }
                    };
                    if (scriptEntry.shouldWaitFor()) {
                        DenizenCore.runAsync(doQuery);
                    } else {
                        doQuery.run();
                    }
                } else if (action.asString().equalsIgnoreCase("update")) {
                    if (query == null) {
                        Debug.echoError(scriptEntry, "Must specify an update query!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Connection con = connections.get(sqlID.asString().toUpperCase());
                    if (con == null) {
                        Debug.echoError(scriptEntry, "Not connected to server with ID '" + sqlID.asString() + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Running update " + query.asString());
                    Runnable doUpdate = () -> {
                        try {
                            Statement statement = con.createStatement();
                            int affected = statement.executeUpdate(query.asString(), 1);
                            scriptEntry.saveObject("affected_rows", new ElementTag(affected));
                            ResultSet set = statement.getGeneratedKeys();
                            ResultSetMetaData rsmd = set.getMetaData();
                            int columns = rsmd.getColumnCount();
                            ListTag rows = new ListTag();
                            ListTag resultList = new ListTag();
                            while (set.next()) {
                                StringBuilder current = new StringBuilder();
                                ListTag subList = new ListTag();
                                for (int i = 0; i < columns; ++i) {
                                    current.append(EscapeTagUtil.escape(set.getString(i + 1))).append("/");
                                    subList.addObject(new ElementTag(set.getString(i + 1)));
                                }
                                rows.add(current.toString());
                                resultList.addObject(subList);
                            }
                            scriptEntry.saveObject("result", rows);
                            scriptEntry.saveObject("result_list", resultList);
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoDebug((Debuggable)scriptEntry, "Got a query result of " + columns + " columns");
                                Debug.echoDebug((Debuggable)scriptEntry, "Updated " + affected + " rows");
                                scriptEntry.setFinished(true);
                            });
                        }
                        catch (Exception ex) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "SQL Exception: " + ex.getMessage());
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, ex);
                                }
                            });
                        }
                    };
                    if (scriptEntry.shouldWaitFor()) {
                        DenizenCore.runAsync(doUpdate);
                    } else {
                        doUpdate.run();
                    }
                } else {
                    Debug.echoError(scriptEntry, "Unknown action '" + action.asString() + "'");
                }
            }
            catch (SQLException ex) {
                Debug.echoError(scriptEntry, "SQL Exception: " + ex.getMessage());
                if (!CoreConfiguration.debugVerbose) break block33;
                Debug.echoError(scriptEntry, ex);
            }
        }
    }

    public Connection getConnection(String userName, String password, String server, String ssl) throws SQLException {
        Properties connectionProps = new Properties();
        connectionProps.put("user", userName);
        connectionProps.put("password", password);
        connectionProps.put("useSSL", ssl);
        connectionProps.put("LoginTimeout", "7");
        if (!((String)server).contains("://")) {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver").newInstance();
            }
            catch (Throwable ex) {
                try {
                    Class.forName("com.mysql.jdbc.Driver");
                }
                catch (Throwable ex2) {
                    Debug.echoError(ex2);
                }
            }
            server = "mysql://" + (String)server;
        }
        return DriverManager.getConnection("jdbc:" + (String)server, connectionProps);
    }
}

