/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.VectorObject;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;

public class QuaternionTag
implements ObjectTag {
    private String prefix = "Quaternion";
    public double x;
    public double y;
    public double z;
    public double w;
    public static ObjectTagProcessor<QuaternionTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="quaternion")
    public static QuaternionTag valueOf(String string, TagContext context) {
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("quaternion@")) {
            string = string.substring("quaternion@".length());
        }
        if (string.equals("identity")) {
            return new QuaternionTag(0.0, 0.0, 0.0, 1.0);
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() != 4) {
            if (context == null || context.showErrors()) {
                Debug.log("Minor: valueOf QuaternionTag returning null: '" + string + "': not in valid quaternion format (x,y,z,w).");
            }
            return null;
        }
        try {
            double x = Double.parseDouble(split.get(0));
            double y = Double.parseDouble(split.get(1));
            double z = Double.parseDouble(split.get(2));
            double w = Double.parseDouble(split.get(3));
            return new QuaternionTag(x, y, z, w);
        }
        catch (NumberFormatException ex) {
            if (context == null || context.showErrors()) {
                Debug.log("Minor: valueOf QuaternionTag returning null: '" + string + "': has invalid value: " + ex.getMessage());
            }
            return null;
        }
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("quaternion@")) {
            return true;
        }
        return QuaternionTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public QuaternionTag(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public String identify() {
        return "quaternion@" + CoreUtilities.doubleToString(this.x) + "," + CoreUtilities.doubleToString(this.y) + "," + CoreUtilities.doubleToString(this.z) + "," + CoreUtilities.doubleToString(this.w);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        return "<LG>quaternion@<Y>" + CoreUtilities.doubleToString(this.x) + "<G>, <Y>" + CoreUtilities.doubleToString(this.y) + "<G>, <Y>" + CoreUtilities.doubleToString(this.z) + "<G>, <Y>" + CoreUtilities.doubleToString(this.w);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "x", (attribute, object) -> new ElementTag(object.x), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "y", (attribute, object) -> new ElementTag(object.y), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "z", (attribute, object) -> new ElementTag(object.z), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "w", (attribute, object) -> new ElementTag(object.w), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "xyz", (attribute, object) -> new ElementTag(CoreUtilities.doubleToString(object.x) + "," + CoreUtilities.doubleToString(object.y) + "," + CoreUtilities.doubleToString(object.z)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "xyzw", (attribute, object) -> new ElementTag(CoreUtilities.doubleToString(object.x) + "," + CoreUtilities.doubleToString(object.y) + "," + CoreUtilities.doubleToString(object.z) + "," + CoreUtilities.doubleToString(object.w)), new String[0]);
        tagProcessor.registerStaticTag(VectorObject.class, "xyz_vector", (attribute, object) -> DenizenCore.implementation.getVector(object.x, object.y, object.z), new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, QuaternionTag.class, "plus", (attribute, object, other) -> new QuaternionTag(object.x + other.x, object.y + other.y, object.z + other.z, object.w + other.w), new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, QuaternionTag.class, "mul", (attribute, object, other) -> object.multipliedBy((QuaternionTag)other), new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, ElementTag.class, "scale", (attribute, object, scale) -> {
            double s = scale.asDouble();
            return new QuaternionTag(object.x * s, object.y * s, object.z * s, object.w * s);
        }, new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, "normalize", (attribute, object) -> object.normalized(), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "length", (attribute, object) -> new ElementTag(object.length()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "length_squared", (attribute, object) -> new ElementTag(object.lengthSquared()), new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, "conjugate", (attribute, object) -> object.conjugate(), new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, "inverse", (attribute, object) -> {
            double len_sq = object.lengthSquared();
            return new QuaternionTag(-object.x * len_sq, -object.y * len_sq, -object.z * len_sq, object.w * len_sq);
        }, new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, "negative", (attribute, object) -> object.negative(), new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, QuaternionTag.class, "quaternion_between", (attribute, object, other) -> object.multipliedBy(other.conjugate()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ObjectTag.class, "axis_angle_for", (attribute, object, param) -> {
            VectorObject axis = DenizenCore.implementation.vectorize(param, attribute.context);
            if (axis == null) {
                return null;
            }
            VectorObject ra = DenizenCore.implementation.getVector(object.x, object.y, object.z);
            VectorObject p = ra.project(axis);
            QuaternionTag twist = new QuaternionTag(p.getX(), p.getY(), p.getZ(), object.w).normalized();
            VectorObject new_forward = twist.transformX();
            return new ElementTag(QuaternionTag.vecToAngle(new_forward.getX(), new_forward.getY()));
        }, new String[0]);
        tagProcessor.registerStaticTag(VectorObject.class, ObjectTag.class, "transform", (attribute, object, param) -> object.transform(DenizenCore.implementation.vectorize(param, attribute.context)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "represented_angle", (attribute, object) -> new ElementTag(object.representedAngle()), new String[0]);
        tagProcessor.registerStaticTag(VectorObject.class, "represented_axis", (attribute, object) -> object.representedAxis(), new String[0]);
        tagProcessor.registerStaticTag(QuaternionTag.class, MapTag.class, "slerp", (attribute, object, map) -> {
            QuaternionTag end = map.getRequiredObjectAs("end", QuaternionTag.class, attribute);
            ElementTag slerpAmount = map.getRequiredObjectAs("amount", ElementTag.class, attribute);
            if (end == null || slerpAmount == null) {
                return null;
            }
            return object.slerp(end, slerpAmount.asDouble());
        }, new String[0]);
    }

    public QuaternionTag slerp(QuaternionTag end, double slerpAmount) {
        double cosHalfTheta = this.w * end.w + this.x * end.x + this.y * end.y + this.z * end.z;
        if (cosHalfTheta < 0.0) {
            end = end.negative();
            cosHalfTheta = -cosHalfTheta;
        }
        if (cosHalfTheta > 0.999999999999) {
            return this;
        }
        double halfTheta = Math.acos(cosHalfTheta);
        double sinHalfTheta = Math.sqrt(1.0 - cosHalfTheta * cosHalfTheta);
        double aFraction = Math.sin((1.0 - slerpAmount) * halfTheta) / sinHalfTheta;
        double bFraction = Math.sin(slerpAmount * halfTheta) / sinHalfTheta;
        return new QuaternionTag(this.x * aFraction + end.x * bFraction, this.y * aFraction + end.y * bFraction, this.z * aFraction + end.z * bFraction, this.w * aFraction + end.w * bFraction);
    }

    public VectorObject representedAxis() {
        double z;
        double y;
        double sign = Math.signum(this.w);
        double x = this.x * sign;
        double len = Math.sqrt(x * x + (y = this.y * sign) * y + (z = this.z * sign) * z);
        if (len == 0.0) {
            len = 1.0;
        }
        len = 1.0 / len;
        return DenizenCore.implementation.getVector(x * len, y * len, z * len);
    }

    public double representedAngle() {
        double wAbs = Math.abs(this.w);
        if (wAbs > 1.0) {
            return 0.0;
        }
        return 2.0 * Math.acos(wAbs);
    }

    public static double vecToAngle(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            return 0.0;
        }
        if (x != 0.0) {
            return Math.atan2(y, x);
        }
        if (y > 0.0) {
            return 0.0;
        }
        return Math.PI;
    }

    public VectorObject transform(VectorObject v) {
        VectorObject other = v.duplicate();
        double x2 = this.x * 2.0;
        double y2 = this.y * 2.0;
        double z2 = this.z * 2.0;
        double xx2 = this.x * x2;
        double xy2 = this.x * y2;
        double xz2 = this.x * z2;
        double yy2 = this.y * y2;
        double yz2 = this.y * z2;
        double zz2 = this.z * z2;
        double wx2 = this.w * x2;
        double wy2 = this.w * y2;
        double wz2 = this.w * z2;
        other.setX(v.getX() * (1.0 - yy2 - zz2) + v.getY() * (xy2 - wz2) + v.getZ() * (xz2 + wy2));
        other.setY(v.getX() * (xy2 + wz2) + v.getY() * (1.0 - xx2 - zz2) + v.getZ() * (yz2 - wx2));
        other.setZ(v.getX() * (xz2 - wy2) + v.getY() * (yz2 + wx2) + v.getZ() * (1.0 - xx2 - yy2));
        return other;
    }

    public VectorObject transformX() {
        double y2 = this.y * 2.0;
        double z2 = this.z * 2.0;
        return DenizenCore.implementation.getVector(1.0 - this.y * y2 - this.z * z2, this.x * y2 + this.w * z2, this.x * z2 - this.w * y2);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public QuaternionTag multipliedBy(QuaternionTag b) {
        return new QuaternionTag(this.x * b.w + b.x * this.w + this.y * b.z - this.z * b.y, this.y * b.w + b.y * this.w + this.z * b.x - this.x * b.z, this.z * b.w + b.z * this.w + this.x * b.y - this.y * b.x, this.w * b.w - this.x * b.x - this.y * b.y - this.z * b.z);
    }

    public QuaternionTag conjugate() {
        return new QuaternionTag(-this.x, -this.y, -this.z, this.w);
    }

    public QuaternionTag negative() {
        return new QuaternionTag(-this.x, -this.y, -this.z, -this.w);
    }

    public QuaternionTag normalized() {
        double len = 1.0 / this.length();
        return new QuaternionTag(this.x * len, this.y * len, this.z * len, this.w * len);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

