/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.server.ListPingScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.paper.PaperModule;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerListPingScriptEventPaperImpl
extends ListPingScriptEvent {
    public ServerListPingScriptEventPaperImpl() {
        this.registerOptionalDetermination("protocol_version", ElementTag.class, (evt, context, version) -> {
            if (version.isInt()) {
                ((PaperServerListPingEvent)evt.event).setProtocolVersion(version.asInt());
                return true;
            }
            return false;
        });
        this.registerDetermination("version_name", ElementTag.class, (evt, context, name) -> ((PaperServerListPingEvent)evt.event).setVersion(name.toString()));
        this.registerDetermination("exclude_players", ListTag.class, (evt, context, list) -> {
            HashSet<UUID> exclusions = new HashSet<UUID>();
            for (PlayerTag player : list.filter(PlayerTag.class, context)) {
                exclusions.add(player.getUUID());
            }
            Iterator players = ((PaperServerListPingEvent)evt.event).iterator();
            while (players.hasNext()) {
                if (!exclusions.contains(((Player)players.next()).getUniqueId())) continue;
                players.remove();
            }
        });
        this.registerOptionalDetermination("alternate_player_text", ListTag.class, (evt, context, text) -> {
            if (!CoreConfiguration.allowRestrictedActions) {
                Debug.echoError((String)"Cannot use 'alternate_player_text' in list ping event: 'Allow restricted actions' is disabled in Denizen config.yml.");
                return false;
            }
            ((PaperServerListPingEvent)evt.event).getPlayerSample().clear();
            for (String line : text) {
                FakeProfile lineProf = new FakeProfile();
                lineProf.setName(line);
                ((PaperServerListPingEvent)evt.event).getPlayerSample().add(lineProf);
            }
            return true;
        });
    }

    public void setMotd(String text) {
        this.event.motd(PaperModule.parseFormattedText(text, ChatColor.WHITE));
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "motd" -> new ElementTag(PaperModule.stringifyComponent(this.event.motd()));
            case "protocol_version" -> new ElementTag(((PaperServerListPingEvent)this.event).getProtocolVersion());
            case "version_name" -> new ElementTag(((PaperServerListPingEvent)this.event).getVersion());
            case "client_protocol_version" -> new ElementTag(((PaperServerListPingEvent)this.event).getClient().getProtocolVersion());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onListPing(PaperServerListPingEvent event) {
        this.syncFire((ServerListPingEvent)event);
    }

    public static class FakeProfile
    implements PlayerProfile {
        public String name;

        @Nullable
        public String getName() {
            return this.name;
        }

        @NotNull
        public String setName(@Nullable String s) {
            String old = this.name;
            this.name = s;
            return old;
        }

        @Nullable
        public UUID getUniqueId() {
            return null;
        }

        @Nullable
        public UUID getId() {
            return null;
        }

        @Nullable
        public UUID setId(@Nullable UUID uuid) {
            return null;
        }

        @NotNull
        public PlayerTextures getTextures() {
            return null;
        }

        public void setTextures(@Nullable PlayerTextures playerTextures) {
        }

        @NotNull
        public Set<ProfileProperty> getProperties() {
            return null;
        }

        public boolean hasProperty(@Nullable String s) {
            return false;
        }

        public void setProperty(@NotNull ProfileProperty profileProperty) {
        }

        public void setProperties(@NotNull Collection<ProfileProperty> collection) {
        }

        public boolean removeProperty(@Nullable String s) {
            return false;
        }

        public void clearProperties() {
        }

        public boolean isComplete() {
            return false;
        }

        @NotNull
        public CompletableFuture<PlayerProfile> update() {
            return null;
        }

        public @NotNull org.bukkit.profile.PlayerProfile clone() {
            return null;
        }

        public boolean completeFromCache() {
            return false;
        }

        public boolean completeFromCache(boolean b) {
            return false;
        }

        public boolean completeFromCache(boolean b, boolean b1) {
            return false;
        }

        public boolean complete(boolean b) {
            return false;
        }

        public boolean complete(boolean b, boolean b1) {
            return false;
        }

        @NotNull
        public Map<String, Object> serialize() {
            return null;
        }
    }
}

