/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.reflect.Field;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.util.Vector;

public class AttachPacketHandlers {
    public static Field POS_X_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xa, Short.TYPE);
    public static Field POS_Y_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_ya, Short.TYPE);
    public static Field POS_Z_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_za, Short.TYPE);
    public static Field YAW_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xRot, Byte.TYPE);
    public static Field ENTITY_ID_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_id, Integer.TYPE);
    public static Field POS_X_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_x, Double.TYPE);
    public static Field POS_Y_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_y, Double.TYPE);
    public static Field POS_Z_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_z, Double.TYPE);
    public static Field YAW_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_xRot, Byte.TYPE);
    public static Field ENTITY_ID_PACKVELENT = ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get(ReflectionMappingsInfo.ClientboundSetEntityMotionPacket_id, Integer.TYPE);
    public static Vector VECTOR_ZERO = new Vector(0, 0, 0);

    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityHeadRotation.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityVelocity.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityTeleport.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityDestroy.class, AttachPacketHandlers::processAttachToForPacket);
    }

    public static void tryProcessMovePacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntity packet, Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cz());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                PacketPlayOutEntity.PacketPlayOutRelEntityMove pNew;
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cz());
                if (!attMap.attached.isValid() || att == null) continue;
                int newId = att.attached.getBukkitEntity().getEntityId();
                if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(newId, packet.b(), packet.e(), packet.f(), packet.k());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutEntityLook(newId, packet.g(), packet.h(), packet.k());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(newId, packet.b(), packet.e(), packet.f(), packet.g(), packet.h(), packet.k());
                } else {
                    if (CoreConfiguration.debugVerbose) {
                        Debug.echoError("Impossible move-entity packet class: " + packet.getClass().getCanonicalName());
                    }
                    return;
                }
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    Entity attachedEntity;
                    boolean isRotate;
                    boolean bl = isRotate = packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook || packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook;
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dE());
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dG());
                    } else if (isRotate) {
                        yaw = packet.g();
                        pitch = packet.h();
                    } else {
                        yaw = EntityAttachmentHelper.compressAngle(e2.dE());
                        pitch = EntityAttachmentHelper.compressAngle(e2.dG());
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dG());
                    }
                    byte newYaw = yaw;
                    if (isRotate) {
                        newYaw = EntityAttachmentHelper.adaptedCompressedAngle(newYaw, att.positionalOffset.getYaw());
                        pitch = EntityAttachmentHelper.adaptedCompressedAngle(pitch, att.positionalOffset.getPitch());
                    }
                    Vector goalPosition = att.fixedForOffset(new Vector(e2.dt(), e2.dv(), e2.dz()), e2.dE(), e2.dG());
                    Vector oldPos = att.visiblePositions.get(networkManager.player.cz());
                    boolean forceTele = false;
                    if (oldPos == null) {
                        oldPos = att.attached.getLocation().toVector();
                        forceTele = true;
                    }
                    Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                    att.visiblePositions.put(networkManager.player.cz(), goalPosition.clone());
                    int offX = (int)(moveNeeded.getX() * 4096.0);
                    int offY = (int)(moveNeeded.getY() * 4096.0);
                    int offZ = (int)(moveNeeded.getZ() * 4096.0);
                    if (isRotate && att.offsetRelative || forceTele || offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                        PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(e2);
                        ENTITY_ID_PACKTELENT.setInt(newTeleportPacket, att.attached.getBukkitEntity().getEntityId());
                        POS_X_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getX());
                        POS_Y_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getY());
                        POS_Z_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getZ());
                        YAW_PACKTELENT.setByte(newTeleportPacket, newYaw);
                        PITCH_PACKTELENT.setByte(newTeleportPacket, pitch);
                        if (NMSHandler.debugPackets) {
                            DenizenNetworkManagerImpl.doPacketOutput("Attach Move-Tele Packet: " + newTeleportPacket.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cB() + " with original yaw " + yaw + " adapted to " + newYaw);
                        }
                        networkManager.oldManager.a((Packet)newTeleportPacket);
                        continue;
                    }
                    POS_X_PACKENT.setShort(pNew, (short)MathHelper.a((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Y_PACKENT.setShort(pNew, (short)MathHelper.a((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Z_PACKENT.setShort(pNew, (short)MathHelper.a((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    if (isRotate) {
                        YAW_PACKENT.setByte(pNew, yaw);
                        PITCH_PACKENT.setByte(pNew, pitch);
                    }
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Move Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cB() + " with original yaw " + yaw + " adapted to " + newYaw);
                    }
                    networkManager.oldManager.a((Packet)pNew);
                    continue;
                }
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Replica-Move Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cB());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e2.p != null && !e2.p.isEmpty()) {
            for (Entity ent : e2.p) {
                AttachPacketHandlers.tryProcessMovePacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessRotateHeadPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityHeadRotation packet, Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cz());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cz());
                if (!attMap.attached.isValid() || att == null) continue;
                byte yaw = packet.b();
                Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                if (att.positionalOffset != null) {
                    if (att.noRotate) {
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dE());
                    }
                    yaw = EntityAttachmentHelper.adaptedCompressedAngle(yaw, att.positionalOffset.getYaw());
                }
                PacketPlayOutEntityHeadRotation pNew = new PacketPlayOutEntityHeadRotation(attachedEntity, yaw);
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Head Rotation Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cB());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e2.p != null && !e2.p.isEmpty()) {
            for (Entity ent : e2.p) {
                AttachPacketHandlers.tryProcessRotateHeadPacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessVelocityPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityVelocity packet, Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cz());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cz());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityVelocity pNew = (PacketPlayOutEntityVelocity)PacketPlayOutEntityVelocity.a.decode((Object)DenizenNetworkManagerImpl.copyPacket(packet, PacketPlayOutEntityVelocity.a));
                ENTITY_ID_PACKVELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Velocity Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cB());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e2.p != null && !e2.p.isEmpty()) {
            for (Entity ent : e2.p) {
                AttachPacketHandlers.tryProcessVelocityPacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessTeleportPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityTeleport packet, Entity e2, Vector relative) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cz());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cz());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityTeleport pNew = (PacketPlayOutEntityTeleport)PacketPlayOutEntityTeleport.a.decode((Object)DenizenNetworkManagerImpl.copyPacket(packet, PacketPlayOutEntityTeleport.a));
                ENTITY_ID_PACKTELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                Vector resultPos = new Vector(POS_X_PACKTELENT.getDouble(pNew), POS_Y_PACKTELENT.getDouble(pNew), POS_Z_PACKTELENT.getDouble(pNew)).add(relative);
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    Entity attachedEntity;
                    resultPos = att.fixedForOffset(resultPos, e2.dE(), e2.dG());
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dE());
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dG());
                    } else {
                        yaw = packet.h();
                        pitch = packet.i();
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dG());
                    }
                    byte newYaw = EntityAttachmentHelper.adaptedCompressedAngle(yaw, att.positionalOffset.getYaw());
                    pitch = EntityAttachmentHelper.adaptedCompressedAngle(pitch, att.positionalOffset.getPitch());
                    POS_X_PACKTELENT.setDouble(pNew, resultPos.getX());
                    POS_Y_PACKTELENT.setDouble(pNew, resultPos.getY());
                    POS_Z_PACKTELENT.setDouble(pNew, resultPos.getZ());
                    YAW_PACKTELENT.setByte(pNew, newYaw);
                    PITCH_PACKTELENT.setByte(pNew, pitch);
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Teleport Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cB() + " with raw yaw " + yaw + " adapted to " + newYaw);
                    }
                }
                att.visiblePositions.put(networkManager.player.cz(), resultPos.clone());
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e2.p != null && !e2.p.isEmpty()) {
            for (Entity ent : e2.p) {
                AttachPacketHandlers.tryProcessTeleportPacketForAttach(networkManager, packet, ent, new Vector(ent.dt() - e2.dt(), ent.dv() - e2.dv(), ent.dz() - e2.dz()));
            }
        }
    }

    public static Packet<PacketListenerPlayOut> processAttachToForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (EntityAttachmentHelper.toEntityToData.isEmpty()) {
            return packet;
        }
        try {
            if (packet instanceof PacketPlayOutEntity) {
                PacketPlayOutEntity moveEntityPacket = (PacketPlayOutEntity)packet;
                Entity e2 = moveEntityPacket.a(networkManager.player.dO());
                if (e2 == null) {
                    return packet;
                }
                if (!e2.bS()) {
                    AttachPacketHandlers.tryProcessMovePacketForAttach(networkManager, moveEntityPacket, e2);
                }
                return EntityAttachmentHelper.denyOriginalPacketSend(networkManager.player.cz(), e2.cz()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityHeadRotation) {
                PacketPlayOutEntityHeadRotation rotateHeadPacket = (PacketPlayOutEntityHeadRotation)packet;
                Entity e3 = rotateHeadPacket.a(networkManager.player.dO());
                if (e3 == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessRotateHeadPacketForAttach(networkManager, rotateHeadPacket, e3);
                return EntityAttachmentHelper.denyOriginalPacketSend(networkManager.player.cz(), e3.cz()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityVelocity) {
                PacketPlayOutEntityVelocity setEntityMotionPacket = (PacketPlayOutEntityVelocity)packet;
                int ider = setEntityMotionPacket.b();
                Entity e4 = networkManager.player.dO().a(ider);
                if (e4 == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessVelocityPacketForAttach(networkManager, setEntityMotionPacket, e4);
                return EntityAttachmentHelper.denyOriginalPacketSend(networkManager.player.cz(), e4.cz()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                PacketPlayOutEntityTeleport teleportEntityPacket = (PacketPlayOutEntityTeleport)packet;
                int ider = teleportEntityPacket.b();
                Entity e5 = networkManager.player.dO().a(ider);
                if (e5 == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessTeleportPacketForAttach(networkManager, teleportEntityPacket, e5, VECTOR_ZERO);
                return EntityAttachmentHelper.denyOriginalPacketSend(networkManager.player.cz(), e5.cz()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityDestroy) {
                PacketPlayOutEntityDestroy removeEntitiesPacket = (PacketPlayOutEntityDestroy)packet;
                IntListIterator intListIterator = removeEntitiesPacket.b().iterator();
                while (intListIterator.hasNext()) {
                    EntityAttachmentHelper.EntityAttachedToMap attList;
                    int id = (Integer)intListIterator.next();
                    Entity e6 = networkManager.player.dO().a(id);
                    if (e6 == null || (attList = EntityAttachmentHelper.toEntityToData.get(e6.cz())) == null) continue;
                    for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                        EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cz());
                        if (!attMap.attached.isValid() || att == null) continue;
                        att.visiblePositions.remove(networkManager.player.cz());
                    }
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return packet;
    }
}

