/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Goat;
import org.bukkit.inventory.EquipmentSlot;

public class PaperEntityExtensions {
    public static void register() {
        EntityTag.tagProcessor.registerTag(ElementTag.class, "spawn_reason", (attribute, entity) -> new ElementTag((Enum)entity.getBukkitEntity().getEntitySpawnReason()), new String[0]);
        EntityTag.tagProcessor.registerTag(ElementTag.class, "xp_spawn_reason", (attribute, entity) -> {
            Entity patt0$temp = entity.getBukkitEntity();
            if (!(patt0$temp instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + String.valueOf(entity) + " is not an experience orb.");
                return null;
            }
            ExperienceOrb experienceOrb = (ExperienceOrb)patt0$temp;
            return new ElementTag((Enum)experienceOrb.getSpawnReason());
        }, new String[0]);
        EntityTag.tagProcessor.registerTag(EntityFormObject.class, "xp_trigger", (attribute, entity) -> {
            Entity patt0$temp = entity.getBukkitEntity();
            if (!(patt0$temp instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + String.valueOf(entity) + " is not an experience orb.");
                return null;
            }
            ExperienceOrb experienceOrb = (ExperienceOrb)patt0$temp;
            UUID uuid = experienceOrb.getTriggerEntityId();
            if (uuid == null) {
                return null;
            }
            Entity e = EntityTag.getEntityForID((UUID)uuid);
            if (e == null) {
                return null;
            }
            return new EntityTag(e).getDenizenObject();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, (String)"xp_source", (attribute, entity) -> {
            Entity patt0$temp = entity.getBukkitEntity();
            if (!(patt0$temp instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + String.valueOf(entity) + " is not an experience orb.");
                return null;
            }
            ExperienceOrb experienceOrb = (ExperienceOrb)patt0$temp;
            UUID uuid = experienceOrb.getSourceEntityId();
            if (uuid == null) {
                return null;
            }
            Entity e = EntityTag.getEntityForID((UUID)uuid);
            if (e == null) {
                return null;
            }
            return new EntityTag(e).getDenizenObject();
        }, (String[])new String[0]);
        EntityTag.tagProcessor.registerTag(LocationTag.class, "spawn_location", (attribute, entity) -> {
            Location loc = entity.getBukkitEntity().getOrigin();
            return loc != null ? new LocationTag(loc) : null;
        }, new String[0]);
        EntityTag.tagProcessor.registerTag(ElementTag.class, "from_spawner", (attribute, entity) -> new ElementTag(entity.getBukkitEntity().fromMobSpawner()), new String[0]);
        EntityTag.registerSpawnedOnlyMechanism((String)"goat_ram", (boolean)false, EntityTag.class, (object, mechanism, input) -> {
            Entity patt0$temp = object.getBukkitEntity();
            if (patt0$temp instanceof Goat) {
                Goat goat = (Goat)patt0$temp;
                goat.ram(input.getLivingEntity());
            }
        });
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
            EntityTag.tagProcessor.registerTag(ElementTag.class, LocationTag.class, "collides_at", (attribute, entity, location) -> new ElementTag(entity.getBukkitEntity().collidesAt((Location)location)), new String[0]);
            EntityTag.registerSpawnedOnlyMechanism((String)"damage_item", (boolean)false, MapTag.class, (object, mechanism, input) -> {
                ElementTag slot = input.getElement("slot");
                ElementTag amount = input.getElement("amount");
                if (slot == null || !slot.matchesEnum(EquipmentSlot.class)) {
                    mechanism.echoError("Must specify a valid equipment slot to damage.");
                    return;
                }
                if (amount == null || !amount.isInt()) {
                    mechanism.echoError("Must specify a valid amount to damage this item for.");
                    return;
                }
                object.getLivingEntity().damageItemStack((EquipmentSlot)slot.asEnum(EquipmentSlot.class), amount.asInt());
            });
        }
    }
}

