/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.LegacyNamingHelper;
import com.denizenscript.denizen.utilities.maps.MapObject;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class MapCursor
extends MapObject {
    protected String directionTag;
    protected String typeTag;
    protected Map<UUID, org.bukkit.map.MapCursor> cursors = new HashMap<UUID, org.bukkit.map.MapCursor>();

    public MapCursor(String xTag, String yTag, String visibilityTag, boolean debug, String directionTag, String typeTag) {
        super(xTag, yTag, visibilityTag, debug);
        this.directionTag = directionTag;
        this.typeTag = typeTag;
    }

    public byte getDirection(PlayerTag player) {
        return this.yawToDirection(Double.parseDouble(this.tag(this.directionTag, player)));
    }

    public MapCursor.Type getType(PlayerTag player) {
        return LegacyNamingHelper.convert(MapCursor.Type.class, this.tag(this.typeTag, player));
    }

    private byte yawToDirection(double yaw) {
        return (byte)(Math.floor(yaw / 22.5 + 0.5) % 16.0);
    }

    @Override
    public void update(PlayerTag player, UUID uuid) {
        super.update(player, uuid);
        if (this.cursors.containsKey(uuid)) {
            org.bukkit.map.MapCursor cursor = this.cursors.get(uuid);
            cursor.setX((byte)this.getX(player));
            cursor.setY((byte)this.getY(player));
            cursor.setVisible(this.isVisibleTo(player));
            cursor.setDirection(this.getDirection(player));
            cursor.setType(this.getType(player));
        }
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "CURSOR");
        data.put("direction", this.directionTag);
        data.put("cursor", this.typeTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, PlayerTag player, UUID uuid) {
        try {
            int x = (this.getX(player) - 64) * 2;
            int z = (this.getY(player) - 64) * 2;
            if (x < -127 || z < -127 || x > 127 || z > 127) {
                if (this.showPastEdge) {
                    x = Math.max(Math.min(x, 127), -127);
                    z = Math.max(Math.min(z, 127), -127);
                } else {
                    return;
                }
            }
            org.bukkit.map.MapCursor cursor = new org.bukkit.map.MapCursor((byte)x, (byte)z, this.getDirection(player), this.getType(player).getValue(), this.isVisibleTo(player));
            mapCanvas.getCursors().addCursor(cursor);
            this.cursors.put(uuid, cursor);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }
}

