/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(cul.class).get(ReflectionMappingsInfo.Item_components, km.class);
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final ub EMPTY_TAG = new ub();
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(csc.class).get((Object)ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static czb<?> getNMSRecipe(NamespacedKey key) {
        akr nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        return ((CraftServer)Bukkit.getServer()).getServer().aJ().a(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            cul nmsItem = (cul)lt.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            km currentComponents = nmsItem.p();
            Item_components.set(nmsItem, km.a((km)currentComponents, (km)km.a().a(kq.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Integer burnTime(Material material) {
        return (Integer)dpv.g().get(CraftMagicNumbers.getItem((Material)material));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static cyw itemArrayToRecipe(ItemStack[] items, boolean exact) {
        cyw.a[] stacks = new cyw.a[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new cyw.a(CraftItemStack.asNMSCopy((ItemStack)items[i]));
        }
        cyw itemRecipe = new cyw(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        cyn categoryValue;
        akr key = akr.a((String)"denizen", (String)keyName);
        cyw itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        cyn cyn2 = categoryValue = category == null ? cyn.c : cyn.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new czv(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new cyk(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new cym(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new czq(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        czb holder = new czb(key, (cyz)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aJ().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        akr key = akr.a((String)"denizen", (String)keyName);
        cyw itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        czw recipe = new czw(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        czb holder = new czb(key, (cyz)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aJ().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        akr key = akr.a((String)"denizen", (String)keyName);
        cyw templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        cyw baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        cyw upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        czt recipe = new czt(templateItemRecipe, baseItemRecipe, upgradeItemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        czb holder = new czb(key, (cyz)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aJ().addRecipe(holder);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        akr key = akr.a((String)"denizen", (String)keyName);
        ArrayList<cyw> ingredientList = new ArrayList<cyw>();
        cyo categoryValue = category == null ? cyo.d : cyo.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        czj recipe = new czj(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), jv.a(null, (Object[])ingredientList.toArray(new cyw[0])));
        czb holder = new czb(key, (cyz)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aJ().addRecipe(holder);
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).F().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(ItemStack itemStack) {
        uy tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).b((jo.a)CraftRegistry.getMinecraftRegistry());
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        cuq itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        cxu profile = (cxu)itemStack.a(kq.W);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(kq.W, (Object)new cxu(gameProfile));
        return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(kq.b, (Object)cxh.a, customData -> {
            CompoundTag updatedTag = CompoundTagImpl.fromNMSTag(customData.d()).createBuilder().put(key, value).build();
            return cxh.a((ub)((CompoundTagImpl)updatedTag).toNMSTag());
        });
        return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.e()) {
            return CompoundTagImpl.fromNMSTag((ub)nmsItemStack.a((jo.a)CraftRegistry.getMinecraftRegistry()));
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        cuq nmsItemStack = cuq.a((jo.a)CraftRegistry.getMinecraftRegistry(), (ub)((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
    }

    public CompoundTag getCustomData(ItemStack item) {
        cxh customData = (cxh)CraftItemStack.asNMSCopy((ItemStack)item).a(kq.b);
        return customData != null ? CompoundTagImpl.fromNMSTag(customData.d()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundTag data) {
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.c(kq.b);
        } else {
            nmsItemStack.b(kq.b, (Object)cxh.a((ub)((CompoundTagImpl)data).toNMSTag()));
        }
        return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        ub nmsOldTag = new ub();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (uy)((CompoundTagImpl)oldTag).toNMSTag());
        ub nmsUpdatedTag = (ub)MinecraftServer.getServer().L.update(bgr.t, new Dynamic((DynamicOps)up.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        ub nmsCurrentTag = (ub)CraftItemStack.asNMSCopy((ItemStack)item).a((jo.a)CraftRegistry.getMinecraftRegistry());
        ub nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((cuq)((cuq)cuq.a((jo.a)CraftRegistry.getMinecraftRegistry(), (uy)nmsMergedTag).orElseThrow()));
    }

    public CompoundTag getEntityData(ItemStack item) {
        cxh entityData = (cxh)CraftItemStack.asNMSCopy((ItemStack)item).a(kq.M);
        return entityData != null ? CompoundTagImpl.fromNMSTag(entityData.d()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundTag entityNbt, EntityType entityType) {
        ub nmsEntityNbt = EMPTY_TAG;
        if (!(entityNbt == null || entityNbt.isEmpty() || entityNbt.containsKey("id") && entityNbt.size() <= 1)) {
            nmsEntityNbt = ((CompoundTagImpl)entityNbt).toNMSTag();
            nmsEntityNbt.a("id", entityType.getKey().toString());
        }
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        cxh.a((kp)kq.M, (cuq)nmsItemStack, (ub)nmsEntityNbt);
        return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kp<csc>)kq.l);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (kp<csc>)kq.l, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kp<csc>)kq.m);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (kp<csc>)kq.m, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, kp<csc> nmsComponent) {
        List nmsPredicates;
        csc nmsAdventurePredicate = (csc)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (aw nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (jm nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((dfy)((dfy)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, kp<csc> nmsComponent, List<Material> materials) {
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        csc nmsAdventurePredicate = (csc)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.c(nmsComponent);
            return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
        }
        aw nmsPredicate = new aw(Optional.of(jq.a(material -> (jm)lt.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty());
        nmsItemStack.b(nmsComponent, (Object)new csc(List.of(nmsPredicate), nmsAdventurePredicate == null || nmsAdventurePredicate.a()));
        return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().l == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(uq.a((UUID)id).g());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return uq.a((uy)new uf(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        wz nmsDisplayName = (wz)nmsItemStack.a(kq.g);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        cxp nmsLore = (cxp)nmsItemStack.a(kq.i);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (wz nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.c(kq.g);
        } else {
            nmsItemStack.b(kq.g, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cuq)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.c(kq.i);
        } else {
            ArrayList<wz> nmsLore = new ArrayList<wz>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(kq.i, (Object)new cxp(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cuq)nmsItemStack));
    }

    public static dtc getCorrectStateForFluidBlock(dcw world, dtc blockState, jd blockPos) {
        epe fluid = blockState.u();
        return !fluid.c() && !blockState.d((dcc)world, blockPos, ji.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(eqt worldmap, int xMin, int zMin, int xMax, int zMax) {
        aqu world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                epi materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                dvi chunk = world.m(new jd(k2, 0, l2));
                if (chunk.C()) continue;
                dcd chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.D_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)dga.j.o().d((dcc)world, jd.c), 10);
                    } else {
                        multiset.add((Object)dga.b.o().d((dcc)world, jd.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    jd.a blockposition_mutableblockposition = new jd.a();
                    jd.a blockposition_mutableblockposition1 = new jd.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            dtc iblockdata;
                            int k4 = chunk.a(dyy.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.I_() + 1) {
                                iblockdata = dga.F.o();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((jd)blockposition_mutableblockposition)).d((dcc)world, (jd)blockposition_mutableblockposition) == epi.a && k4 > world.I_());
                                if (k4 > world.I_() && !iblockdata.u().c()) {
                                    dtc iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((kh)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((jd)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.I_() && !iblockdata1.u().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((dcw)world, iblockdata, (jd)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((dcc)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.d((dcc)world, (jd)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (epi)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)epi.a)) == epi.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        eqt worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(dcw.h).a(new eqr(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        cul nmsItem = lt.g.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof cso) {
            dfy block = ((cso)nmsItem).d();
            return CraftBlockData.fromData((dtc)block.o());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        cuq nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        cuq nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().bp().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(cwt.class, (String)"customMixes", (Object)MinecraftServer.getServer().bp())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((cuq)((cuq)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<cuq> nmsPredicate) {
        if (nmsPredicate instanceof cyw) {
            cyw ingredient = (cyw)nmsPredicate;
            return CraftRecipe.toBukkit((cyw)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((cpr)CraftMagicNumbers.getItem((Material)itemType).p().a(kq.v)).b();
    }

    public DyeColor getShieldColor(ItemStack item) {
        cti nmsColor = (cti)CraftItemStack.asNMSCopy((ItemStack)item).a(kq.Z);
        return nmsColor != null ? DyeColor.getByWoolData((byte)((byte)nmsColor.a())) : null;
    }

    public ItemStack setShieldColor(ItemStack item, DyeColor color) {
        cuq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (color != null) {
            nmsItemStack.b(kq.Z, (Object)cti.a((int)color.getWoolData()));
        } else {
            nmsItemStack.c(kq.Z);
        }
        return CraftItemStack.asBukkitCopy((cuq)nmsItemStack);
    }
}

