/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.LegacyNamingHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.VillagerCareerChangeEvent;

public class VillagerChangesProfessionScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public VillagerCareerChangeEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("villager changes profession");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        Villager.Profession newProfession = LegacyNamingHelper.convert(Villager.Profession.class, determinationObj.toString());
        if (newProfession != null) {
            this.event.setProfession(newProfession);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "reason": {
                return new ElementTag((Enum<?>)this.event.getReason());
            }
            case "profession": {
                return new ElementTag(String.valueOf(this.event.getProfession()), true);
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVillagerChangesProfession(VillagerCareerChangeEvent event) {
        this.event = event;
        this.entity = new EntityTag((Entity)event.getEntity());
        this.fire((Event)event);
    }
}

