/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(agb.class, agb::b, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(ahe.class, ahe::b, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(acs.class, acs::b, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(aha.class, aha::b, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(aem.c.class, aem::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(aem.b.class, aem::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends aac<acr>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, dhi level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends aac<acr>> void registerPacketHandler(Class<T> packetType, BiFunction<T, dhi, bvk> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            bvk entity = (bvk)entityGetter.apply(packet, networkManager.player.dW());
            if (entity == null) {
                return packet;
            }
            Map playerMap = (Map)DisguiseCommand.disguises.get(entity.cG());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.cG());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.ar() + " to player " + networkManager.player.cI());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e) {
                antiDuplicate = false;
                throw e;
            }
        });
    }

    public static agb processEntityDataPacket(DenizenNetworkManagerImpl networkManager, agb entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.b() == networkManager.player.ar()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (alg.c dataValue : entityDataPacket.e()) {
                if (dataValue.a() != 0) continue;
                ArrayList<alg.c<Byte>> newData = new ArrayList<alg.c<Byte>>(entityDataPacket.e());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new agb(entityDataPacket.b(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().au().c();
            return data != null ? new agb(entityDataPacket.b(), data) : null;
        }
        return entityDataPacket;
    }

    public static ahe processAttributesPacket(DenizenNetworkManagerImpl networkManager, ahe attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.b() == networkManager.player.ar() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static aha processTeleportPacket(DenizenNetworkManagerImpl networkManager, aha teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            bwt oldChange = teleportEntityPacket.e();
            return new aha(teleportEntityPacket.b(), new bwt(oldChange.a(), oldChange.b(), EntityAttachmentHelper.normalizeAngle((float)(oldChange.c() + 180.0f)), oldChange.d()), teleportEntityPacket.f(), teleportEntityPacket.g());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static aem.c processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, aem.c rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aem.c(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.compressAngle((float)(rotPacket.g() + 180.0f)), bae.g((float)rotPacket.h()), rotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static aem.b processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, aem.b posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aem.b(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.b(), posRotPacket.e(), posRotPacket.f(), EntityAttachmentHelper.compressAngle((float)(posRotPacket.g() + 180.0f)), bae.g((float)posRotPacket.h()), posRotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends aac<acr>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.cG())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends aac<acr>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

