/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_21_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dxu.a.class, euc.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dxu.a.class, Float.TYPE);
    public static final MethodHandle HOLDERSET_NAMED_BIND = ReflectionHelper.getMethodHandle(ju.c.class, (String)ReflectionMappingsInfo.HolderSetNamed_bind_method, (Class[])new Class[]{List.class});
    public static final MethodHandle HOLDER_REFERENCE_BINDTAGS = ReflectionHelper.getMethodHandle(jq.c.class, (String)ReflectionMappingsInfo.HolderReference_bindTags_method, (Class[])new Class[]{Collection.class});

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends dux> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((dux)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        dao profile = ((dwm)BlockHelperImpl.getTE((CraftSkull)skull)).i;
        if (profile == null) {
            return null;
        }
        Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
        return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, new dao(gameProfile));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        dux te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new jh(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            ux compound = te.b((js.a)CraftRegistry.getMinecraftRegistry());
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        jh blockPos = new jh(block.getX(), block.getY(), block.getZ());
        dux te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.c(((CompoundTagImpl)ctag).toNMSTag(), (js.a)CraftRegistry.getMinecraftRegistry());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        dkm block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(dxu.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        dkm block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(dxu.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public dxv getMaterialBlockState(Material bukkitMaterial) {
        dkm nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.m() : null;
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), euc.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).p;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        etx fluid;
        jh pos = CraftLocation.toBlockPosition((Location)location);
        dzq nmsChunk = ((CraftChunk)location.getChunk()).getHandle(ear.n);
        dxv nmsBlock = nmsChunk.a_(pos);
        ash nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.z()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.A);
        }
        if ((fluid = nmsBlock.y()).f()) {
            fluid.a((dhi)nmsWorld, pos, nmsWorld.A);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).E().ordinal()];
    }

    public int getExpDrop(Block block, ItemStack item) {
        dkm blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            Entity bukkitEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            bvk nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
            EntityTag entityTag = new EntityTag(bukkitEntity);
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dT();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            dwo nmsSnapshot = (dwo)craftBlockEntityState_snapshot.get(bukkitSpawner);
            dgj nmsSpawner = nmsSnapshot.c();
            dic toSpawn = nmsSpawner.f;
            ux tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            dwo nmsSnapshot = (dwo)craftBlockEntityState_snapshot.get(bukkitSpawner);
            dgj nmsSpawner = nmsSnapshot.c();
            dic toSpawn = nmsSpawner.f;
            dic.a rules = skyMin == -1 ? null : new dic.a(new azw((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new azw((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new dic(toSpawn.d(), Optional.ofNullable(rules), toSpawn.f());
            nmsSpawner.e = brr.b();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }
}

