/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(dik.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, dik.d.class, Float.TYPE});
    public jq<dik> biomeHolder;
    public ash world;

    public BiomeNMSImpl(ash world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = world.K_().e(mb.aI).a(aly.a((aly)mb.aI, (alz)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        dik.c precipitation = ((dik)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location), this.world.O());
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case dik.c.b -> BiomeNMS.DownfallType.RAIN;
            case dik.c.c -> BiomeNMS.DownfallType.SNOW;
            case dik.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((dik)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((dik)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((dik)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location), this.world.O());
    }

    public boolean hasDownfall() {
        return ((dik)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(bwj.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(bwj.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(bwj.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(bwj.f);
    }

    public int getFoliageColor() {
        if (((dik)this.biomeHolder.a()).f() != 0) {
            return ((dik)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, dik.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(dik.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(diq.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((dik)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((dik)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(diq.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((dik)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((dik)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(diq.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((dik)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(bwj creatureType) {
        diw mobs = ((dik)this.biomeHolder.a()).b();
        brv typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (diw.c meta : typeSettingList.e()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((bvr)meta.b));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        eaa chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        jh pos = new jh(block.getX(), 0, block.getZ());
        if (this.world.B(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.i();
        }
    }

    public dik.d getTemperatureModifier() {
        return ((dik)this.biomeHolder.a()).i.c();
    }
}

