/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityEvent;

public class EntityExitsVehicleScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag vehicle;
    public EntityTag entity;

    public EntityExitsVehicleScriptEvent() {
        this.registerCouldMatcher("<entity> exits <entity>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        String vehicleLabel = path.eventArgLowerAt(2);
        if (!vehicleLabel.equals("vehicle") && !this.vehicle.tryAdvancedMatcher(vehicleLabel, path.context)) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle.getDenizenObject();
        }
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        return super.getContext(name);
    }

    @Override
    public String getName() {
        return "EntityExitsVehicle";
    }

    public void fire(EntityEvent event, Entity vehicle) {
        this.entity = new EntityTag(event.getEntity());
        this.vehicle = new EntityTag(vehicle);
        this.fire((Event)event);
    }
}

