/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.LegacyParticleNaming;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayEffectCommand
extends AbstractCommand {
    public static final List<Particle> VISIBLE_PARTICLES = new ArrayList<Particle>(Arrays.asList(Particle.values()));

    public PlayEffectCommand() {
        this.setName("playeffect");
        this.setSyntax("playeffect [effect:<name>] [at:<location>|...] (data:<#.#>) (special_data:<data>) (visibility:<#.#>) (quantity:<#>) (offset:<#.#>,<#.#>,<#.#>) (targets:<player>|...) (velocity:<vector>)");
        this.setRequiredArguments(2, 8);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("effect:", (Enum<?>[])Particle.values());
        tab.addWithPrefix("effect:", (Enum<?>[])Effect.values());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentList(LocationTag.class) && (arg.matchesPrefix("at") || !arg.hasPrefix())) {
                if (arg.matchesPrefix("at")) {
                    scriptEntry.addObject("no_offset", new ElementTag(true));
                }
                scriptEntry.addObject("location", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
                String particleName = CoreUtilities.toUpperCase(arg.getValue());
                Particle particle = Utilities.elementToEnumlike(new ElementTag(particleName), Particle.class);
                if (particle != null) {
                    scriptEntry.addObject("particleeffect", particle);
                    continue;
                }
                particle = LegacyParticleNaming.legacyParticleNames.get(particleName);
                if (particle != null) {
                    BukkitImplDeprecations.oldSpigotNames.warn(scriptEntry);
                    scriptEntry.addObject("particleeffect", particle);
                    continue;
                }
                if (arg.matches("barrier") && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                    scriptEntry.addObject("particleeffect", Particle.BLOCK_MARKER);
                    scriptEntry.addObject("special_data", new ElementTag("barrier"));
                    continue;
                }
                if (arg.matches("random")) {
                    scriptEntry.addObject("particleeffect", VISIBLE_PARTICLES.get(CoreUtilities.getRandom().nextInt(VISIBLE_PARTICLES.size())));
                    continue;
                }
                if (arg.startsWith("iconcrack_")) {
                    BukkitImplDeprecations.oldPlayEffectSpecials.warn(scriptEntry);
                    String shrunk = arg.getValue().substring("iconcrack_".length());
                    ItemTag item = ItemTag.valueOf(shrunk, scriptEntry.context);
                    if (item != null) {
                        scriptEntry.addObject("iconcrack", item);
                        continue;
                    }
                    Debug.echoError("Invalid iconcrack_[item]. Must be a valid ItemTag!");
                    continue;
                }
                if (arg.matchesEnum(Effect.class)) {
                    scriptEntry.addObject("effect", Effect.valueOf((String)arg.getValue().toUpperCase()));
                    continue;
                }
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesFloat() && arg.matchesPrefix("visibility", "v", "radius", "r")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesFloat() && arg.matchesPrefix("data", "d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("special_data") && arg.matchesPrefix("special_data")) {
                scriptEntry.addObject("special_data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesInteger() && arg.matchesPrefix("qty", "q", "quantity")) {
                if (arg.matchesPrefix("q", "qty")) {
                    BukkitImplDeprecations.qtyTags.warn(scriptEntry);
                }
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesFloat() && arg.matchesPrefix("offset", "o")) {
                double offset = arg.asElement().asDouble();
                scriptEntry.addObject("offset", new LocationTag(null, offset, offset, offset));
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("offset", "o")) {
                scriptEntry.addObject("offset", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("velocity") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("velocity")) {
                scriptEntry.addObject("velocity", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(PlayerTag.class) && arg.matchesPrefix("targets", "target", "t")) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("data", new ElementTag(0));
        scriptEntry.defaultObject("radius", new ElementTag(15));
        scriptEntry.defaultObject("quantity", new ElementTag(1));
        scriptEntry.defaultObject("offset", new LocationTag(null, 0.5, 0.5, 0.5));
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
            throw new InvalidArgumentsException("Missing effect argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void execute(ScriptEntry scriptEntry) {
        locations = (List)scriptEntry.getObject("location");
        targets = (List)scriptEntry.getObject("targets");
        effect = (Effect)scriptEntry.getObject("effect");
        particleEffect = (Particle)scriptEntry.getObject("particleeffect");
        iconcrack = (ItemTag)scriptEntry.getObjectTag("iconcrack");
        radius = scriptEntry.getElement("radius");
        data = scriptEntry.getElement("data");
        quantity = scriptEntry.getElement("quantity");
        no_offset = scriptEntry.getElement("no_offset");
        should_offset = no_offset == null || no_offset.asBoolean() == false;
        offset = (LocationTag)scriptEntry.getObjectTag("offset");
        special_data = scriptEntry.getElement("special_data");
        velocity = (LocationTag)scriptEntry.getObjectTag("velocity");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), new Object[]{effect != null ? PlayEffectCommand.db("effect", effect.name()) : (particleEffect != null ? PlayEffectCommand.db("special effect", particleEffect.name()) : iconcrack), PlayEffectCommand.db("locations", locations), PlayEffectCommand.db("targets", targets), radius, data, quantity, offset, special_data, velocity, should_offset != false ? PlayEffectCommand.db("note", "Location will be offset 1 block-height upward (see documentation)") : ""});
        }
        for (LocationTag location : locations) {
            block34: {
                if (should_offset) {
                    location = new LocationTag(location.clone().add(0.0, 1.0, 0.0));
                }
                if (effect != null) {
                    for (n = 0; n < quantity.asInt(); ++n) {
                        if (targets != null) {
                            for (Object player : targets) {
                                if (!player.isValid() || !player.isOnline()) continue;
                                player.getPlayerEntity().playEffect((Location)location, effect, data.asInt());
                            }
                            continue;
                        }
                        location.getWorld().playEffect((Location)location, effect, data.asInt(), radius.asInt());
                    }
                    continue;
                }
                if (particleEffect == null) break block34;
                players = new ArrayList<Player>();
                if (targets == null) {
                    rad = radius.asFloat();
                    player = location.getWorld().getPlayers().iterator();
                    while (player.hasNext()) {
                        player = (Player)player.next();
                        if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                        players.add(player);
                    }
                } else {
                    for (Object player : targets) {
                        if (!player.isValid() || !player.isOnline()) continue;
                        players.add(player.getPlayerEntity());
                    }
                }
                clazz = particleEffect.getDataType() == Void.class ? null : particleEffect.getDataType();
                dataObject = null;
                if (clazz == null) ** GOTO lbl93
                if (special_data == null) {
                    Debug.echoError("Missing required special data for particle: " + particleEffect.name());
                    return;
                }
                if (clazz == Particle.DustOptions.class) {
                    dataList = ListTag.valueOf(special_data.asString(), scriptEntry.getContext());
                    if (dataList.size() != 2) {
                        Debug.echoError("DustOptions special_data must have 2 list entries for particle: " + particleEffect.name());
                        return;
                    }
                    size = Float.parseFloat(dataList.get(0));
                    color = ColorTag.valueOf(dataList.get(1), scriptEntry.context);
                    dataObject = new Particle.DustOptions(BukkitColorExtensions.getColor(color), size);
                } else if (clazz == BlockData.class) {
                    blockMaterial = MaterialTag.valueOf(special_data.asString(), scriptEntry.getContext());
                    dataObject = blockMaterial.getModernData();
                } else if (clazz == ItemStack.class) {
                    itemType = ItemTag.valueOf(special_data.asString(), scriptEntry.getContext());
                    dataObject = itemType.getItemStack();
                } else if (clazz == Particle.DustTransition.class) {
                    dataList = ListTag.valueOf(special_data.asString(), scriptEntry.getContext());
                    if (dataList.size() != 3) {
                        Debug.echoError("DustTransition special_data must have 3 list entries for particle: " + particleEffect.name());
                        return;
                    }
                    size = Float.parseFloat(dataList.get(0));
                    fromColor = ColorTag.valueOf(dataList.get(1), scriptEntry.context);
                    toColor = ColorTag.valueOf(dataList.get(2), scriptEntry.context);
                    dataObject = new Particle.DustTransition(BukkitColorExtensions.getColor(fromColor), BukkitColorExtensions.getColor(toColor), size);
                } else if (clazz == Vibration.class) {
                    dataList = ListTag.valueOf(special_data.asString(), scriptEntry.getContext());
                    if (dataList.size() != 3) {
                        Debug.echoError("Vibration special_data must have 3 list entries for particle: " + particleEffect.name());
                        return;
                    }
                    duration = dataList.getObject(0).asType(DurationTag.class, scriptEntry.context);
                    origin = dataList.getObject(1).asType(LocationTag.class, scriptEntry.context);
                    destination = dataList.getObject(2);
                    destObj /* !! */  = destination.shouldBeType(EntityTag.class) != false ? new Vibration.Destination.EntityDestination(destination.asType(EntityTag.class, scriptEntry.context).getBukkitEntity()) : new Vibration.Destination.BlockDestination((Location)destination.asType(LocationTag.class, scriptEntry.context));
                    dataObject = new Vibration((Location)origin, (Vibration.Destination)destObj /* !! */ , duration.getTicksAsInt());
                } else {
                    Debug.echoError("Unknown particle data type: " + clazz.getCanonicalName() + " for particle: " + particleEffect.name());
                    return;
lbl93:
                    // 1 sources

                    if (special_data != null) {
                        Debug.echoError("Particles of type '" + particleEffect.name() + "' cannot take special_data as input.");
                        return;
                    }
                }
                random = CoreUtilities.getRandom();
                quantityInt = quantity.asInt();
                for (Player player : players) {
                    if (velocity == null) {
                        player.spawnParticle(particleEffect, (Location)location, quantityInt, offset.getX(), offset.getY(), offset.getZ(), data.asDouble(), (Object)dataObject);
                        continue;
                    }
                    for (i = 0; i < quantityInt; ++i) {
                        singleLocation = location.clone().add((random.nextDouble() - 0.5) * offset.getX(), (random.nextDouble() - 0.5) * offset.getY(), (random.nextDouble() - 0.5) * offset.getZ());
                        player.spawnParticle(particleEffect, (Location)singleLocation, 0, velocity.getX(), velocity.getY(), velocity.getZ(), 1.0, (Object)dataObject);
                    }
                }
                continue;
            }
            players = new ArrayList<Player>();
            if (targets == null) {
                rad = radius.asFloat();
                for (Player player : location.getWorld().getPlayers()) {
                    if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                    players.add(player);
                }
            } else {
                for (Object player : targets) {
                    if (!player.isValid() || !player.isOnline()) continue;
                    players.add(player.getPlayerEntity());
                }
            }
            if (iconcrack == null) continue;
            itemStack = iconcrack.getItemStack();
            particle = Particle.valueOf((String)"ITEM_CRACK");
            for (Player player : players) {
                player.spawnParticle(particle, (Location)location, quantity.asInt(), offset.getX(), offset.getY(), offset.getZ(), (double)data.asFloat(), (Object)itemStack);
            }
        }
    }

    static {
        VISIBLE_PARTICLES.removeAll(List.of(Particle.valueOf((String)"SUSPENDED"), Particle.valueOf((String)"SUSPENDED_DEPTH"), Particle.valueOf((String)"WATER_BUBBLE")));
    }
}

