/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.events.bukkit.ExhaustedNPCEvent;
import com.denizenscript.denizen.objects.NPCTag;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class HungerTrait
extends Trait
implements Listener {
    @Persist(value="maxhunger")
    private double maxhunger = 20.0;
    @Persist(value="currenthunger")
    private double currenthunger = 0.0;
    @Persist(value="multiplier")
    private int multiplier = 1;
    @Persist(value="allowexhaustion")
    private boolean allowexhaustion = false;
    private boolean listening = false;
    private Location location = null;
    private int count = 0;

    public void run() {
        if (!this.listening) {
            return;
        }
        ++this.count;
        if (this.count >= 20) {
            this.count = 0;
            double td = this.getDistance(this.npc.getStoredLocation());
            if (td > 0.0) {
                this.location = this.npc.getStoredLocation().clone();
                this.currenthunger -= td * 0.01 * (double)this.multiplier;
            }
        }
    }

    @EventHandler
    public void onMove(NavigationBeginEvent event) {
        if (this.allowexhaustion && this.isStarving()) {
            ExhaustedNPCEvent e = new ExhaustedNPCEvent(this.npc);
            Bukkit.getServer().getPluginManager().callEvent((Event)e);
            if (!e.isCancelled()) {
                this.npc.getNavigator().cancelNavigation();
                new NPCTag(this.npc).action("exhausted", null);
                return;
            }
        }
        this.location = this.npc.getStoredLocation().clone();
        this.listening = true;
    }

    @EventHandler
    public void onCancel(NavigationCancelEvent event) {
        this.listening = false;
    }

    @EventHandler
    public void onCancel(NavigationCompleteEvent event) {
        this.listening = false;
    }

    public HungerTrait() {
        super("hunger");
    }

    public double getHunger() {
        return this.currenthunger;
    }

    public double getMaxHunger() {
        return this.maxhunger;
    }

    public int getHungerPercentage() {
        return (int)((double)((int)this.currenthunger) / this.maxhunger);
    }

    public int getHungerMultiplier() {
        return this.multiplier;
    }

    public void setHungerMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public void setHunger(double hunger) {
        this.currenthunger = this.currenthunger > this.maxhunger ? this.maxhunger : hunger;
    }

    public void feed(double hunger) {
        this.currenthunger -= hunger;
        if (this.currenthunger < 0.0) {
            this.currenthunger = 0.0;
        }
    }

    public void setMaxhunger(double hunger) {
        this.maxhunger = hunger;
    }

    public boolean isStarving() {
        return this.currenthunger >= this.maxhunger;
    }

    public boolean isHungry() {
        return this.currenthunger > this.maxhunger / 10.0;
    }

    private double getDistance(Location location) {
        if (!this.npc.getEntity().getWorld().equals((Object)location.getWorld())) {
            this.location = this.npc.getStoredLocation();
            return 0.0;
        }
        return location.distance(this.location);
    }
}

