/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.entity.EntityEntersVehicleScriptEvent;
import com.denizenscript.denizen.events.entity.EntityExitsVehicleScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_17_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(atg.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final wf<Boolean> ENTITY_ENDERMAN_DATAWATCHER_SCREAMING = (wf)ReflectionHelper.getFieldValue(bho.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final MethodHandle FALLINGBLOCK_TYPE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(bhc.class, ckt.class);
    public static final Field ZOMBIE_INWATERTIME = ReflectionHelper.getFields(bir.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
    public static final MethodHandle TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(abe.b.class, Integer.TYPE);

    public int getBlockHeight(Art art) {
        return art.getBlockHeight();
    }

    public int getBlockWidth(Art art) {
        return art.getBlockWidth();
    }

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().j(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().bP();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(aug.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        atz monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().ek() : atz.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)bum.a((bqq)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (atz)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            asq source = attacker instanceof Player ? asq.a((bke)((CraftPlayer)attacker).getHandle()) : asq.c((atu)((CraftLivingEntity)attacker).getHandle());
            atg nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.b(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof atu)) {
                return damage;
            }
            atu livingTarget = (atu)nmsTarget;
            damage = aso.a((float)((float)damage), (float)livingTarget.ec(), (float)((float)livingTarget.b(auv.j)));
            int enchantDamageModifier = bum.a((Iterable)livingTarget.bx(), (asq)source);
            if (enchantDamageModifier > 0) {
                damage = aso.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        ((CraftLivingEntity)entity).getHandle().s(state ? 0 : 1);
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        gg pos = new gg(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().a((bwq)((CraftWorld)location.getWorld()).getHandle(), (bke)(craftPlayer != null ? craftPlayer.getHandle() : null), asa.a, new dmw(new dna(0.0, 0.0, 0.0), null, pos, false));
    }

    public CompoundTag getNbtData(Entity entity) {
        na compound = new na();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        atg nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof atw)) {
            return;
        }
        ((atw)nmsEntity).F().o();
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        atg nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof atw)) {
            return;
        }
        final atw nmsFollower = (atw)nmsEntityFollower;
        final bca followerNavigation = nmsFollower.F();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        dha path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    dha path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.o();
                }
                nmsFollower.a(auv.d).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        dha path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        atg nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof atw)) {
            return;
        }
        final atw nmsEntity = (atw)nmsEntityEntity;
        final bca entityNavigation = nmsEntity.F();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsEntity, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsEntity.bP.b(azp.a.a);
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.a(auv.d).b();
            if (speed != null) {
                nmsEntity.a(auv.d).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        ((Wolf)entity).setAngry(false);
                    }
                    if (entityNavigation.m() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsEntity.a(auv.d).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public List<Player> getPlayersThatSee(Entity entity) {
        abe tracker = ((abr)((CraftEntity)entity).getHandle().t).getChunkProvider().a;
        abe.b entityTracker = (abe.b)tracker.G.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (acm player : entityTracker.f) {
            output.add((Player)player.d().getBukkitEntity());
        }
        return output;
    }

    public void sendHidePacket(Player pl2, Entity entity) {
        if (entity instanceof Player) {
            pl2.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl2;
        abs entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            abe tracker = ((abr)craftPlayer.getHandle().t).getChunkProvider().a;
            atg other = ((CraftEntity)entity).getHandle();
            abe.b entry = (abe.b)tracker.G.get(other.Z());
            if (entry != null) {
                entry.a(entityPlayer);
            }
            if (Denizen.supportsPaper) {
                entityPlayer.b.a((pk)new rs(new int[]{other.Z()}));
            }
        }
    }

    public void sendShowPacket(Player pl2, Entity entity) {
        if (entity instanceof Player) {
            pl2.showPlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl2;
        abs entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            abe tracker = ((abr)craftPlayer.getHandle().t).getChunkProvider().a;
            atg other = ((CraftEntity)entity).getHandle();
            abe.b entry = (abe.b)tracker.G.get(other.Z());
            if (entry != null) {
                entry.a(entityPlayer);
                entry.b(entityPlayer);
            }
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            this.teleport(entity, location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            atg handle = ((CraftEntity)entity).getHandle();
            handle.o(yaw - 360.0f);
            handle.p(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aX;
    }

    public void look(Entity entity, float yaw, float pitch) {
        atg handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.o(yaw);
            if (handle instanceof atu) {
                atu livingHandle = (atu)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aY = yaw;
                if (!(handle instanceof bke)) {
                    livingHandle.m(yaw);
                }
                livingHandle.l(yaw);
            }
            handle.p(pitch);
        } else {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + String.valueOf(entity.getUniqueId())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static dmy rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            dmw dmw2 = ((CraftWorld)world).getHandle().a(new bvy(new dna(start.getX(), start.getY(), start.getZ()), new dna(end.getX(), end.getY(), end.getZ()), bvy.a.b, bvy.b.a, null));
            return dmw2;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        dmy pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == dmy.a.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().o(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(aua.a, new dna(vector.getX(), vector.getY(), vector.getZ()));
    }

    public void teleport(Entity entity, Location loc) {
        atg nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.o(loc.getYaw());
        nmsEntity.p(loc.getPitch());
        if (nmsEntity instanceof abs) {
            nmsEntity.b(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.e(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new dmv(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().R = ticks;
        if (entity instanceof CraftFallingBlock) {
            ((CraftFallingBlock)entity).getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            ((bhd)((CraftItem)entity).getHandle()).ao = ticks;
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        atu handle = ((CraftLivingEntity)entity).getHandle();
        handle.aZ = angle;
        handle.l(angle);
    }

    public void setGhastAttacking(Ghast ghast, boolean attacking) {
        ((CraftGhast)ghast).getHandle().v(attacking);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().ad().b(ENTITY_ENDERMAN_DATAWATCHER_SCREAMING, (Object)angry);
    }

    public static asq getSourceFor(atg nmsSource, EntityDamageEvent.DamageCause cause) {
        asq src = asq.n;
        if (nmsSource != null) {
            if (nmsSource instanceof bke) {
                src = asq.a((bke)((bke)nmsSource));
            } else if (nmsSource instanceof atu) {
                src = asq.c((atu)((atu)nmsSource));
            }
        }
        if (cause == null) {
            return src;
        }
        switch (cause) {
            case CONTACT: {
                return asq.j;
            }
            case ENTITY_ATTACK: {
                return asq.c((atu)(nmsSource instanceof atu ? (atu)nmsSource : null));
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src != asq.n) {
                    src.sweep();
                }
                return src;
            }
            case PROJECTILE: {
                return asq.b((atg)nmsSource, nmsSource != null && nmsSource.getBukkitEntity() instanceof Projectile && ((Projectile)nmsSource.getBukkitEntity()).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)nmsSource.getBukkitEntity()).getShooter()).getHandle() : null);
            }
            case SUFFOCATION: {
                return asq.f;
            }
            case FALL: {
                return asq.k;
            }
            case FIRE: {
                return asq.a;
            }
            case FIRE_TICK: {
                return asq.c;
            }
            case MELTING: {
                return CraftEventFactory.MELTING;
            }
            case LAVA: {
                return asq.d;
            }
            case DROWNING: {
                return asq.h;
            }
            case BLOCK_EXPLOSION: {
                return asq.d(nmsSource instanceof TNTPrimed && ((TNTPrimed)nmsSource).getSource() instanceof atu ? (atu)((TNTPrimed)nmsSource).getSource() : null);
            }
            case ENTITY_EXPLOSION: {
                return asq.d((atu)(nmsSource instanceof atu ? (atu)nmsSource : null));
            }
            case VOID: {
                return asq.m;
            }
            case LIGHTNING: {
                return asq.b;
            }
            case STARVATION: {
                return asq.i;
            }
            case POISON: {
                return CraftEventFactory.POISON;
            }
            case MAGIC: {
                return asq.o;
            }
            case WITHER: {
                return asq.p;
            }
            case FALLING_BLOCK: {
                return asq.r;
            }
            case THORNS: {
                return asq.a((atg)nmsSource);
            }
            case DRAGON_BREATH: {
                return asq.s;
            }
            case CUSTOM: {
                return asq.n;
            }
            case FLY_INTO_WALL: {
                return asq.l;
            }
            case HOT_FLOOR: {
                return asq.e;
            }
            case CRAMMING: {
                return asq.g;
            }
            case DRYOUT: {
                return asq.t;
            }
        }
        return new FakeDamageSrc(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        atg nmsSource;
        if (target == null) {
            return;
        }
        atu nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        CraftEventFactory.blockDamage = sourceLoc == null ? null : sourceLoc.getBlock();
        try {
            asq src = EntityHelperImpl.getSourceFor(nmsSource, cause);
            if (src instanceof FakeDamageSrc) {
                src = ((FakeDamageSrc)src).real;
                EntityDamageEvent ede = EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount);
                if (ede.isCancelled()) {
                    return;
                }
            }
            nmsTarget.a(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
            CraftEventFactory.blockDamage = null;
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        ckt state = ((CraftBlockData)block).getState();
        bhc nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_TYPE_SETTER.invoke(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        cjt nmsSpawner = (cjt)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        atg nmsEntity = nmsSpawner.d().a((bwq)((CraftWorld)spawner.getWorld()).getHandle());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public void setFireworkLifetime(Firework firework, int ticks) {
        ((CraftFirework)firework).getHandle().f = ticks;
    }

    public int getFireworkLifetime(Firework firework) {
        return ((CraftFirework)firework).getHandle().f;
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            abe map = ((CraftWorld)entity.getWorld()).getHandle().getChunkProvider().a;
            abe.b entry = (abe.b)map.G.get(entity.getEntityId());
            TRACKING_RANGE_SETTER.invoke(entry, range);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().fr();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().u(aggressive);
    }

    public void openHorseInventory(Player player, AbstractHorse horse) {
        bfj nmsHorse = ((CraftAbstractHorse)horse).getHandle();
        ((CraftPlayer)player).getHandle().a(nmsHorse, (aru)nmsHorse.ce);
    }

    public Class<? extends EntityEntersVehicleScriptEvent> getEntersVehicleEventImpl() {
        return EntityEntersVehicleScriptEventImpl.class;
    }

    public Class<? extends EntityExitsVehicleScriptEvent> getExitsVehicleEventImpl() {
        return EntityExitsVehicleScriptEventImpl.class;
    }

    public static class FakeDamageSrc
    extends asq {
        public asq real;

        public FakeDamageSrc(asq src) {
            super("fake");
            this.real = src;
        }
    }

    public static class EntityEntersVehicleScriptEventImpl
    extends EntityEntersVehicleScriptEvent {
        @EventHandler
        public void onEntityMount(EntityMountEvent event) {
            this.fire((EntityEvent)event, event.getMount());
        }
    }

    public static class EntityExitsVehicleScriptEventImpl
    extends EntityExitsVehicleScriptEvent {
        @EventHandler
        public void onEntityMount(EntityDismountEvent event) {
            this.fire((EntityEvent)event, event.getDismounted());
        }
    }
}

