/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftTransmuteRecipe;
import org.bukkit.craftbukkit.v1_21_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(cwm.class).get(ReflectionMappingsInfo.Item_components, kr.class);
    public static final Field RecipeManager_featureFlagSet = ReflectionHelper.getFields(dbm.class).getFirstOfType(cru.class);
    public Object recipeManagerFeatureFlagSetCache = null;
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final tq EMPTY_TAG = new tq();
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(cum.class).get((Object)ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static dbk<?> getNMSRecipe(NamespacedKey key) {
        aku nmsKey = aku.a((aku)mc.bk, (akv)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aI().b(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            cwm nmsItem = (cwm)mb.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            kr currentComponents = nmsItem.g();
            Item_components.set(nmsItem, kr.a((kr)currentComponents, (kr)kr.a().a(kv.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static dbm getRecipeManager() {
        return ((CraftServer)Bukkit.getServer()).getServer().aI();
    }

    public void blockRecipeFinalization() {
        try {
            dbm manager = ItemHelperImpl.getRecipeManager();
            Object flags = RecipeManager_featureFlagSet.get(manager);
            if (flags != null) {
                this.recipeManagerFeatureFlagSetCache = flags;
                RecipeManager_featureFlagSet.set(manager, null);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void restoreRecipeFinalization() {
        try {
            dbm manager = ItemHelperImpl.getRecipeManager();
            if (this.recipeManagerFeatureFlagSetCache != null) {
                RecipeManager_featureFlagSet.set(manager, this.recipeManagerFeatureFlagSetCache);
                manager.finalizeRecipeLoading();
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void removeRecipes(List<NamespacedKey> keys) {
        this.blockRecipeFinalization();
        dbm manager = ItemHelperImpl.getRecipeManager();
        for (NamespacedKey key : keys) {
            aku nmsKey = aku.a((aku)mc.bk, (akv)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
            manager.removeRecipe(nmsKey);
        }
        this.restoreRecipeFinalization();
    }

    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bo().b(new cwq((dgi)CraftMagicNumbers.getItem((Material)material)));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static dbb itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return dbb.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return dbb.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static aku<dbf<?>> createRecipeKey(String name) {
        return aku.a((aku)mc.bk, (akv)akv.a((String)"denizen", (String)name));
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        dar categoryValue;
        aku<dbf<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dbb itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dar dar2 = categoryValue = category == null ? dar.c : dar.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new dce(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new dao(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new daq(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new dbz(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        dbk holder = new dbk(key, (dbf)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        aku<dbf<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dbb itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dcf recipe = new dcf(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        dbk holder = new dbk(key, (dbf)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        aku<dbf<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dbb templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        dbb baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        dbb upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        dcc recipe = new dcc(Optional.of(templateItemRecipe), Optional.of(baseItemRecipe), Optional.of(upgradeItemRecipe), CraftItemStack.asNMSCopy((ItemStack)result));
        dbk holder = new dbk(key, (dbf)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        aku<dbf<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<dbb> ingredientList = new ArrayList<dbb>();
        das categoryValue = category == null ? das.d : das.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        dbv recipe = new dbv(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)ka.a(null, (Object[])ingredientList.toArray(new dbb[0])));
        dbk holder = new dbk(key, (dbf)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerOtherRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            CraftRecipe craft;
            toAdd = craft = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)((ShapedRecipe)recipe));
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)((ShapelessRecipe)recipe));
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)((FurnaceRecipe)recipe));
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)((BlastingRecipe)recipe));
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)((CampfireRecipe)recipe));
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)((SmokingRecipe)recipe));
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)((StonecuttingRecipe)recipe));
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)((SmithingTransformRecipe)recipe));
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)((SmithingTrimRecipe)recipe));
        } else {
            if (!(recipe instanceof TransmuteRecipe)) {
                if (recipe instanceof ComplexRecipe) {
                    throw new UnsupportedOperationException("Cannot add custom complex recipe");
                }
                return;
            }
            toAdd = CraftTransmuteRecipe.fromBukkitRecipe((TransmuteRecipe)((TransmuteRecipe)recipe));
        }
        toAdd.addToCraftingManager();
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).K().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(ItemStack itemStack) {
        un tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).b((jt.a)CraftRegistry.getMinecraftRegistry());
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        cwq itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        czp profile = (czp)itemStack.a(kv.ag);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(kv.ag, (Object)new czp(gameProfile));
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(kv.b, (Object)cyz.a, customData -> {
            CompoundTag updatedTag = CompoundTagImpl.fromNMSTag(customData.e()).createBuilder().put(key, value).build();
            return cyz.a((tq)((CompoundTagImpl)updatedTag).toNMSTag());
        });
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return CompoundTagImpl.fromNMSTag((tq)nmsItemStack.a((jt.a)CraftRegistry.getMinecraftRegistry()));
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        cwq nmsItemStack = cwq.a((jt.a)CraftRegistry.getMinecraftRegistry(), (tq)((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }

    public CompoundTag getCustomData(ItemStack item) {
        cyz customData = (cyz)CraftItemStack.asNMSCopy((ItemStack)item).a(kv.b);
        return customData != null ? CompoundTagImpl.fromNMSTag(customData.e()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundTag data) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.d(kv.b);
        } else {
            nmsItemStack.b(kv.b, (Object)cyz.a((tq)((CompoundTagImpl)data).toNMSTag()));
        }
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        tq nmsOldTag = new tq();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (un)((CompoundTagImpl)oldTag).toNMSTag());
        tq nmsUpdatedTag = (tq)MinecraftServer.getServer().L.update(bhy.t, new Dynamic((DynamicOps)ue.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        tq nmsCurrentTag = (tq)CraftItemStack.asNMSCopy((ItemStack)item).a((jt.a)CraftRegistry.getMinecraftRegistry());
        tq nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((cwq)((cwq)cwq.a((jt.a)CraftRegistry.getMinecraftRegistry(), (un)nmsMergedTag).orElseThrow()));
    }

    public CompoundTag getEntityData(ItemStack item) {
        cyz entityData = (cyz)CraftItemStack.asNMSCopy((ItemStack)item).a(kv.W);
        return entityData != null ? CompoundTagImpl.fromNMSTag(entityData.e()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundTag entityNbt, EntityType entityType) {
        tq nmsEntityNbt = EMPTY_TAG;
        if (!(entityNbt == null || entityNbt.isEmpty() || entityNbt.containsKey("id") && entityNbt.size() <= 1)) {
            nmsEntityNbt = ((CompoundTagImpl)entityNbt).toNMSTag();
            nmsEntityNbt.a("id", entityType.getKey().toString());
        }
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        cyz.a((ku)kv.W, (cwq)nmsItemStack, (tq)nmsEntityNbt);
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }

    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        ks patch = nmsItemStack.d();
        if (excludeHandled) {
            patch = patch.a(componentType -> {
                akv componentId = mb.ao.b(componentType);
                return ItemComponentsPatch.propertyHandledComponents.contains(componentId.toString());
            });
        }
        if (patch.d()) {
            return new MapTag();
        }
        akt registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)ue.a);
        tq nmsPatch = (tq)ks.b.encodeStart((DynamicOps)registryOps, (Object)patch).getOrThrow();
        MapTag rawComponents = (MapTag)ItemRawNBT.jnbtTagToObject((Tag)CompoundTagImpl.fromNMSTag(nmsPatch));
        rawComponents.putObject("denizen:__data_version", (ObjectTag)new ElementTag(CraftMagicNumbers.INSTANCE.getDataVersion()));
        return rawComponents;
    }

    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        Tag rawComponents = ItemRawNBT.convertObjectToNbt((String)rawComponentsMap.identify(), (TagContext)CoreUtilities.errorButNoDebugContext, (String)"");
        tq nmsRawComponents = ((CompoundTagImpl)rawComponents).toNMSTag();
        akt registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)ue.a);
        if (dataVersion < currentDataVersion) {
            tq legacyItemData = new tq();
            legacyItemData.a("id", item.getType().getKey().toString());
            legacyItemData.a("count", item.getAmount());
            legacyItemData.a("components", (un)nmsRawComponents);
            tq nmsUpdatedTag = (tq)MinecraftServer.getServer().L.update(bhy.t, new Dynamic((DynamicOps)registryOps, (Object)legacyItemData), dataVersion, currentDataVersion).getValue();
            nmsRawComponents = nmsUpdatedTag.p("components");
        }
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        ks.b.parse((DynamicOps)registryOps, (Object)nmsRawComponents).ifError(error -> errorHandler.accept(error.message())).ifSuccess(arg_0 -> ((cwq)nmsItemStack).b(arg_0));
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (ku<cum>)kv.m);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (ku<cum>)kv.m, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (ku<cum>)kv.n);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (ku<cum>)kv.n, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, ku<cum> nmsComponent) {
        List nmsPredicates;
        cum nmsAdventurePredicate = (cum)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (ay nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (jr nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((djn)((djn)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, ku<cum> nmsComponent, List<Material> materials) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        cum nmsAdventurePredicate = (cum)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.d(nmsComponent);
            return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
        }
        ay nmsPredicate = new ay(Optional.of(jv.a(material -> (jr)mb.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty());
        nmsItemStack.b(nmsComponent, (Object)new cum(List.of(nmsPredicate), nmsAdventurePredicate == null || nmsAdventurePredicate.a()));
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().k == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(uf.a((UUID)id).g());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return uf.a((un)new tu(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        wp nmsDisplayName = (wp)nmsItemStack.a(kv.g);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        czj nmsLore = (czj)nmsItemStack.a(kv.j);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (wp nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.d(kv.g);
        } else {
            nmsItemStack.b(kv.g, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cwq)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.d(kv.j);
        } else {
            ArrayList<wp> nmsLore = new ArrayList<wp>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(kv.j, (Object)new czj(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cwq)nmsItemStack));
    }

    public static dwy getCorrectStateForFluidBlock(dgj world, dwy blockState, ji blockPos) {
        eta fluid = blockState.y();
        return !fluid.c() && !blockState.c((dfo)world, blockPos, jn.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(euu worldmap, int xMin, int zMin, int xMax, int zMax) {
        ard world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                ete materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                dzd chunk = world.m(new ji(k2, 0, l2));
                if (chunk.E()) continue;
                dfp chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.G_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)djp.j.m().a((dfo)world, ji.c), 10);
                    } else {
                        multiset.add((Object)djp.b.m().a((dfo)world, ji.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    ji.a blockposition_mutableblockposition = new ji.a();
                    ji.a blockposition_mutableblockposition1 = new ji.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            dwy iblockdata;
                            int k4 = chunk.a(ect.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.L_() + 1) {
                                iblockdata = djp.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((ji)blockposition_mutableblockposition)).a((dfo)world, (ji)blockposition_mutableblockposition) == ete.a && k4 > world.L_());
                                if (k4 > world.L_() && !iblockdata.y().c()) {
                                    dwy iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((km)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((ji)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.L_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((dgj)world, iblockdata, (ji)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((dfo)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((dfo)world, (ji)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (ete)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)ete.a)) == ete.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        euu worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(dgj.i).a(new eus(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        cwm nmsItem = mb.g.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof cuw) {
            djn block = ((cuw)nmsItem).d();
            return CraftBlockData.fromData((dwy)block.m());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        cwq nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        cwq nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().bn().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(cyo.class, (String)"customMixes", (Object)MinecraftServer.getServer().bn())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((cwq)((cwq)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<cwq> nmsPredicate) {
        if (nmsPredicate instanceof dbb) {
            dbb ingredient = (dbb)nmsPredicate;
            return CraftRecipe.toBukkit((dbb)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((csa)CraftMagicNumbers.getItem((Material)itemType).g().a(kv.w)).a();
    }

    public DyeColor getShieldColor(ItemStack item) {
        cvn nmsColor = (cvn)CraftItemStack.asNMSCopy((ItemStack)item).a(kv.aj);
        return nmsColor != null ? DyeColor.getByWoolData((byte)((byte)nmsColor.a())) : null;
    }

    public ItemStack setShieldColor(ItemStack item, DyeColor color) {
        cwq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (color != null) {
            nmsItemStack.b(kv.aj, (Object)cvn.a((int)color.getWoolData()));
        } else {
            nmsItemStack.d(kv.aj);
        }
        return CraftItemStack.asBukkitCopy((cwq)nmsItemStack);
    }
}

