/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(dhl.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, dhl.d.class, Float.TYPE});
    public jr<dhl> biomeHolder;
    public ard world;

    public BiomeNMSImpl(ard world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = world.K_().e(mc.aI).a(aku.a((aku)mc.aI, (akv)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        dhl.c precipitation = ((dhl)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location), this.world.P());
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case dhl.c.b -> BiomeNMS.DownfallType.RAIN;
            case dhl.c.c -> BiomeNMS.DownfallType.SNOW;
            case dhl.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((dhl)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((dhl)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((dhl)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location), this.world.P());
    }

    public boolean hasDownfall() {
        return ((dhl)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(bvl.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(bvl.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(bvl.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(bvl.f);
    }

    public int getFoliageColor() {
        if (((dhl)this.biomeHolder.a()).f() != 0) {
            return ((dhl)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, dhl.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(dhl.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(dhr.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((dhl)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((dhl)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(dhr.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((dhl)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((dhl)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(dhr.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((dhl)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(bvl creatureType) {
        dhx mobs = ((dhl)this.biomeHolder.a()).b();
        bqx typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (dhx.c meta : typeSettingList.e()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((but)meta.b));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        dzd chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        ji pos = new ji(block.getX(), 0, block.getZ());
        if (this.world.B(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.i();
        }
    }

    public dhl.d getTemperatureModifier() {
        return ((dhl)this.biomeHolder.a()).i.c();
    }
}

