/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends bum>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends bum>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends bum> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends bum> entityClass, String name) {
        Class<? extends bum> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(bum.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(bum.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(bum.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(bum.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(bum.class, 4, "silent");
        EntityDataNameMapper.registerDataName(bum.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(bum.class, 6, "pose");
        EntityDataNameMapper.registerDataName(bum.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(bvd.class, 8, "width");
        EntityDataNameMapper.registerDataName(bvd.class, 9, "height");
        EntityDataNameMapper.registerDataName(bvd.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(buk.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(buk.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(buk.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(buk.class, 11, "translation");
        EntityDataNameMapper.registerDataName(buk.class, 12, "scale");
        EntityDataNameMapper.registerDataName(buk.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(buk.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(buk.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(buk.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(buk.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(buk.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(buk.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(buk.class, 20, "width");
        EntityDataNameMapper.registerDataName(buk.class, 21, "height");
        EntityDataNameMapper.registerDataName(buk.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(buk.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(buk.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(buk.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(buk.l.class, 23, "text");
        EntityDataNameMapper.registerDataName(buk.l.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(buk.l.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(buk.l.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(buk.l.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(cpz.class, 8, "item");
        EntityDataNameMapper.registerDataName(cpk.class, 8, "item");
        EntityDataNameMapper.registerDataName(cpm.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(buf.class, 8, "radius");
        EntityDataNameMapper.registerDataName(buf.class, 9, "color");
        EntityDataNameMapper.registerDataName(buf.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(buf.class, 11, "particle");
        EntityDataNameMapper.registerDataName(cpn.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(cpn.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(cpf.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(cpf.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(cph.class, 10, "color");
        EntityDataNameMapper.registerDataName(cqe.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(cqe.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cqz.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cqz.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cqz.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cqz.class, 11, "type");
        EntityDataNameMapper.registerDataName(cqz.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cqz.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cqz.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(cjv.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(cjv.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(cpv.class, 8, "item");
        EntityDataNameMapper.registerDataName(cpl.class, 8, "item");
        EntityDataNameMapper.registerDataName(cqf.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(cpm.class, 8, "item");
        EntityDataNameMapper.registerDataName(cpm.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(cpm.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(ckw.class, 8, "item");
        EntityDataNameMapper.registerDataName(ckw.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(cky.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(bvi.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(bvi.class, 9, "health");
        EntityDataNameMapper.registerDataName(bvi.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(bvi.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(bvi.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(bvi.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(bvi.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(coy.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(coy.class, 16, "score");
        EntityDataNameMapper.registerDataName(coy.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(coy.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(coy.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(coy.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(cks.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(cks.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(cks.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(cks.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(cks.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(cks.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(cks.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(bvk.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(cgt.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(chh.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(chh.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(chh.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(cgv.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(chs.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(chz.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bud.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cjq.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(cjq.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(cjd.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(cjf.class, 18, "variant");
        EntityDataNameMapper.registerDataName(ciq.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(ciq.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(cjc.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(cjg.class, 19, "strength");
        EntityDataNameMapper.registerDataName(cjg.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(cjg.class, 21, "variant");
        EntityDataNameMapper.registerDataName(cil.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cil.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(cil.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(cha.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(cha.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(chj.class, 17, "type");
        EntityDataNameMapper.registerDataName(chj.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(chj.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(chj.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(cit.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cit.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(chn.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(cho.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(cho.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(cho.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(cho.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(cho.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(cho.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(chq.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(chq.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(cht.class, 17, "type");
        EntityDataNameMapper.registerDataName(cia.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(cia.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(cia.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(cia.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(cia.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(cia.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(chr.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(cng.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(chm.class, 17, "variant");
        EntityDataNameMapper.registerDataName(chv.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(cmm.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(cmm.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(cmm.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(bwf.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(bwf.class, 18, "owner");
        EntityDataNameMapper.registerDataName(chc.class, 19, "variant");
        EntityDataNameMapper.registerDataName(chc.class, 20, "lying");
        EntityDataNameMapper.registerDataName(chc.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(chc.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(cic.class, 19, "begging");
        EntityDataNameMapper.registerDataName(cic.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(cic.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(chp.class, 19, "variant");
        EntityDataNameMapper.registerDataName(coe.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(coj.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(chl.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(chx.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(cmf.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(cmf.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(cmf.class, 18, "peek");
        EntityDataNameMapper.registerDataName(cmf.class, 19, "color");
        EntityDataNameMapper.registerDataName(cnl.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cnm.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(cnm.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cnm.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cli.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(cll.class, 16, "state");
        EntityDataNameMapper.registerDataName(cll.class, 17, "charged");
        EntityDataNameMapper.registerDataName(cll.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(ciz.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(ciz.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(ciz.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(clv.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(clv.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(cqm.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(cmc.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cmj.class, 17, "spell");
        EntityDataNameMapper.registerDataName(cmp.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(cmn.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(cmk.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(coa.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(ckq.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(ckq.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(ckq.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(ckq.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(cmr.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cms.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cms.class, 17, "type");
        EntityDataNameMapper.registerDataName(cms.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(cmt.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(cmt.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(clp.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(clp.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(clp.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cjw.class, 16, "phase");
        EntityDataNameMapper.registerDataName(clt.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(cmb.class, 16, "size");
        EntityDataNameMapper.registerDataName(cmi.class, 16, "size");
        EntityDataNameMapper.registerDataName(cqx.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cqx.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cqx.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cqx.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(cqx.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(cqx.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(cri.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(crh.class, 14, "command");
        EntityDataNameMapper.registerDataName(crh.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cle.class, 8, "fuse_ticks");
    }
}

