/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerClicksInInventoryScriptEvent
extends BukkitScriptEvent
implements Listener {
    public InventoryTag inventory;
    public ItemTag item;
    public ItemTag cursor;
    public InventoryClickEvent event;
    private static final HashSet<String> matchHelpList = new HashSet<String>(Arrays.asList("at", "entity", "npc", "player", "vehicle", "projectile", "hanging", "fake"));

    public PlayerClicksInInventoryScriptEvent() {
        this.registerCouldMatcher("player (<'click_type'>) clicks (<item>) in <inventory>");
        this.registerSwitches("with", "in_area", "action", "slot");
        this.registerDetermination(null, ItemTag.class, (evt, context, current) -> this.event.setCurrentItem(current.getItemStack()));
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        boolean clickFirst = path.eventArgLowerAt(1).equals("clicks");
        if (!clickFirst && !path.eventArgLowerAt(2).equals("clicks")) {
            return false;
        }
        String clickedOn = path.eventArgLowerAt(clickFirst ? 2 : 3);
        if (matchHelpList.contains(clickedOn)) {
            return false;
        }
        int inIndex = -1;
        for (int i = 0; i < path.eventArgsLower.length; ++i) {
            if (!path.eventArgLowerAt(i).equals("in")) continue;
            inIndex = i;
        }
        return inIndex != -1;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        boolean hasClickType = path.eventArgLowerAt(2).equals("clicks");
        if (hasClickType && !PlayerClicksInInventoryScriptEvent.runGenericCheck(path.eventArgLowerAt(1), this.event.getClick().name())) {
            return false;
        }
        String clickedItemText = path.eventArgLowerAt(hasClickType ? 3 : 2);
        if (!clickedItemText.equals("in") && !this.item.tryAdvancedMatcher(clickedItemText, path.context)) {
            return false;
        }
        int inIndex = -1;
        for (int i = 0; i < path.eventArgsLower.length; ++i) {
            if (!path.eventArgLowerAt(i).equals("in")) continue;
            inIndex = i;
        }
        if (!this.inventory.tryAdvancedMatcher(path.eventArgLowerAt(inIndex + 1), path.context)) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.runWithCheck(path, this.cursor)) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.nonSwitchWithCheck(path, this.cursor)) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getWhoClicked().getLocation(), "in_area")) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.runGenericSwitchCheck(path, "action", this.event.getAction().name())) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.trySlot(path, "slot", (Entity)this.event.getWhoClicked(), this.event.getSlot()) && !PlayerClicksInInventoryScriptEvent.runGenericSwitchCheck(path, "slot", this.event.getSlotType().name())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getWhoClicked());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "inventory" -> this.inventory;
            case "item" -> this.item;
            case "cursor_item" -> this.cursor;
            case "click" -> new ElementTag((Enum<?>)this.event.getClick());
            case "action" -> new ElementTag((Enum<?>)this.event.getAction());
            case "slot_type" -> new ElementTag((Enum<?>)this.event.getSlotType());
            case "is_shift_click" -> new ElementTag(this.event.isShiftClick());
            case "slot" -> new ElementTag(this.event.getSlot() + 1);
            case "raw_slot" -> new ElementTag(this.event.getRawSlot() + 1);
            case "hotbar_button" -> new ElementTag(this.event.getHotbarButton() + 1);
            case "clicked_inventory" -> {
                if (this.event.getClickedInventory() != null) {
                    yield InventoryTag.mirrorBukkitInventory(this.event.getClickedInventory());
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        this.inventory = InventoryTag.mirrorBukkitInventory(event.getInventory());
        this.item = event.getCurrentItem() == null ? new ItemTag(Material.AIR) : new ItemTag(event.getCurrentItem().clone());
        this.cursor = new ItemTag(event.getCursor() == null ? new ItemStack(Material.AIR) : event.getCursor().clone());
        this.event = event;
        this.fire((Event)event);
    }
}

