/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SpawnerSpawnEvent;

public class EntitySpawnerSpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    private EntityTag entity;
    private LocationTag location;
    private LocationTag spawnerLocation;

    public EntitySpawnerSpawnScriptEvent() {
        this.registerCouldMatcher("spawner spawns <entity>");
        this.registerSwitches("spawner");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(2, this.entity)) {
            return false;
        }
        if (!path.tryObjectSwitch("spawner", this.spawnerLocation)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            case "location" -> this.location;
            case "spawner_location" -> this.spawnerLocation;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        Entity entity = event.getEntity();
        this.entity = new EntityTag(entity);
        this.location = new LocationTag(event.getLocation());
        this.spawnerLocation = new LocationTag(event.getSpawner().getLocation());
        EntityTag.rememberEntity(entity);
        this.fire((Event)event);
        EntityTag.forgetEntity(entity);
    }
}

