/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.enums.CustomEntityType;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ImprovedOfflinePlayerImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.entities.CraftFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_21.impl.entities.EntityItemProjectileImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHelperImpl
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = ReflectionHelper.getFields(cew.class).get(ReflectionMappingsInfo.LivingEntity_attackStrengthTicker, Integer.TYPE);
    public static final Field FLY_TICKS = ReflectionHelper.getFields(axz.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundTickCount, Integer.TYPE);
    public static final Field VEHICLE_FLY_TICKS = ReflectionHelper.getFields(axz.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundVehicleTickCount, Integer.TYPE);
    public static final Field PASSENGERS_PACKET_PASSENGERS = ReflectionHelper.getFields(agn.class).get(ReflectionMappingsInfo.ClientboundSetPassengersPacket_passengers, int[].class);
    public static final MethodHandle PLAYER_RESPAWNCONFIG_SETTER = ReflectionHelper.getFinalSetter(awy.class, (String)ReflectionMappingsInfo.ServerPlayer_respawnConfig, awy.a.class);
    public static final MethodHandle SERVER_RECIPE_BOOK_ADD_HIGHLIGHT = ReflectionHelper.getMethodHandle(bcj.class, (String)ReflectionMappingsInfo.ServerRecipeBook_addHighlight_method, (Class[])new Class[]{ami.class});

    public void stopSound(Player player, NamespacedKey sound, SoundCategory category) {
        ((CraftPlayer)player).getHandle().g.b((aao)new agz(sound == null ? null : CraftNamespacedKey.toMinecraft((NamespacedKey)sound), null));
    }

    public void deTrackEntity(Player player, Entity entity) {
        awy nmsPlayer = ((CraftPlayer)player).getHandle();
        awb.b tracker = (awb.b)nmsPlayer.A().n().a.J.get(entity.getEntityId());
        if (tracker == null) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("Failed to de-track entity " + entity.getEntityId() + " for " + player.getName() + ": tracker null");
            }
            return;
        }
        this.sendEntityDestroy(player, entity);
        tracker.a(nmsPlayer);
    }

    public void addFakePassenger(List<PlayerTag> players, Entity vehicle, FakeEntity fakePassenger) {
        agn packet = new agn(((CraftEntity)vehicle).getHandle());
        int[] newPassengers = Arrays.copyOf(packet.b(), packet.b().length + 1);
        newPassengers[packet.b().length] = fakePassenger.id;
        try {
            PASSENGERS_PACKET_PASSENGERS.set(packet, newPassengers);
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
        }
        for (PlayerTag player : players) {
            PacketHelperImpl.send(player.getPlayerEntity(), packet);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FakeEntity sendEntitySpawn(List<PlayerTag> players, DenizenEntityType entityType, LocationTag location, ArrayList<Mechanism> mechanisms, int customId, UUID customUUID, boolean autoTrack) {
        void var9_15;
        Entity entity;
        CraftWorld world = (CraftWorld)location.getWorld();
        if (entityType.isCustom()) {
            if (entityType.customEntityType == CustomEntityType.ITEM_PROJECTILE) {
                ItemStack itemStack = new ItemStack(Material.STONE);
                for (Mechanism mechanism : mechanisms) {
                    if (!mechanism.matches("item") || !mechanism.requireObject(ItemTag.class)) continue;
                    itemStack = ((ItemTag)mechanism.valueAsType(ItemTag.class)).getItemStack();
                }
                EntityItemProjectileImpl entityItemProjectileImpl = new EntityItemProjectileImpl((drq)world.getHandle(), (Location)location, CraftItemStack.asNMSCopy((ItemStack)itemStack));
            } else {
                if (entityType.customEntityType != CustomEntityType.FAKE_PLAYER) throw new IllegalArgumentException("entityType");
                String name = null;
                Object skin = null;
                String blob = null;
                for (Mechanism mechanism : new ArrayList<Mechanism>(mechanisms)) {
                    if (mechanism.matches("name")) {
                        name = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin")) {
                        skin = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin_blob")) {
                        blob = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    }
                    if (name == null || skin == null && blob == null) continue;
                    break;
                }
                awy awy2 = ((CraftFakePlayerImpl)NMSHandler.customEntityHelper.spawnFakePlayer((Location)location, name, skin, blob, false)).getHandle();
            }
        } else {
            entity = world.createEntity((Location)location, entityType.getBukkitEntityType().getEntityClass());
            cdv cdv2 = ((CraftEntity)entity).getHandle();
        }
        if (customUUID != null) {
            var9_15.e(customId);
            var9_15.a_(customUUID);
        }
        entity = new EntityTag((Entity)var9_15.getBukkitEntity());
        entity.isFake = true;
        entity.isFakeValid = true;
        for (Mechanism mechanism : mechanisms) {
            entity.safeAdjustDuplicate(mechanism);
        }
        var9_15.ee();
        FakeEntity fake = new FakeEntity(players, location, entity.getBukkitEntity().getEntityId());
        fake.entity = new EntityTag(entity.getBukkitEntity());
        fake.entity.isFake = true;
        fake.entity.isFakeValid = true;
        ArrayList trackers = new ArrayList();
        fake.triggerSpawnPacket = arg_0 -> this.lambda$sendEntitySpawn$0(world, (cdv)var9_15, trackers, autoTrack, fake, arg_0);
        for (PlayerTag player : players) {
            fake.triggerSpawnPacket.accept(player);
        }
        fake.triggerUpdatePacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a();
            }
        };
        fake.triggerDestroyPacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a(((CraftPlayer)tracker.player.getPlayerEntity()).getHandle());
            }
            trackers.clear();
        };
        return fake;
    }

    public void sendEntityDestroy(Player player, Entity entity) {
        ((CraftPlayer)player).getHandle().g.b((aao)new afl(new int[]{entity.getEntityId()}));
    }

    public int getFlyKickCooldown(Player player) {
        axz conn = ((CraftPlayer)player).getHandle().g;
        if (conn instanceof AbstractListenerPlayInImpl) {
            AbstractListenerPlayInImpl denizenListener = (AbstractListenerPlayInImpl)conn;
            conn = denizenListener.oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return 80;
        }
    }

    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        axz conn = ((CraftPlayer)player).getHandle().g;
        if (conn instanceof AbstractListenerPlayInImpl) {
            AbstractListenerPlayInImpl denizenListener = (AbstractListenerPlayInImpl)conn;
            conn = denizenListener.oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
        }
    }

    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return -1;
        }
    }

    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().gU() + 3.0f;
    }

    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
        }
    }

    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().n().a.a(new dqv(chunk.getX(), chunk.getZ()), false).stream().anyMatch(entityPlayer -> entityPlayer.cT().equals(player.getUniqueId()));
    }

    public void setTemporaryOp(Player player, boolean op) {
        aro server = ((CraftServer)Bukkit.getServer()).getServer();
        bbb nameAndId = new bbb(((CraftPlayer)player).getProfile());
        bbf opList = server.am().k();
        if (op) {
            opList.a(new bbg(nameAndId, server.k(), opList.b(nameAndId)));
        } else {
            opList.a(nameAndId);
        }
        player.recalculatePermissions();
    }

    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().k = true;
        ((CraftPlayer)player).getHandle().g.b((aao)new aec(aec.f, 1.0f));
    }

    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayerImpl(uuid);
    }

    public void resendRecipeDetails(Player player) {
        dmp recipeManager = ((CraftServer)Bukkit.getServer()).getServer().aN();
        ahm updatePacket = new ahm(recipeManager.b(), recipeManager.c());
        ((CraftPlayer)player).getHandle().g.b((aao)updatePacket);
    }

    public void resendDiscoveredRecipes(Player player) {
        bcj recipeBook = ((CraftPlayer)player).getHandle().L();
        recipeBook.a(((CraftPlayer)player).getHandle());
    }

    public void quietlyAddRecipe(Player player, NamespacedKey key) {
        bcj recipeBook = ((CraftPlayer)player).getHandle().L();
        dmn<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            Debug.echoError((String)("Cannot add recipe '" + String.valueOf(key) + "': it does not exist."));
            return;
        }
        recipeBook.a(recipe.a());
        try {
            SERVER_RECIPE_BOOK_ADD_HIGHLIGHT.invoke(recipeBook, recipe.a());
        }
        catch (Throwable e2) {
            Debug.echoError((Throwable)e2);
        }
    }

    public byte getSkinLayers(Player player) {
        return (Byte)((CraftPlayer)player).getHandle().aC().a(cdn.t);
    }

    public void setSkinLayers(Player player, byte flags) {
        ((CraftPlayer)player).getHandle().aC().a(cdn.t, (Object)flags);
    }

    public void setBossBarTitle(BossBar bar, String title) {
        ((CraftBossBar)bar).getHandle().a = Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE));
        ((CraftBossBar)bar).getHandle().a(ada::c);
    }

    public boolean getSpawnForced(Player player) {
        return ((CraftPlayer)player).getHandle().V().b();
    }

    public void setSpawnForced(Player player, boolean forced) {
        awy nmsPlayer = ((CraftPlayer)player).getHandle();
        try {
            awy.a config = nmsPlayer.V();
            config = new awy.a(config.a(), forced);
            PLAYER_RESPAWNCONFIG_SETTER.invoke(nmsPlayer, config);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Location getBedSpawnLocation(Player player) {
        awy nmsPlayer = ((CraftPlayer)player).getHandle();
        awy.a nmsRespawnConfig = nmsPlayer.V();
        if (nmsRespawnConfig == null) {
            return null;
        }
        fid.a nmsRespawnData = nmsRespawnConfig.a();
        awx nmsWorld = MinecraftServer.getServer().a(nmsRespawnData.a());
        if (nmsWorld == null) {
            return null;
        }
        return CraftLocation.toBukkit((ja)nmsRespawnData.b(), (World)nmsWorld.getWorld(), (float)nmsRespawnData.d(), (float)nmsRespawnData.e());
    }

    public long getLastActionTime(Player player) {
        return ((CraftPlayer)player).getHandle().P();
    }

    public void sendPlayerInfoAddPacket(Player player, EnumSet<PlayerHelper.ProfileEditMode> editModes, String name, String display, UUID id, String texture, String signature, int latency, GameMode gameMode, boolean listed) {
        EnumSet<afd.a> actions = EnumSet.noneOf(afd.a.class);
        for (PlayerHelper.ProfileEditMode editMode : editModes) {
            actions.add(switch (editMode) {
                default -> throw new IncompatibleClassChangeError();
                case PlayerHelper.ProfileEditMode.ADD -> afd.a.a;
                case PlayerHelper.ProfileEditMode.UPDATE_DISPLAY -> afd.a.f;
                case PlayerHelper.ProfileEditMode.UPDATE_LATENCY -> afd.a.e;
                case PlayerHelper.ProfileEditMode.UPDATE_GAME_MODE -> afd.a.c;
                case PlayerHelper.ProfileEditMode.UPDATE_LISTED -> afd.a.d;
            });
        }
        GameProfile profile = ProfileEditorImpl.createGameProfile(id, name, texture, signature);
        afd.b entry = new afd.b(id, profile, listed, latency, gameMode == null ? null : drn.a((int)gameMode.getValue()), display == null ? null : Handler.componentToNMS(FormattedTextHelper.parse((String)display, (ChatColor)ChatColor.WHITE)), true, player.getPlayerListOrder(), null);
        PacketHelperImpl.send(player, ProfileEditorImpl.createInfoPacket(actions, List.of(entry)));
    }

    public void sendPlayerInfoRemovePacket(Player player, UUID id) {
        PacketHelperImpl.send(player, new afc(List.of(id)));
    }

    public void sendClimbableMaterials(Player player, List<Material> materials) {
        Map packetInput = bdl.a((jr)((CraftServer)Bukkit.getServer()).getServer().bh());
        Map tags = (Map)ReflectionHelper.getFieldValue(bdl.a.class, (String)ReflectionMappingsInfo.TagNetworkSerializationNetworkPayload_tags, packetInput.get(mo.e.g()));
        IntList climbableBlocks = (IntList)tags.get(bct.bd.b());
        climbableBlocks.clear();
        for (Material material : materials) {
            climbableBlocks.add(mo.e.a((Object)CraftMagicNumbers.getBlock((Material)material)));
        }
        PacketHelperImpl.send(player, new abj(packetInput));
    }

    public void refreshPlayer(Player player) {
        awy nmsPlayer = ((CraftPlayer)player).getHandle();
        awx nmsWorld = nmsPlayer.A();
        nmsPlayer.g.b((aao)new afo(nmsPlayer.b(nmsWorld), 3));
        nmsPlayer.g.internalTeleport(cfj.a((cdv)nmsPlayer), Set.of());
        if (nmsPlayer.cl()) {
            nmsPlayer.g.b((aao)new agn(nmsPlayer.du()));
        }
        if (nmsPlayer.cm()) {
            nmsPlayer.g.b((aao)new agn((cdv)nmsPlayer));
        }
        foc boundingBox = foc.a((foh)nmsPlayer.de().f(), (double)32.0, (double)32.0, (double)32.0);
        for (Object nmsEntity2 : nmsWorld.a(cdv.class, boundingBox, nmsEntity -> {
            ceu nmsLeashable;
            return nmsEntity instanceof ceu && nmsPlayer.equals((Object)(nmsLeashable = (ceu)nmsEntity).ak_());
        })) {
            nmsPlayer.g.b((aao)new agg((cdv)nmsEntity2, (cdv)nmsPlayer));
        }
        if (!nmsPlayer.gW().a.isEmpty()) {
            int tickCount = nmsPlayer.gW().b;
            for (Map.Entry entry : nmsPlayer.gW().a.entrySet()) {
                nmsPlayer.g.b((aao)new ado((amj)entry.getKey(), ((dhm.a)entry.getValue()).b - tickCount));
            }
        }
        nmsPlayer.g.b((aao)new agj(nmsPlayer.ct, nmsPlayer.cs, nmsPlayer.cr));
        for (ccx nmsEffect : nmsPlayer.eR()) {
            nmsPlayer.g.b((aao)new ahl(nmsPlayer.az(), nmsEffect, false));
        }
        nmsPlayer.z();
        bbd nmsPlayerList = nmsPlayer.cK.am();
        nmsPlayerList.d(nmsPlayer);
        nmsPlayerList.a(nmsPlayer, nmsWorld);
        nmsPlayerList.e(nmsPlayer);
    }

    private /* synthetic */ void lambda$sendEntitySpawn$0(CraftWorld world, cdv nmsEntity, List trackers, boolean autoTrack, final FakeEntity fake, final PlayerTag player) {
        awy nmsPlayer = ((CraftPlayer)player.getPlayerEntity()).getHandle();
        axz conn = nmsPlayer.g;
        final awv tracker = new awv(world.getHandle(), nmsEntity, 1, true, (awv.a)new FakeEntitySynchronizer(conn), Set.of(conn));
        tracker.b(nmsPlayer);
        TrackerData data = new TrackerData(player, tracker);
        trackers.add(data);
        if (autoTrack) {
            new BukkitRunnable(){
                boolean wasOnline = true;

                public void run() {
                    if (!fake.entity.isFakeValid) {
                        this.cancel();
                        return;
                    }
                    if (player.isOnline()) {
                        if (!this.wasOnline) {
                            tracker.b(((CraftPlayer)player.getPlayerEntity()).getHandle());
                            this.wasOnline = true;
                        }
                        tracker.a();
                    } else if (this.wasOnline) {
                        this.wasOnline = false;
                    }
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }
    }

    public record TrackerData(PlayerTag player, awv tracker) {
    }

    public record FakeEntitySynchronizer(axz target) implements awv.a
    {
        public void a(aao<? super acr> packet) {
            this.target.b(packet);
        }

        public void b(aao<? super acr> packet) {
            this.a(packet);
        }

        public void a(aao<? super acr> packet, Predicate<awy> predicate) {
            if (predicate.test(this.target.o())) {
                this.a(packet);
            }
        }

        public void sendToTrackingPlayersFilteredAndSelf(aao<? super acr> packet, Predicate<awy> predicate) {
            this.a(packet, predicate);
        }
    }
}

