/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.MapScriptContainer;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.maps.DenizenMapRenderer;
import com.denizenscript.denizen.utilities.maps.MapDot;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizen.utilities.maps.MapText;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class MapCommand
extends AbstractCommand {
    public MapCommand() {
        this.setName("map");
        this.setSyntax("map [<#>/new:<world>] (reset:<location>/reset_to_blank) (scale:<value>) (tracking) (image:<file>) (resize) (script:<script>) (dot:<color>) (radius:<#>) (x:<#>) (y:<#>) (text:<text>) (width:<#>) (height:<#>)");
        this.setRequiredArguments(2, 14);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="map-id") @ArgLinear @ArgDefaultNull ElementTag id, @ArgName(value="new") @ArgPrefixed @ArgDefaultNull WorldTag create, @ArgName(value="reset") @ArgPrefixed @ArgDefaultNull LocationTag resetLoc, @ArgName(value="reset_to_blank") boolean resetEmpty, @ArgName(value="scale") @ArgPrefixed @ArgDefaultNull MapView.Scale scale, @ArgName(value="tracking") boolean tracking, @ArgName(value="image") @ArgPrefixed @ArgDefaultNull String image, @ArgName(value="resize") boolean resize, @ArgName(value="script") @ArgPrefixed @ArgDefaultNull ScriptTag script, @ArgName(value="dot") @ArgPrefixed @ArgDefaultNull ColorTag dot, @ArgName(value="radius") @ArgPrefixed @ArgDefaultText(value="-1") int radius, @ArgName(value="x") @ArgPrefixed @ArgDefaultText(value="0") double x, @ArgName(value="y") @ArgPrefixed @ArgDefaultText(value="0") double y, @ArgName(value="width") @ArgPrefixed @ArgDefaultText(value="-1") int width, @ArgName(value="height") @ArgPrefixed @ArgDefaultText(value="-1") int height, @ArgName(value="text") @ArgPrefixed @ArgDefaultNull ElementTag text) {
        MapView map;
        if (create == null && id == null) {
            throw new InvalidArgumentsRuntimeException("Must specify a map ID or create a new map!");
        }
        if (resetLoc == null && image == null && script == null && dot == null && text == null && !resetEmpty) {
            throw new InvalidArgumentsRuntimeException("Must specify a valid action to perform!");
        }
        if (create != null) {
            map = Bukkit.getServer().createMap(create.getWorld());
            scriptEntry.saveObject("created_map", new ElementTag(map.getId()));
            Debug.echoDebug((Debuggable)scriptEntry, "Created map with id " + map.getId() + ".");
        } else {
            map = Bukkit.getServer().getMap(id.asInt());
            if (map == null) {
                Debug.echoError("No map found for ID '" + id.asInt() + "'!");
                return;
            }
        }
        if (resetEmpty || resetLoc != null) {
            map.setTrackingPosition(tracking);
            if (scale != null) {
                map.setScale(scale);
            }
            for (MapRenderer renderer : DenizenMapManager.removeDenizenRenderers(map)) {
                map.addRenderer(renderer);
            }
            if (resetLoc != null) {
                map.setCenterX(resetLoc.getBlockX());
                map.setCenterZ(resetLoc.getBlockZ());
                map.setWorld(resetLoc.getWorld());
            }
        }
        if (script != null) {
            DenizenMapManager.removeDenizenRenderers(map);
            ((MapScriptContainer)script.getContainer()).applyTo(map);
        }
        DenizenMapRenderer dmr = DenizenMapManager.getDenizenRenderer(map);
        if (image != null) {
            width = MapCommand.formatSize(width, resize);
            height = MapCommand.formatSize(height, resize);
            if (CoreUtilities.toLowerCase(image).endsWith(".gif")) {
                dmr.autoUpdate = true;
            }
            dmr.addObject(new MapImage(dmr, String.valueOf(x), String.valueOf(y), "true", false, image, width, height));
            dmr.hasChanged = true;
        }
        if (dot != null) {
            dmr.addObject(new MapDot(String.valueOf(x), String.valueOf(y), "true", false, String.valueOf(radius), dot.toString()));
            dmr.hasChanged = true;
        }
        if (text != null) {
            dmr.addObject(new MapText(String.valueOf(x), String.valueOf(y), "true", false, text.asString(), null, null, null, null));
            dmr.hasChanged = true;
        }
    }

    public static int formatSize(int size, boolean resize) {
        if (size != -1) {
            return size;
        }
        return resize ? 128 : 0;
    }
}

