/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.scripts.ScriptEntry;
import java.util.Iterator;
import java.util.List;

public class ListQueue
implements Iterable<ScriptEntry> {
    public ScriptEntry[] values;
    public int count;
    public int start;

    public ListQueue(int capacity) {
        this.values = new ScriptEntry[capacity];
        this.start = 0;
    }

    public final void clear() {
        this.count = 0;
        this.start = 0;
    }

    public final ScriptEntry removeFirst() {
        --this.count;
        return this.values[this.start++];
    }

    public final int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public final ScriptEntry get(int index) {
        return this.values[index + this.start];
    }

    public final void ensureCapacity(int cap) {
        if (cap < this.values.length - this.start) {
            return;
        }
        ScriptEntry[] newSet = new ScriptEntry[cap];
        System.arraycopy(this.values, this.start, newSet, 0, this.count);
        this.values = newSet;
        this.start = 0;
    }

    public final void injectAtStart(ScriptEntry entry) {
        if (this.count == 0 && this.values.length > 0) {
            this.start = 0;
        } else if (this.start > 0) {
            --this.start;
        } else {
            ScriptEntry[] newSet = new ScriptEntry[Math.max(this.count + 5, this.values.length)];
            System.arraycopy(this.values, this.start, newSet, 3, this.count);
            this.values = newSet;
            this.start = 2;
        }
        this.values[this.start] = entry;
        ++this.count;
    }

    public final void add(ScriptEntry entry) {
        this.ensureCapacity(this.count * 2 + 1);
        this.values[this.count + this.start] = entry;
        ++this.count;
    }

    public final void addAll(List<ScriptEntry> entries) {
        this.ensureCapacity(this.count * 2 + entries.size());
        if (this.count == 0) {
            this.start = 0;
        }
        int firstIndex = this.start + this.count;
        for (int i = 0; i < entries.size(); ++i) {
            this.values[firstIndex + i] = entries.get(i);
        }
        this.count += entries.size();
    }

    public final void addAllToStart(List<ScriptEntry> entries) {
        if (this.count == 0) {
            this.addAll(entries);
            return;
        }
        if (this.start >= entries.size()) {
            this.start -= entries.size();
            for (int i = 0; i < entries.size(); ++i) {
                this.values[this.start + i] = entries.get(i);
            }
        } else {
            ScriptEntry[] newSet = new ScriptEntry[this.values.length + entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                newSet[i] = entries.get(i);
            }
            if (this.count > 0) {
                System.arraycopy(this.values, this.start, newSet, entries.size(), this.count);
            }
            this.values = newSet;
            this.start = 0;
        }
        this.count += entries.size();
    }

    @Override
    public final Iterator<ScriptEntry> iterator() {
        return new ListQueueIterator();
    }

    public class ListQueueIterator
    implements Iterator<ScriptEntry> {
        public int index;

        @Override
        public final boolean hasNext() {
            return this.index < ListQueue.this.count;
        }

        @Override
        public final ScriptEntry next() {
            return ListQueue.this.get(this.index++);
        }
    }
}

