/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.entity.ItemFrame;

public class EntityFramed
implements Property {
    public static final String[] handledTags = new String[]{"framed_item_rotation", "framed_item", "has_framed_item"};
    public static final String[] handledMechs = new String[]{"framed"};
    EntityTag item_frame;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof ItemFrame;
    }

    public static EntityFramed getFrom(ObjectTag entity) {
        if (!EntityFramed.describes(entity)) {
            return null;
        }
        return new EntityFramed((EntityTag)entity);
    }

    public EntityFramed(EntityTag item) {
        this.item_frame = item;
    }

    public boolean hasItem() {
        return this.getItemFrameEntity().getItem() != null && this.getItemFrameEntity().getItem().getType() != Material.AIR;
    }

    public ItemFrame getItemFrameEntity() {
        return (ItemFrame)this.item_frame.getBukkitEntity();
    }

    public void setItem(ItemTag item) {
        this.getItemFrameEntity().setItem(item.getItemStack());
    }

    public ItemTag getItem() {
        return new ItemTag(this.getItemFrameEntity().getItem());
    }

    @Override
    public String getPropertyString() {
        if (this.hasItem()) {
            return this.getItem().identify() + (String)(this.getItemFrameEntity().getRotation() == Rotation.NONE ? "" : "|" + CoreUtilities.toLowerCase(this.getItemFrameEntity().getRotation().name()));
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "framed";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("framed_item_rotation")) {
            return new ElementTag(CoreUtilities.toLowerCase(this.getItemFrameEntity().getRotation().name())).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("framed_item")) {
            return this.getItem().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_framed_item")) {
            return new ElementTag(this.hasItem()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("framed")) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (list.isEmpty()) {
                mechanism.echoError("Missing value for 'framed' mechanism!");
                return;
            }
            if (new ElementTag(list.get(0)).matchesType(ItemTag.class)) {
                this.setItem(new ElementTag(list.get(0)).asType(ItemTag.class, mechanism.context));
            } else {
                mechanism.echoError("Invalid item '" + list.get(0) + "'");
            }
            if (list.size() > 1 && new ElementTag(list.get(1)).matchesEnum(Rotation.class)) {
                this.getItemFrameEntity().setRotation(Rotation.valueOf((String)list.get(1).toUpperCase()));
            }
        }
    }
}

