/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.util.function.Consumer;

public class ReloadCommand
extends AbstractCommand
implements Holdable {
    public ReloadCommand() {
        this.setName("reload");
        this.setSyntax("reload ({scripts}/scripts_now/config/saves/notes)");
        this.setRequiredArguments(0, 1);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, ScriptQueue queue, @ArgName(value="type") @ArgDefaultText(value="scripts") ReloadType type) {
        switch (type.ordinal()) {
            case 0: {
                Consumer<String> altDebug = queue.debugOutput;
                if (altDebug != null) {
                    DebugInternals.specialBackupSender = s -> DenizenCore.runOnMainThread(() -> altDebug.accept((String)s));
                }
                DenizenCore.reloadScripts(true, () -> {
                    DebugInternals.specialBackupSender = null;
                    scriptEntry.setFinished(true);
                });
                break;
            }
            case 1: {
                scriptEntry.setFinished(true);
                DenizenCore.reloadScripts(false, null);
                break;
            }
            case 2: {
                scriptEntry.setFinished(true);
                DenizenCore.implementation.reloadConfig();
                break;
            }
            case 3: {
                scriptEntry.setFinished(true);
                DenizenCore.implementation.reloadSaves();
                break;
            }
            case 4: {
                scriptEntry.setFinished(true);
                NoteManager.reload();
            }
        }
    }

    public static enum ReloadType {
        SCRIPTS,
        SCRIPTS_NOW,
        CONFIG,
        SAVES,
        NOTES;

    }
}

