/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;

public class ScriptHelper {
    public static volatile ArrayList<YamlConfiguration> _yamlScripts;
    @Deprecated
    public static ArrayList<YamlConfiguration> additionalScripts;
    public static List<Consumer<List<YamlConfiguration>>> buildAdditionalScripts;
    private static volatile boolean hadError;
    private static volatile HashMap<String, String> scriptSources;
    private static volatile HashMap<String, String> scriptOriginalNames;
    private static volatile HashMap<String, String> scriptSourcesInprogress;
    private static volatile HashMap<String, String> scriptOriginalNamesInprogress;

    private static void reloadFailed(Throwable ex) {
        hadError = true;
        Debug.echoError("Could not load scripts!");
        Debug.echoError(ex);
        _yamlScripts = new ArrayList();
    }

    public static void reloadScripts(boolean delayable, Runnable preReload, Consumer<Long> onFinished) {
        Runnable afterLoad = () -> {
            long midPoint = CoreUtilities.monotonicMillis();
            if (preReload != null) {
                preReload.run();
            }
            ScriptHelper.postLoad();
            _yamlScripts.addAll(additionalScripts);
            ScriptRegistry.buildCoreYamlScriptContainers(_yamlScripts);
            onFinished.accept(midPoint);
        };
        if (delayable) {
            DenizenCore.runAsync(() -> {
                try {
                    _yamlScripts = ScriptHelper.buildScriptList();
                    DenizenCore.runOnMainThread(afterLoad);
                }
                catch (Throwable ex) {
                    ScriptHelper.reloadFailed(ex);
                }
            });
        } else {
            try {
                _yamlScripts = ScriptHelper.buildScriptList();
                afterLoad.run();
            }
            catch (Throwable ex) {
                ScriptHelper.reloadFailed(ex);
            }
        }
    }

    public static boolean hadError() {
        return hadError;
    }

    public static void resetError() {
        hadError = false;
    }

    public static void setHadError() {
        hadError = true;
    }

    public static String getSource(String script) {
        return scriptSources.get(CoreUtilities.toLowerCase(script));
    }

    public static String getOriginalName(String script) {
        return scriptOriginalNames.get(CoreUtilities.toLowerCase(script));
    }

    public static String clearComments(String filename, String input, boolean trackSources) {
        StringBuilder result = new StringBuilder(input.length());
        String[] lines = input.replace("\t", "    ").replace("\r", "").split("\n");
        boolean hasAnyScript = false;
        for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            String trimmedLine = lines[lineNum].trim();
            String trimStart = lines[lineNum].replaceAll("^[\\s]+", "");
            if (trackSources && !trimmedLine.startsWith("#") && trimStart.length() == lines[lineNum].length() && trimmedLine.endsWith(":") && trimmedLine.length() > 1) {
                String name = trimmedLine.substring(0, trimmedLine.length() - 1).replace('\"', '\'').replace("'", "");
                scriptSourcesInprogress.put(CoreUtilities.toLowerCase(name), filename);
                scriptOriginalNamesInprogress.put(CoreUtilities.toLowerCase(name), name);
                result.append(CoreUtilities.toUpperCase(name)).append(":\n");
                hasAnyScript = true;
                continue;
            }
            if (!trimmedLine.startsWith("#")) {
                if (trackSources && !hasAnyScript && trimmedLine.endsWith(":")) {
                    Debug.echoError("Script '<Y>" + filename + "<W>' is broken: script container title has spaces in front.");
                    hasAnyScript = true;
                }
                Object curLine = lines[lineNum].replace('\u0000', ' ');
                boolean endsColon = trimmedLine.endsWith(":");
                boolean startsDash = trimmedLine.startsWith("-");
                if (!endsColon && startsDash) {
                    curLine = ((String)curLine).replace(": ", "<&co> ");
                    curLine = ((String)curLine).replace("#", "<&ns>");
                } else if (endsColon && !startsDash) {
                    if (((String)curLine).contains(".")) {
                        curLine = CoreUtilities.replace((String)curLine, "&", "&amp");
                        curLine = CoreUtilities.replace((String)curLine, ".", "&dot");
                    }
                } else if (!startsDash && (trimmedLine.contains(": &") || trimmedLine.contains(": *") || trimmedLine.contains(": !"))) {
                    colon = ((String)curLine).indexOf(58);
                    curLine = ((String)curLine).substring(0, colon) + ": \"" + ((String)curLine).substring(colon + 2).replace("\"", "<&dq>") + "\"";
                } else if (!endsColon) {
                    colon = ((String)curLine).indexOf(58);
                    curLine = ((String)curLine).substring(0, colon + 1) + CoreUtilities.replace(((String)curLine).substring(colon + 1), ":", "<&co>");
                }
                if (trimmedLine.startsWith("- ") && !trimmedLine.startsWith("- \"") && !trimmedLine.startsWith("- '")) {
                    int dashIndex = ((String)curLine).indexOf(45);
                    curLine = ((String)curLine).substring(0, dashIndex + 1) + " ^" + (lineNum + 1) + "^" + ((String)curLine).substring(dashIndex + 1);
                }
                result.append((String)curLine).append("\n");
                continue;
            }
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    public static String convertStreamToString(InputStream is) {
        return ScriptHelper.convertStreamToString(is, false);
    }

    public static String convertStreamToString(InputStream is, boolean defaultUTF8) {
        Scanner s = CoreConfiguration.scriptEncoding == null && !defaultUTF8 ? new Scanner(is) : new Scanner(new InputStreamReader(is, CoreConfiguration.scriptEncoding == null ? StandardCharsets.UTF_8.newDecoder() : CoreConfiguration.scriptEncoding));
        s.useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YamlConfiguration loadConfig(String filename, InputStream resource) throws IOException {
        try {
            String script = ScriptHelper.clearComments(filename, ScriptHelper.convertStreamToString(resource, filename.endsWith(".dsc")), true);
            YamlConfiguration yamlConfiguration = YamlConfiguration.load(script);
            return yamlConfiguration;
        }
        finally {
            resource.close();
        }
    }

    private static ArrayList<YamlConfiguration> buildScriptList() {
        scriptSourcesInprogress = new HashMap();
        scriptOriginalNamesInprogress = new HashMap();
        try {
            File file = DenizenCore.implementation.getScriptFolder();
            if (!file.exists()) {
                Debug.echoError("No script folder found, please create one.");
                hadError = true;
                return new ArrayList<YamlConfiguration>();
            }
            List<File> files = CoreUtilities.listDScriptFiles(file);
            if (files.size() > 0 || buildAdditionalScripts.size() > 0) {
                ArrayList<YamlConfiguration> outList = new ArrayList<YamlConfiguration>();
                for (File file2 : files) {
                    String fileName = file2.getAbsolutePath().substring(file.getAbsolutePath().length());
                    if (CoreConfiguration.debugLoadingInfo) {
                        Debug.log("Processing '" + fileName + "'... ");
                    }
                    try {
                        String saved;
                        YamlConfiguration yaml = ScriptHelper.loadConfig(file2.getAbsolutePath(), new FileInputStream(file2));
                        String string = saved = yaml != null ? yaml.saveToString(false) : null;
                        if (saved != null && saved.length() > 0) {
                            outList.add(yaml);
                            continue;
                        }
                        Debug.echoError("Error parsing '<Y>" + fileName + "<W>'! This script has been skipped. No internal error - is the file empty?");
                        hadError = true;
                    }
                    catch (Exception e) {
                        Debug.echoError("Error parsing '<Y>" + fileName + "<W>'!");
                        hadError = true;
                        Debug.echoError(e);
                    }
                }
                for (Consumer consumer : buildAdditionalScripts) {
                    try {
                        consumer.accept(outList);
                    }
                    catch (Exception ex) {
                        Debug.echoError("Error parsing additional script!");
                        hadError = true;
                        Debug.echoError(ex);
                    }
                }
                if (CoreConfiguration.debugLoadingInfo) {
                    Debug.echoApproval("All scripts loaded!");
                }
                return outList;
            }
            Debug.log("No scripts in /plugins/Denizen/scripts/ to load!");
            hadError = true;
        }
        catch (Exception e) {
            Debug.echoError("No script folder found in " + String.valueOf(DenizenCore.implementation.getScriptFolder()));
            hadError = true;
            Debug.echoError(e);
        }
        return new ArrayList<YamlConfiguration>();
    }

    public static void postLoad() {
        scriptSources = scriptSourcesInprogress;
        scriptOriginalNames = scriptOriginalNamesInprogress;
    }

    static {
        additionalScripts = new ArrayList();
        buildAdditionalScripts = new ArrayList<Consumer<List<YamlConfiguration>>>();
        hadError = false;
        scriptSources = new HashMap();
        scriptOriginalNames = new HashMap();
    }
}

