/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.generator.CommandExecutionGenerator;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.EnumHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractCommand {
    public static HashSet<String> noErrorCommandNames = new HashSet<String>(Arrays.asList("case", "default"));
    public String syntax = "No usage defined! See documentation for more information!";
    public List<String> docFlagArgs = new ArrayList<String>();
    public List<String> docPrefixes = new ArrayList<String>();
    private boolean preparseArgs = true;
    public boolean forceHold = false;
    public int minimumArguments = 0;
    public int maximumArguments = Integer.MAX_VALUE;
    public int prefixesThusFar = 0;
    public HashMap<String, Integer> prefixesHandled = new HashMap();
    public HashMap<String, Integer> booleansHandled = new HashMap();
    public HashMap<String, String> prefixRemapper = new HashMap();
    public HashMap<EnumHelper, Integer> enumsHandled = new HashMap();
    public HashMap<String, Integer> enumPrefixes = new HashMap();
    public boolean allowedDynamicPrefixes = false;
    public boolean anyPrefixSymbolAllowed = false;
    public int linearHandledCount = 0;
    public boolean generatorInfiniteArgs = false;
    public boolean generateDebug = true;
    public boolean isProcedural = false;
    protected String name;
    public CommandExecutionGenerator.CommandExecutor generatedExecutor;

    public void setSyntax(String syntax) {
        this.syntax = syntax;
        int firstSpace = syntax.indexOf(32);
        if (firstSpace < 0) {
            return;
        }
        String cleaned = syntax.substring(firstSpace).replace("/", " ");
        cleaned = cleaned.replace("[", "").replace("]", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "");
        List<String> args = CoreUtilities.split(cleaned, ' ');
        for (String arg : args) {
            if (arg.isEmpty()) continue;
            int colonIndex = arg.indexOf(58);
            if (colonIndex > 0) {
                String prefix = arg.substring(0, colonIndex);
                if (prefix.contains("<")) continue;
                this.docPrefixes.add(prefix);
                continue;
            }
            if (arg.contains("<") || arg.contains("|")) continue;
            this.docFlagArgs.add(arg);
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Command syntax '" + syntax + "' parsed to flat args: ( " + String.join((CharSequence)", ", this.docFlagArgs) + " ) and prefixes ( " + String.join((CharSequence)", ", this.docPrefixes) + " ).");
        }
    }

    public void addCustomTabCompletions(TabCompletionsBuilder tab) {
    }

    public void addRemappedPrefixes(String realName, String ... alts) {
        int n;
        Integer oldIndex = this.prefixesHandled.get(realName);
        if (oldIndex != null) {
            n = oldIndex;
        } else {
            int n2 = this.prefixesThusFar;
            n = n2;
            this.prefixesThusFar = n2 + 1;
        }
        int index = n;
        this.prefixesHandled.put(realName, index);
        for (String str : alts) {
            this.prefixesHandled.put(str, index);
        }
        for (String alt : alts) {
            this.prefixRemapper.put(alt, realName);
        }
    }

    public void setPrefixesHandled(String ... prefixes) {
        for (String str : prefixes) {
            this.setPrefixHandled(str);
        }
    }

    public int setPrefixHandled(String prefixes) {
        int index = this.prefixesThusFar++;
        this.prefixesHandled.put(prefixes, index);
        return index;
    }

    public void setBooleansHandled(String ... boolNames) {
        for (String str : boolNames) {
            this.setBooleanHandled(str);
        }
    }

    public int setBooleanHandled(String boolName) {
        int index = this.booleansHandled.size();
        this.booleansHandled.put(boolName, index);
        return index;
    }

    public int setEnumHandled(String prefix, Class<? extends Enum> enumType) {
        int index = this.enumsHandled.size();
        this.enumPrefixes.put(prefix, index);
        this.enumsHandled.put(EnumHelper.get(enumType), index);
        return index;
    }

    public static String db(String prefix, boolean value) {
        return "<G>" + prefix + "='<Y>" + value + "<G>'  ";
    }

    public static String db(String prefix, Object value) {
        if (value == null) {
            return "";
        }
        return ArgumentHelper.debugObj(prefix, value);
    }

    public void setRequiredArguments(int min, int max) {
        this.minimumArguments = min;
        this.maximumArguments = max == -1 ? Integer.MAX_VALUE : max;
    }

    public void setParseArgs(boolean parse) {
        this.preparseArgs = parse;
    }

    public boolean shouldPreParse() {
        return this.preparseArgs;
    }

    public void setName(String commandName) {
        this.name = CoreUtilities.toUpperCase(commandName);
    }

    public String getName() {
        return this.name;
    }

    public String getUsageHint() {
        return this.syntax;
    }

    public void onDisable() {
    }

    public void autoCompile() {
        this.generatedExecutor = CommandExecutionGenerator.generateExecutorFor(this.getClass(), this);
    }

    public void execute(ScriptEntry scriptEntry) {
        Debug.echoError("Something went wrong! Command '" + this.name + "' has no executor (or called wrongly)?");
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            arg.reportUnhandled();
        }
    }

    public static class TabCompletionsBuilder {
        public String arg;
        public ArrayList<String> completions = new ArrayList();
        public TagContext context;

        public final void addWithPrefix(String prefix, Iterable<String> values) {
            if (this.arg.startsWith(prefix)) {
                for (String val : values) {
                    this.add(prefix + val);
                }
            }
        }

        public final void addWithPrefix(String prefix, Enum<?>[] values) {
            if (this.arg.startsWith(prefix)) {
                for (Enum<?> val : values) {
                    this.add(prefix + val.name());
                }
            }
        }

        public final void add(String text) {
            if (CoreUtilities.toLowerCase(text).startsWith(this.arg)) {
                this.completions.add(text);
            }
        }

        public final void add(String a, String ... values) {
            this.add(a);
            for (String val : values) {
                this.add(val);
            }
        }

        public final void add(String[] values) {
            for (String val : values) {
                this.add(val);
            }
        }

        public final void add(Iterable<String> values) {
            for (String val : values) {
                this.add(val);
            }
        }

        public final void add(Enum<?>[] values) {
            for (Enum<?> val : values) {
                this.add(val.name());
            }
        }

        public final void addNotesOfType(Class<? extends Notable> type) {
            for (Notable note : NoteManager.notesByType.get(type)) {
                this.add(NoteManager.getSavedId(note));
            }
        }

        public final void addScriptsOfType(Class<? extends ScriptContainer> type) {
            for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
                if (!type.isAssignableFrom(script.getClass())) continue;
                this.add(script.getName());
            }
        }
    }
}

