/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;

public class EntityChangesBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public LocationTag location;
    public MaterialTag oldMaterial;
    public MaterialTag newMaterial;
    public EntityChangeBlockEvent event;

    public EntityChangesBlockScriptEvent() {
        this.registerCouldMatcher("<entity> changes <block> (into <block>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String entName = path.eventArgLowerAt(0);
        if (!this.entity.tryAdvancedMatcher(entName, path.context)) {
            return false;
        }
        if (!path.tryArgObject(2, this.oldMaterial)) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("into")) {
            String mat2 = path.eventArgLowerAt(4);
            if (mat2.isEmpty()) {
                Debug.echoError("Invalid event material [" + this.getName() + "]: '" + path.event + "' for " + path.container.getName());
                return false;
            }
            if (!this.newMaterial.tryAdvancedMatcher(mat2, path.context)) {
                return false;
            }
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity.getDenizenObject();
            case "location" -> this.location;
            case "new_material" -> this.newMaterial;
            case "old_material" -> this.oldMaterial;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityChangesBlock(EntityChangeBlockEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.oldMaterial = new MaterialTag(this.location.getBlock());
        this.newMaterial = new MaterialTag(event.getTo());
        this.event = event;
        this.fire((Event)event);
    }
}

