/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.entity.EntityMetadataCommandHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import java.util.List;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffectType;

public class InvisibleCommand
extends AbstractCommand {
    public static final EntityMetadataCommandHelper helper = new EntityMetadataCommandHelper(InvisibleCommand::isInvisible, InvisibleCommand::setInvisible);

    public InvisibleCommand() {
        this.setName("invisible");
        this.setSyntax("invisible (<entity>|...) ({true}/false/toggle/reset) (for:<player>|...)");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static boolean isInvisible(Entity entity) {
        if (EntityTag.isCitizensNPC(entity)) {
            InvisibleTrait invisibleTrait = (InvisibleTrait)NPCTag.fromEntity(entity).getCitizen().getTraitNullable(InvisibleTrait.class);
            return invisibleTrait != null && invisibleTrait.isInvisible();
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            return !armorStand.isVisible();
        }
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            return !itemFrame.isVisible();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.isInvisible() || livingEntity.hasPotionEffect(PotionEffectType.INVISIBILITY);
        }
        return NMSHandler.entityHelper.isInvisible(entity);
    }

    public static void setInvisible(EntityTag entity, boolean invisible) {
        if (entity.isCitizensNPC()) {
            ((InvisibleTrait)entity.getDenizenNPC().getCitizen().getOrAddTrait(InvisibleTrait.class)).setInvisible(invisible);
        } else {
            Entity entity2 = entity.getBukkitEntity();
            if (entity2 instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity2;
                armorStand.setVisible(!invisible);
            } else {
                entity2 = entity.getBukkitEntity();
                if (entity2 instanceof ItemFrame) {
                    ItemFrame itemFrame = (ItemFrame)entity2;
                    itemFrame.setVisible(!invisible);
                } else if (!entity.isFake && (entity2 = entity.getBukkitEntity()) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity2;
                    livingEntity.setInvisible(invisible);
                    if (!invisible) {
                        livingEntity.removePotionEffect(PotionEffectType.INVISIBILITY);
                    }
                } else {
                    NMSHandler.entityHelper.setInvisible(entity.getBukkitEntity(), invisible);
                }
            }
        }
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="target") @ArgLinear @ArgDefaultNull @ArgSubType(value=EntityTag.class) List<EntityTag> targets, @ArgName(value="state") @ArgDefaultText(value="true") EntityMetadataCommandHelper.Action action, @ArgName(value="for") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> forPlayers) {
        helper.execute(scriptEntry, targets, action, forPlayers);
    }
}

