/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(ok.class, (Class[])new Class[]{Map.class});

    public static pd toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> oi.b;
                case 1 -> oi.c;
                default -> oi.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return oy.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return op.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return os.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return on.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return ol.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new oh(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new oo(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new or(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return pb.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return om.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(pd nmsTag) {
        if (nmsTag instanceof oi) {
            oi nmsByteTag = (oi)nmsTag;
            return ByteBinaryTag.byteBinaryTag((byte)nmsByteTag.h());
        }
        if (nmsTag instanceof oy) {
            oy nmsShortTag = (oy)nmsTag;
            return ShortBinaryTag.shortBinaryTag((short)nmsShortTag.g());
        }
        if (nmsTag instanceof op) {
            op nmsIntTag = (op)nmsTag;
            return IntBinaryTag.intBinaryTag((int)nmsIntTag.f());
        }
        if (nmsTag instanceof os) {
            os nmsLongTag = (os)nmsTag;
            return LongBinaryTag.longBinaryTag((long)nmsLongTag.e());
        }
        if (nmsTag instanceof on) {
            on nmsFloatTag = (on)nmsTag;
            return FloatBinaryTag.floatBinaryTag((float)nmsFloatTag.j());
        }
        if (nmsTag instanceof ol) {
            ol nmsDoubleTag = (ol)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag((double)nmsDoubleTag.i());
        }
        if (nmsTag instanceof oh) {
            oh nmsByteArrayTag = (oh)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])nmsByteArrayTag.d());
        }
        if (nmsTag instanceof oo) {
            oo nmsIntArrayTag = (oo)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag((int[])nmsIntArrayTag.f());
        }
        if (nmsTag instanceof or) {
            or nmsLongArrayTag = (or)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag((long[])nmsLongArrayTag.f());
        }
        if (nmsTag instanceof pb) {
            pb nmsStringTag = (pb)nmsTag;
            return StringBinaryTag.stringBinaryTag((String)nmsStringTag.e_());
        }
        if (nmsTag instanceof oq) {
            oq nmsListTag = (oq)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof ok) {
            ok nmsCompoundTag = (ok)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof om) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.b().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(oq nmsListTag) {
        ListBinaryTag.Builder builder = ListBinaryTag.builder((int)nmsListTag.size());
        for (pd nmsValue : nmsListTag) {
            builder.add(NBTAdapter.toAPI(nmsValue));
        }
        return builder.build();
    }

    public static oq toNMS(ListBinaryTag listTag) {
        oq nmsListTag = new oq();
        for (BinaryTag value : listTag) {
            nmsListTag.add((Object)NBTAdapter.toNMS(value));
        }
        return nmsListTag;
    }

    public static CompoundBinaryTag toAPI(ok nmsCompoundTag) {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder((int)nmsCompoundTag.e());
        for (String key : nmsCompoundTag.d()) {
            builder.put(key, NBTAdapter.toAPI(nmsCompoundTag.c(key)));
        }
        return builder.build();
    }

    public static ok toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, pd> nmsTags = new HashMap<String, pd>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

