/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    public CastCommand() {
        this.setName("cast");
        this.setSyntax("cast [<effect>] (remove) (duration:<value>) (amplifier:<#>) (<entity>|...) (no_ambient) (hide_particles) (no_icon) (no_clear)");
        this.setRequiredArguments(1, 9);
        this.addRemappedPrefixes("duration", "d");
        this.addRemappedPrefixes("amplifier", "power", "p", "a");
        this.isProcedural = false;
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        for (PotionEffectType effect : PotionEffectType.values()) {
            tab.add(effect.getName());
        }
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="effect") @ArgLinear ObjectTag effectObject, @ArgName(value="remove") boolean remove, @ArgName(value="cancel") boolean cancel, @ArgName(value="duration") @ArgPrefixed @ArgDefaultText(value="60s") DurationTag duration, @ArgName(value="amplifier") @ArgPrefixed @ArgDefaultText(value="1") ElementTag amplifier, @ArgName(value="entities") @ArgLinear @ArgDefaultNull ObjectTag entitiesObject, @ArgName(value="no_ambient") boolean noAmbient, @ArgName(value="hide_particles") boolean hideParticles, @ArgName(value="no_icon") boolean noIcon, @ArgName(value="no_clear") boolean noClear) {
        List<EntityTag> entities;
        PotionEffectType effectType = PotionEffectType.getByName((String)effectObject.toString());
        if (effectType == null) {
            if (entitiesObject != null && (effectType = PotionEffectType.getByName((String)entitiesObject.toString())) != null) {
                Deprecations.outOfOrderArgs.warn(scriptEntry);
                ObjectTag swapEntities = entitiesObject;
                entitiesObject = effectObject;
                effectObject = swapEntities;
            }
            if (effectType == null) {
                throw new InvalidArgumentsRuntimeException("Invalid potion effect '" + String.valueOf(effectObject) + "' specified.");
            }
        }
        if (!amplifier.isInt()) {
            throw new InvalidArgumentsRuntimeException("Invalid amplifier '" + String.valueOf(amplifier) + "' specified: must be a valid number.");
        }
        List<EntityTag> list = entities = entitiesObject == null ? null : entitiesObject.asType(ListTag.class, scriptEntry.context).filter(EntityTag.class, scriptEntry.context);
        if (entities == null && (entities = Utilities.entryDefaultEntityList(scriptEntry, true)) == null) {
            throw new InvalidArgumentsRuntimeException("Must specify entities to apply the effect to.");
        }
        remove = remove || cancel;
        PotionEffect potion = null;
        if (!remove) {
            int ticks = duration.getSeconds() != 0.0 ? duration.getTicksAsInt() : (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) ? -1 : Integer.MAX_VALUE);
            potion = new PotionEffect(effectType, ticks, amplifier.asInt(), !noAmbient, !hideParticles, !noIcon);
        }
        for (EntityTag entity : entities) {
            if ((remove || !noClear) && entity.getLivingEntity().hasPotionEffect(effectType)) {
                entity.getLivingEntity().removePotionEffect(effectType);
            }
            if (remove || entity.getLivingEntity().addPotionEffect(potion)) continue;
            Debug.echoError("Bukkit was unable to apply '" + effectType.getName() + "' to '" + String.valueOf(entity) + "'.");
        }
    }
}

